#!/etc/opt/openit/perl
use strict;
use warnings;


my $old_powerbi_oconf = "/var/opt/openit/etc/scheduler/powerbi.oconf";
chomp (my $arc = `uname -m`);
my $x64 = "x86_64-unknown-linux";
my $x86 = "i686-redhat-linux";
my @lines;

open ( IN, $old_powerbi_oconf ) or die "ERROR: Unable to open powerbi.oconf!\n";

while ( <IN> ) {
    chomp;
    push ( @lines, $_ );
}

close ( IN );
rename ( $old_powerbi_oconf, "/var/opt/openit/etc/scheduler/powerbi.oconf.old_7.0.7" ) or die "ERROR: Unable to rename old powerbi.oconf file!\n";

open ( OUT, '>', "/var/opt/openit/etc/scheduler/powerbi.oconf" );

foreach my $line (@lines) {
    if ( $line =~ /value=\/opt\/openit\/libexec\/\$ARCH\/bin\/perl$/ ) {
        if ($arc =~ /x86_64/) {
            $line =~ s/value=\/opt\/openit\/libexec\/\$ARCH\/bin\/perl/value=\/opt\/openit\/libexec\/$x64\/bin\/perl/;
        }
        else {
            $line =~ s/value=\/opt\/openit\/libexec\/\$ARCH\/bin\/perl/value=\/opt\/openit\/libexec\/$x86\/bin\/perl/;
        } 
    }
    print OUT $line . "\n";
}

close ( OUT );
exit ( 0 );

