::-----------------------------------------
:: NAME:
::    OpeniT Patch Upgrade Script
:: AUTHOR:
::   Ferdinand Mercado
:: CREATED:
::    2/10/2015 9:18:32 PM GMT+8:00
:: DESCRIPTION:
::   This script will determine if installation is server or client and run the correct installation binary or script
::-----------------------------------------


@ECHO OFF
SETLOCAL
	
	net session >nul 2>&1
	if not %errorLevel% == 0 (
		call :ERRORMSG "Patch upgrade must be installed by a user with administrator rights."
		PAUSE
		exit /b
	)
	
    CALL :getSystemDetails
	CALL :installUpgrade %~1
ENDLOCAL
GOTO:EOF  
   

::--------------------------------------------------------------------------------------

:getSystemDetails
	set REGVAL_INSTALLDIR=InstallDir
	set RESOURCES_32=HKLM\SOFTWARE\OpeniT\Resources
	set RESOURCES_64=HKLM\SOFTWARE\Wow6432Node\OpeniT\Resources 
	REG QUERY %RESOURCES_64% /v %REGVAL_INSTALLDIR% >nul 2>nul ||( set REGVAL_RESOURCES=%RESOURCES_32% )
	REG QUERY %RESOURCES_32% /v %REGVAL_INSTALLDIR% >nul 2>nul ||( set REGVAL_RESOURCES=%RESOURCES_64% )
	
:getInstallationType
    REM Check for presence of key
    REG QUERY %REGVAL_RESOURCES% /v %REGVAL_INSTALLDIR% >nul || (echo Cannot locate installdir. OpeniT product may not be installed! & exit /b 1)
    set INSTALLDIR=
    for /f "tokens=2,*" %%a in ('reg query %REGVAL_RESOURCES% /v %REGVAL_INSTALLDIR% ^| findstr %REGVAL_INSTALLDIR%') do (
        set INSTALLDIR=%%b
    )
    REM get version current version
    set VERSION=
    for /f "tokens=2,*" %%a in ('reg query %REGVAL_RESOURCES% /v InstallVersion ^| findstr InstallVersion') do (
        set VERSION=%%b
    )
    
    set CONFIGDIR=%INSTALLDIR%Configuration
    
    call :DEBUGMSG "Got installdir directory '%INSTALLDIR%'"
    call :DEBUGMSG "Got installation version'%VERSION%'"

    IF EXIST "%CONFIGDIR%\main.conf" ( 
        set INTALLATION_TYPE=client
    ) ELSE IF EXIST "%CONFIGDIR%\server.conf" ( 
        set INTALLATION_TYPE=server
    ) ELSE (
        call :ERRORMSG "Cannot determine if installation is server or client"
		exit /b
    )
	call :DEBUGMSG "Installation:Windows %INTALLATION_TYPE%"
GOTO:EOF


:installUpgrade
	
	SET ROOT=%CD%
	CD /D %~dp0
	
	IF [%1] EQU [] (
		cd /D windows\%INTALLATION_TYPE%\files
		cmd /C "openit_freemould.exe --script install.oms"
	) ELSE IF "%1" == "-reinstall" (
		cd /D windows\%INTALLATION_TYPE%\files
		cmd /C "openit_freemould.exe --script install.oms --var reinstall=yes"
	) ELSE IF "%1" == "-silent" (
		cd /D windows\%INTALLATION_TYPE%
		cmd /C "install.exe --silent --reinstall"
	) ELSE IF "%1" == "-bundle" (
		cd /D windows\%INTALLATION_TYPE%\files
		cmd /C "openit_freemould.exe --script install.oms --var reinstall=yes --var waitbeforexit=no"
	) ELSE (
		CALL :VERBOSEMSG "Invalid argument '%1'"
		CALL :HELP
	)
	
GOTO:EOF

::--------------------------------------------------------------------------------------
:HELP
	CALL :VERBOSEMSG "Execute 'install.bat' to install upgrade."
	CALL :VERBOSEMSG "options:"
	CALL :VERBOSEMSG "-silent (Silent install)"
	CALL :VERBOSEMSG "-reinstall (Reinstall upgrade)"
GOTO:EOF
:DEBUGMSG
	::Remove comment to debug
    ::echo DEBUG: %~1
GOTO:EOF
:VERBOSEMSG
    echo.%~1
GOTO:EOF
:WARNINGMSG
    echo.WARNING: %~1
GOTO:EOF
:ERRORMSG
    echo.ERROR: %~1
GOTO:EOF










