/*
 * Decompiled with CFR 0.152.
 */
package com.openit.chart;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartLabel;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.data.JCURLDataSource;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCMultiColLegend;
import com.openit.chart.ChartResourceHandler;
import com.openit.chart.ChartStyleLoader;
import com.openit.lego.logging.Logger;
import com.openit.lego.logging.LoggerEvent;
import com.openit.lego.logging.LoggerListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;

public class OpenitChart
extends JApplet
implements Printable,
LoggerListener,
ActionListener,
MouseListener {
    private ChartResourceHandler resourceHandler;
    private Container mainPane;
    private JFrame printableCloneFrame;
    private JCChartChild chart;
    private JButton printButton;
    private JLabel statusLabel;
    private JMenuBar menu;
    private JMenuItem reset;
    private JMenu chartType;
    private JCheckBoxMenuItem logarithmic;
    private JCheckBoxMenuItem legend;
    private JCheckBoxMenuItem rotXAxis;
    private JCheckBoxMenuItem invertAxes;
    private JMenuItem advance;
    private JMenuItem save;
    private JMenuItem load;
    private JLabel help;
    private boolean noMinimumYValueSpecified = true;
    private boolean noMaximumYValueSpecified = true;
    private double minimumYValueFromParameter = 0.0;
    private double maximumYValueFromParameter = 0.0;
    private static String APPLET_INFO_STRING = "\u00a9 Copyright 1999-2005 by Open iT, Inc.";
    protected static int[] chartTypes = new int[]{8, 12, 9, 10, 0, 1, 11};
    protected static String[] chartTypeStrings = new String[]{"AREA", "STACKING_AREA", "BAR", "STACKING_BAR", "PLOT", "SCATTER_PLOT", "PIE"};
    protected HashMap typeToStringMappings = new HashMap();

    public void init() {
        super.init();
        Logger.initialize();
        Logger.setLevel(5);
        Logger.debug("Applet parameter-String: '" + this.paramString() + "'");
        this.resourceHandler = new ChartResourceHandler();
        for (int i = 0; i < chartTypeStrings.length; ++i) {
            String type = chartTypeStrings[i];
            String name = this.resourceHandler.getMessage("charttype." + type);
            this.typeToStringMappings.put(type, name);
        }
        this.mainPane = this.getContentPane();
        this.mainPane.setLayout(new BorderLayout());
        this.mainPane.add((Component)this.getChart(), "Center");
        this.setJMenuBar(this.getMenuBar());
        Logger.verbose("OpeniT Chart, " + this.getAppletInfo() + ", $Revision: 1.1.2.2 $");
    }

    private JCChart getChart() {
        if (this.chart == null) {
            this.chart = new JCChartChild();
            for (int i = 0; i < chartTypeStrings.length; ++i) {
                if (!this.getParameter("chart.data.chartType").equalsIgnoreCase(chartTypeStrings[i])) continue;
                this.chart.getDataView(0).setChartType(chartTypes[i]);
            }
            String dataParameter = this.getParameter("chart.dataFile");
            Logger.debug("Documentbase: '" + this.getDocumentBase() + "'");
            String dataSourceString = this.getDocumentBase().toString();
            dataSourceString = dataSourceString.substring(0, dataSourceString.lastIndexOf(47) + 1);
            dataSourceString = dataSourceString + dataParameter;
            Logger.debug("Datasource: '" + dataSourceString + "'");
            try {
                JCURLDataSource dataSource = new JCURLDataSource(dataSourceString);
                this.chart.getDataView(0).setDataSource((ChartDataModel)dataSource);
            }
            catch (MalformedURLException mURLe) {
                Logger.error("Unable to make proper URL for datafile, therefore unable to load data");
                mURLe.printStackTrace();
            }
            catch (IOException ioe) {
                Logger.error("Unable to load data from URL");
                ioe.printStackTrace();
            }
            this.initializeChartParameters(this.chart);
        }
        return this.chart;
    }

    private void initializeChartParameters(JCChart chart) {
        chart.setBackground(Color.white);
        chart.setTrigger(0, new EventTrigger(2, 1));
        chart.setTrigger(1, new EventTrigger(1, 2));
        chart.setTrigger(2, new EventTrigger(0, 0));
        chart.setAllowUserChanges(true);
        chart.setTrigger(0, new EventTrigger(4, 6));
        JLabel header = new JLabel(new ImageIcon("about-small.png"));
        chart.setHeader((JComponent)header);
        header.setVisible(true);
        JLabel footer = (JLabel)chart.getFooter();
        footer.setText(this.getParameter("chart.footer.text"));
        footer.setVisible(true);
        JCAxis yAxis = chart.getChartArea().getYAxis(0);
        yAxis.setGridVisible(true);
        yAxis.setGridSpacingIsDefault(true);
        yAxis.getGridStyle().getLineStyle().setColor(Color.gray);
        yAxis.setTitle(new JCAxisTitle(this.getParameter("chart.yaxis.title.text")));
        String yAxisMinimumString = this.getParameter("chart.yaxis.min");
        if (yAxisMinimumString != null) {
            this.minimumYValueFromParameter = this.getDoubleValueFromParameter("chart.yaxis.min");
            yAxis.setMin(this.minimumYValueFromParameter);
            chart.getDataView(0).getXAxis().setOrigin(this.minimumYValueFromParameter);
            Logger.verbose("Setting minimum-value for y-axis" + this.minimumYValueFromParameter + "'");
            this.noMinimumYValueSpecified = false;
        } else {
            Logger.debug("No minimum value found for y-Axis from applet parameters");
        }
        String yAxisMaximumString = this.getParameter("chart.yaxis.max");
        if (yAxisMaximumString != null) {
            this.maximumYValueFromParameter = this.getDoubleValueFromParameter("chart.yaxis.max");
            yAxis.setMax(this.maximumYValueFromParameter);
            Logger.verbose("Setting maximum-value for y-axis" + this.maximumYValueFromParameter + "'");
            this.noMaximumYValueSpecified = false;
        } else {
            Logger.debug("No maximum value found for y-Axis from applet parameters");
        }
        JCAxis xAxis = chart.getChartArea().getXAxis(0);
        xAxis.setTitle(new JCAxisTitle(this.getParameter("chart.xaxis.title.text")));
        String xAnnotationMethod = this.getParameter("chart.xaxis.annotationMethod");
        if (xAnnotationMethod.equals("Time_Labels")) {
            xAxis.setAnnotationMethod(2);
        } else {
            xAxis.setAnnotationMethod(3);
            xAxis.setGap(this.getIntValueFromParameter("chart.xaxis.gap"));
        }
        xAxis.setTimeBase(new Date(0L));
        this.dataLabelChart(chart);
        JCChartArea chartArea = chart.getChartArea();
        chartArea.setRotation(this.getIntValueFromParameter("chart.chartArea.rotation"));
        chartArea.setDepth(this.getIntValueFromParameter("chart.chartArea.depth"));
        chartArea.setElevation(this.getIntValueFromParameter("chart.chartArea.elevation"));
        ToolTipManager.sharedInstance().setReshowDelay(1000);
    }

    private JMenuBar getMenuBar() {
        if (this.menu == null) {
            this.menu = new JMenuBar();
            this.menu.setBackground(new Color(230, 230, 230));
            this.menu.setBorderPainted(false);
            JMenu file = this.getFileMenu();
            file.setBackground(new Color(230, 230, 230));
            JMenu settings = this.getSettingsMenu();
            settings.setBackground(new Color(230, 230, 230));
            file.add(this.getLoadChartStyle());
            file.add(this.getSaveChartStyle());
            settings.add(this.getResetChart());
            settings.add(this.getChartType());
            settings.add(this.getInvertAxes());
            settings.add(this.getToggleLogarithmic());
            settings.add(this.getToggleLegend());
            settings.add(this.getToggleLabelRotation());
            settings.addSeparator();
            settings.add(this.getAdvancedMenuItem());
            this.menu.add(file);
            this.menu.add(settings);
            this.menu.add(this.getHelp());
        }
        return this.menu;
    }

    private JLabel getHelp() {
        if (this.help == null) {
            this.help = new JLabel("?    ");
            String[] tokens = this.resourceHandler.getMessage("draginfo").split("\n");
            String tipText = "<HTML><DIV>";
            int i = 0;
            while (i < tokens.length) {
                tipText = tipText + tokens[i];
                if (++i >= tokens.length) continue;
                tipText = tipText + "<br>";
            }
            tipText = tipText + "</DIV></HTML>";
            this.help.setToolTipText(tipText);
            this.help.addMouseListener(this);
            this.menu.add(Box.createHorizontalGlue());
        }
        return this.help;
    }

    private JMenu getFileMenu() {
        JMenu file = new JMenu(this.resourceHandler.getMessage("menu.file"));
        file.setMnemonic(70);
        file.setDisplayedMnemonicIndex(0);
        return file;
    }

    private JMenu getSettingsMenu() {
        JMenu settings = new JMenu(this.resourceHandler.getMessage("menu.settings"));
        settings.setMnemonic(83);
        settings.setDisplayedMnemonicIndex(0);
        return settings;
    }

    private JMenuItem getLoadChartStyle() {
        if (this.load == null) {
            this.load = new JMenuItem(this.resourceHandler.getMessage("menuitem.load-style"));
            this.load.addActionListener(this);
            this.load.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
            this.load.setDisplayedMnemonicIndex(1);
        }
        return this.load;
    }

    private JMenuItem getSaveChartStyle() {
        if (this.save == null) {
            this.save = new JMenuItem(this.resourceHandler.getMessage("menuitem.save-style"));
            this.save.addActionListener(this);
            this.save.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
            this.save.setDisplayedMnemonicIndex(0);
        }
        return this.save;
    }

    private JMenuItem getResetChart() {
        if (this.reset == null) {
            this.reset = new JMenuItem(this.resourceHandler.getMessage("menuitem.reset-zoom"));
            this.reset.addActionListener(this);
            this.reset.setAccelerator(KeyStroke.getKeyStroke(90, 2, false));
            this.reset.setDisplayedMnemonicIndex(6);
        }
        return this.reset;
    }

    private JMenu getChartType() {
        if (this.chartType == null) {
            this.chartType = new JMenu(this.resourceHandler.getMessage("menu.charttype"));
            ButtonGroup group = new ButtonGroup();
            int numKey = 49;
            String type = this.getParameter("chart.data.chartType");
            for (int i = 0; i < chartTypeStrings.length; ++i) {
                String value = this.resourceHandler.getMessage("charttype." + chartTypeStrings[i]);
                JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem(value);
                group.add(rbMenuItem);
                this.chartType.add(rbMenuItem);
                if (chartTypeStrings[i].equalsIgnoreCase(type)) {
                    rbMenuItem.setSelected(true);
                }
                rbMenuItem.setAccelerator(KeyStroke.getKeyStroke(numKey + i, 2, false));
                rbMenuItem.addActionListener(this);
            }
        }
        return this.chartType;
    }

    private JCheckBoxMenuItem getInvertAxes() {
        if (this.invertAxes == null) {
            this.invertAxes = new JCheckBoxMenuItem(this.resourceHandler.getMessage("menuitem.invert-axes"));
            this.invertAxes.addActionListener(this);
            this.invertAxes.setAccelerator(KeyStroke.getKeyStroke(73, 2, false));
            this.invertAxes.setDisplayedMnemonicIndex(0);
        }
        return this.invertAxes;
    }

    private JMenuItem getToggleLegend() {
        if (this.legend == null) {
            JCMultiColLegend mclegend = new JCMultiColLegend();
            int maxRows = this.getSize().height / 20;
            double numColsD = new Double(this.chart.getDataView(0).getNumSeries()) / new Double(maxRows);
            mclegend.setNumColumns(new Double(Math.ceil(numColsD)).intValue());
            this.chart.setLegend((JCLegend)mclegend);
            boolean displayLegend = mclegend.getNumColumns() <= 2;
            this.chart.getLegend().setVisible(displayLegend);
            this.legend = new JCheckBoxMenuItem(this.resourceHandler.getMessage("checkbox.legend"));
            this.legend.addActionListener(this);
            this.legend.setSelected(displayLegend);
            this.legend.setAccelerator(KeyStroke.getKeyStroke(76, 2, false));
            this.legend.setDisplayedMnemonicIndex(0);
        }
        return this.legend;
    }

    private JMenuItem getToggleLogarithmic() {
        if (this.logarithmic == null) {
            this.logarithmic = new JCheckBoxMenuItem(this.resourceHandler.getMessage("checkbox.log"));
            this.logarithmic.addActionListener(this);
            this.logarithmic.setAccelerator(KeyStroke.getKeyStroke(71, 2, false));
            this.logarithmic.setDisplayedMnemonicIndex(2);
        }
        return this.logarithmic;
    }

    private JMenuItem getToggleLabelRotation() {
        if (this.rotXAxis == null) {
            this.rotXAxis = new JCheckBoxMenuItem(this.resourceHandler.getMessage("checkbox.labelrotate"));
            this.rotXAxis.addActionListener(this);
            this.rotXAxis.setAccelerator(KeyStroke.getKeyStroke(82, 2, false));
            this.rotXAxis.setDisplayedMnemonicIndex(0);
        }
        return this.rotXAxis;
    }

    private JMenuItem getAdvancedMenuItem() {
        if (this.advance == null) {
            this.advance = new JMenuItem(this.resourceHandler.getMessage("menuitem.advanced-settings"));
            this.advance.addActionListener(this);
            this.advance.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
            this.advance.setDisplayedMnemonicIndex(0);
        }
        return this.advance;
    }

    private JButton getPrintButton() {
        if (this.printButton == null) {
            this.printButton = new JButton("Print report");
            this.printButton.addActionListener(this);
        }
        return this.printButton;
    }

    private JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel("", 0);
            this.statusLabel.setOpaque(true);
            this.statusLabel.setBackground(Color.white);
            Logger.addLoggerListener(this, 3);
        }
        return this.statusLabel;
    }

    public void dataLabelChart(JCChart chart) {
        chart.setBatched(true);
        for (int nView = 0; nView < chart.getNumData(); ++nView) {
            Logger.trace("Data-labelling: Starting to look at view no. " + nView);
            ChartDataView view = chart.getDataView(nView);
            for (int nSeries = 0; nSeries < view.getNumSeries(); ++nSeries) {
                Logger.trace("Data-labelling: Starting to look at series no. " + nSeries);
                ChartDataViewSeries series = view.getSeries(nSeries);
                String dataLabel = series.getLabel().trim().length() > 0 ? series.getLabel().trim() + ":  " : "";
                for (int nPoint = series.getFirstPoint(); nPoint <= series.getLastPoint(); ++nPoint) {
                    Logger.trace("Data-labelling: looking at point " + nPoint);
                    if (series.getY(nPoint) == 0.0) continue;
                    JCChartLabel cl = new JCChartLabel(dataLabel + Double.toString(series.getY(nPoint)));
                    Logger.trace("Data-labelling: setting label of data to '" + dataLabel + Double.toString(series.getY(nPoint)) + "'");
                    cl.setDataIndex(new JCDataIndex(view, series, nSeries, nPoint));
                    cl.setAttachMethod(3);
                    cl.setDwellLabel(true);
                    cl.setAnchor(10);
                    chart.getChartLabelManager().addChartLabel(cl);
                }
            }
        }
        chart.setBatched(false);
    }

    private int getIntValueFromParameter(String appletParameter) {
        try {
            Integer parameterAsInteger = new Integer(this.getParameter(appletParameter));
            return parameterAsInteger;
        }
        catch (NumberFormatException nfe) {
            Logger.warning("Error formatting number from appletParameter '" + appletParameter + "'");
            nfe.printStackTrace();
            return 0;
        }
    }

    private double getDoubleValueFromParameter(String appletParameter) {
        try {
            Double parameterAsDouble = new Double(this.getParameter(appletParameter));
            return parameterAsDouble;
        }
        catch (NumberFormatException nfe) {
            Logger.warning("Error formatting number from appletParameter '" + appletParameter + "'");
            nfe.printStackTrace();
            return 0.0;
        }
    }

    public String getAppletInfo() {
        return APPLET_INFO_STRING;
    }

    public void chartPrint() {
        try {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setJobName("[Open iT] Chart print");
            printJob.setCopies(1);
            Book book = new Book();
            PageFormat documentPageFormat = new PageFormat();
            documentPageFormat = printJob.pageDialog(documentPageFormat);
            book.append(this, documentPageFormat);
            printJob.setPageable(book);
            if (!printJob.printDialog()) {
                return;
            }
            printJob.print();
        }
        catch (PrinterException px) {
            Logger.error("Chart cannot print");
            px.printStackTrace();
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        double origoX = pf.getImageableX();
        double origoY = pf.getImageableY();
        double height = pf.getImageableHeight();
        double width = pf.getImageableWidth();
        Logger.debug("Origo X: " + origoX + "; Origo Y: " + origoY + "; Height: " + height + "; Width: " + width);
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(origoX, origoY);
        g2.scale(0.7, 0.7);
        this.getContentPane().paint(g2);
        return 0;
    }

    public void messageLogged(LoggerEvent event) {
        this.statusLabel.setText("<HTML><FONT COLOR='red'>" + event + "</FONT></HTML>");
    }

    public void actionPerformed(ActionEvent event) {
        Logger.debug("ActionEvent taking place for OpeniT chart");
        JComponent source = (JComponent)event.getSource();
        if (source == this.reset) {
            this.resetAxes();
        } else if (source == this.logarithmic) {
            this.toggleLogarithmic((JCheckBoxMenuItem)source);
        } else if (source == this.printButton) {
            this.chartPrint();
        } else if (source == this.legend) {
            JCheckBoxMenuItem sourceCheckBox = (JCheckBoxMenuItem)source;
            Logger.verbose("Toggling showing of legend to " + sourceCheckBox.isSelected());
            this.chart.getLegend().setVisible(sourceCheckBox.isSelected());
        } else if (source == this.rotXAxis) {
            JCheckBoxMenuItem sourceCheckBox = (JCheckBoxMenuItem)source;
            JCAxis xAxis = this.chart.getChartArea().getXAxis(0);
            if (sourceCheckBox.isSelected()) {
                Logger.verbose("Rotating x-axis labels 90 degrees to left");
                xAxis.setAnnotationRotation(3);
            } else {
                Logger.verbose("Rotating x-axis labels to 0 degrees");
                xAxis.setAnnotationRotation(0);
            }
        } else if (source == this.advance) {
            this.chart.showLaunchPropertyPage();
        } else if (source == this.save) {
            Logger.verbose("Saving chart style");
            ChartStyleLoader csLoader = new ChartStyleLoader(this.chart);
            csLoader.createChartStyleFile();
        } else if (source == this.invertAxes) {
            Logger.verbose("Inverting Dataview Axes");
            this.invertDataviewAxes();
        } else if (source == this.load) {
            Logger.verbose("Loading chart style.");
            ChartStyleLoader csLoader = new ChartStyleLoader(this.chart);
            csLoader.loadChartStyleFile(this);
            this.resetAxes();
        } else {
            String name = ((AbstractButton)event.getSource()).getText();
            Logger.verbose(name);
            for (int i = 0; i < chartTypeStrings.length; ++i) {
                if (!name.equalsIgnoreCase(this.resourceHandler.getMessage("charttype." + chartTypeStrings[i]))) continue;
                this.chart.getDataView(0).setChartType(chartTypes[i]);
                Logger.verbose("Setting chart-type to " + chartTypeStrings[i]);
                break;
            }
        }
    }

    private void invertDataviewAxes() {
        List dataview = this.chart.getDataView();
        for (int i = 0; i < dataview.size(); ++i) {
            ChartDataView cDataView;
            boolean isInverted = (cDataView = (ChartDataView)dataview.get(i)).isInverted();
            cDataView.setInverted(!isInverted);
        }
    }

    private void resetAxes() {
        Logger.verbose("Resetting axes");
        this.chart.setBatched(true);
        ChartDataView dataView = this.chart.getDataView(0);
        dataView.getXAxis().setMinIsDefault(true);
        dataView.getXAxis().setMaxIsDefault(true);
        if (this.noMinimumYValueSpecified) {
            dataView.getYAxis().setMinIsDefault(true);
        } else {
            dataView.getYAxis().setMin(this.minimumYValueFromParameter);
        }
        if (this.noMaximumYValueSpecified) {
            dataView.getYAxis().setMaxIsDefault(true);
        } else {
            dataView.getYAxis().setMax(this.maximumYValueFromParameter);
        }
        this.chart.setBatched(false);
    }

    private void toggleLogarithmic(JCheckBoxMenuItem sourceCheckBox) {
        boolean isLogarithmic = sourceCheckBox.isSelected();
        if (isLogarithmic) {
            Logger.debug("Hole value: " + this.chart.getDataView(0).getHoleValue());
            this.chart.getDataView(0).setHoleValue(0.0);
            Logger.debug("Hole value: " + this.chart.getDataView(0).getHoleValue());
        } else {
            this.chart.getDataView(0).setHoleValue(-1.0);
        }
        Logger.verbose("Setting chart's 'logarithmic' to " + isLogarithmic);
        this.chart.getDataView(0).getYAxis().setLogarithmic(isLogarithmic);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (e.getSource() == this.help) {
            ToolTipManager.sharedInstance().setInitialDelay(0);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (e.getSource() == this.help) {
            ToolTipManager.sharedInstance().setInitialDelay(1000);
        }
    }

    class JCChartChild
    extends JCChart {
        public void showLaunchPropertyPage() {
            this.launchPropertyPage(new Point(0, 0));
        }
    }
}

