/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego.swing;

import com.openit.lego.ResourceHandler;
import com.openit.lego.logging.Logger;
import com.openit.lego.swing.SwingConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;

public class TitleList
extends JPanel {
    public JList list;
    private JScrollPane scrollpane;
    private JLabel titleLabel;
    private DefaultListModel model;
    private ResourceHandler resources;

    public TitleList(String title, boolean multi, ResourceHandler _resources) {
        super(new BorderLayout());
        this.resources = _resources;
        Logger.debug("Creating Titlelist with title '" + title + "'. Multi = " + new Boolean(multi));
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        if (!multi) {
            this.list.setSelectionMode(0);
        }
        this.titleLabel = new JLabel(title);
        this.add((Component)this.titleLabel, "North");
        this.scrollpane = new JScrollPane(this.list);
        this.add((Component)this.scrollpane, "Center");
        this.list.setFont(SwingConstants.FNT_LISTBOX);
    }

    public void removeAll() {
        if (this.getItemCount() > 0) {
            int[] selectedIndexes = this.getSelectedIndexes();
            for (int i = 0; i < selectedIndexes.length; ++i) {
                this.deselect(selectedIndexes[i]);
            }
            for (int j = this.getItemCount() - 1; j >= 0; --j) {
                this.delItem(j);
            }
            this.removeAll();
        }
    }

    public void addItem(String item) {
        this.model.addElement(item);
    }

    public void delItem(int index) {
        this.model.removeElementAt(index);
    }

    public void replaceItem(String item, int index) {
        this.model.removeElementAt(index);
        this.model.insertElementAt(item, index);
    }

    public String getItem(int n) {
        return this.model.get(n).toString();
    }

    public int getRows() {
        return this.model.size();
    }

    public int getSelectedRows() {
        return this.getSelectedIndexes().length;
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public int[] getSelectedIndexes() {
        int[] selectedIndexes = this.list.getSelectedIndices();
        return selectedIndexes == null ? new int[]{} : selectedIndexes;
    }

    public String getSelectedItem() {
        Object selectedItem = this.list.getSelectedValue();
        return selectedItem == null ? null : selectedItem.toString();
    }

    public String[] getSelectedItems() {
        String[] selectedItems = new String[this.list.getSelectedValues().length];
        selectedItems = (String[])this.list.getSelectedValues();
        return selectedItems;
    }

    public int getSelectedNumber(String str) {
        int c = 0;
        int len = this.getItemCount();
        for (int i = 0; i < len; ++i) {
            if (!this.isIndexSelected(i)) continue;
            ++c;
            if (!str.equals(this.getItem(i))) continue;
            return c;
        }
        return 0;
    }

    public int getOrdinalNumber(String str) {
        int len = this.getItemCount();
        for (int i = 0; i < len; ++i) {
            if (!str.equals(this.getItem(i))) continue;
            return i;
        }
        return -1;
    }

    public void deselect(int n) {
        this.list.removeSelectionInterval(n, n);
    }

    public int getItemCount() {
        return this.model.size();
    }

    public boolean isIndexSelected(int n) {
        return this.list.isSelectedIndex(n);
    }

    public void addUnique(String s) {
        boolean found = false;
        int c = this.getItemCount();
        for (int i = 0; i < c; ++i) {
            if (!s.equals(this.getItem(i))) continue;
            found = true;
        }
        if (!found) {
            this.addItem(s);
        }
    }

    public void removeCurFromVector(JButton but, Vector vec) {
        int i = this.getSelectedIndex();
        this.delItem(i);
        but.setEnabled(false);
        vec.removeElementAt(i);
    }

    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
        this.titleLabel.setEnabled(enabled);
    }

    public boolean isThisMyJList(Object stranger) {
        return stranger == this.list;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }
}

