/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego.swing;

import com.openit.lego.logging.Logger;
import com.openit.lego.logging.LoggerEvent;
import com.openit.lego.logging.LoggerListener;
import com.openit.lego.swing.SwingConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class StatusPanel
extends JPanel
implements LoggerListener {
    private JTextArea textarea = null;
    private JScrollPane scrollpane = null;
    private Border border = null;

    public StatusPanel(int rows, int columns, String initialMessage) {
        this.setLayout(new BorderLayout());
        this.textarea = new JTextArea();
        this.textarea.setRows(rows);
        this.textarea.setEditable(false);
        this.textarea.setLineWrap(true);
        this.textarea.setBackground(SwingConstants.COL_BG_PRIMARY);
        this.textarea.setFont(SwingConstants.FNT_DEFAULT);
        this.textarea.append(initialMessage);
        this.scrollpane = new JScrollPane(this.textarea, 20, 31);
        this.border = BorderFactory.createLoweredBevelBorder();
        this.scrollpane.setBorder(this.border);
        this.add((Component)this.scrollpane, "Center");
        Logger.addLoggerListener(this, 4);
    }

    public void messageLogged(LoggerEvent le) {
        String message = "";
        message = le.getLevel() <= 3 ? le.toString() : le.getMessage();
        this.textarea.append("\n  " + message);
        this.textarea.setCaretPosition(this.textarea.getDocument().getLength() - 1);
    }
}

