/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego.swing;

import com.openit.lego.swing.DayPanel;
import com.openit.lego.swing.YearMonthPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JPanel;

public class CalendarPanel
extends JPanel {
    private int year;
    private int month;
    private int dayOfMonth;
    private DayPanel dp = null;
    private YearMonthPanel ymp;

    public CalendarPanel() {
        GregorianCalendar calendar = new GregorianCalendar();
        this.dp = new DayPanel(this);
        this.ymp = new YearMonthPanel(this, this.getMonth(), this.year, this.year - 3, this.year + 2);
        this.year = calendar.get(1);
        this.setMonth(calendar.get(2) + 1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.ymp, "North");
        this.add((Component)this.dp, "Center");
    }

    public int getDay() {
        if (this.dayOfMonth == 0) {
            throw new RuntimeException("No day of month selected.");
        }
        return this.dayOfMonth;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public void setDay(int inday) {
        this.dayOfMonth = inday;
    }

    protected void setMonth(int inmonth) {
        this.month = inmonth;
        this.dayOfMonth = 0;
        this.addDays();
    }

    protected void setYear(int inyear) {
        this.year = inyear;
        this.dayOfMonth = 0;
        this.addDays();
    }

    public void setDate(int inyear, int inmonth, int inday) {
        this.year = inyear;
        this.month = inmonth;
        this.dayOfMonth = inday;
        this.addDays();
        this.ymp.setMonth(this.month);
        this.ymp.setYear(this.year);
    }

    public void addDays() {
        this.invalidate();
        JButton focus = this.dp.drawDays(this.year, this.month);
        this.validate();
        if (focus != null) {
            focus.requestFocus();
        }
    }
}

