/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import java.io.Serializable;

public class JCDataIndex
implements Serializable {
    protected Object obj = null;
    protected ChartDataView dataView = null;
    protected ChartDataViewSeries series = null;
    protected int seriesIndex = -1;
    protected int point = -1;
    protected int distance = Integer.MAX_VALUE;

    public JCDataIndex() {
    }

    public JCDataIndex(int n, ChartDataViewSeries chartDataViewSeries) {
        this.point = n;
        this.series = chartDataViewSeries;
        if (chartDataViewSeries != null) {
            this.seriesIndex = chartDataViewSeries.getParent().getSeriesIndex(chartDataViewSeries);
            this.dataView = chartDataViewSeries.getParent();
        }
    }

    public JCDataIndex(ChartDataView chartDataView, ChartDataViewSeries chartDataViewSeries, int n, int n2) {
        this.dataView = chartDataView;
        this.point = n2;
        this.series = chartDataViewSeries;
        this.seriesIndex = n;
    }

    JCDataIndex(int n, ChartDataViewSeries chartDataViewSeries, int n2) {
        this.point = n;
        this.series = chartDataViewSeries;
        this.seriesIndex = n2;
    }

    public ChartDataViewSeries getSeries() {
        if (this.series == null && this.dataView != null && this.seriesIndex >= 0) {
            try {
                this.series = this.dataView.getSeries(this.seriesIndex);
            }
            catch (Exception exception) {
                this.series = null;
            }
        }
        return this.series;
    }

    public void setSeries(ChartDataViewSeries chartDataViewSeries) {
        this.series = chartDataViewSeries;
        this.seriesIndex = chartDataViewSeries.getParent().getSeriesIndex(chartDataViewSeries);
        this.dataView = chartDataViewSeries.getParent();
    }

    public ChartDataView getDataView() {
        return this.dataView;
    }

    public void setDataView(ChartDataView chartDataView) {
        this.dataView = chartDataView;
        if (this.dataView != null && this.seriesIndex >= 0) {
            this.series = this.dataView.getSeries(this.seriesIndex);
        }
    }

    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public void setSeriesIndex(int n) {
        this.seriesIndex = n;
        if (this.dataView != null && n >= 0) {
            this.series = this.dataView.getSeries(n);
        }
    }

    public int getPoint() {
        return this.point;
    }

    public void setPoint(int n) {
        this.point = n;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int n) {
        this.distance = n;
    }

    public Object getObject() {
        return this.obj;
    }

    public void setObject(Object object) {
        this.obj = object;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof JCDataIndex) {
            JCDataIndex jCDataIndex = (JCDataIndex)object;
            return this.dataView == jCDataIndex.dataView && this.seriesIndex == jCDataIndex.seriesIndex && this.point == jCDataIndex.point;
        }
        return false;
    }

    public int hashCode() {
        return this.dataView.hashCode() + 10000 * this.seriesIndex + this.point;
    }

    public String toString() {
        return "JCDataIndex: point " + this.point + " series " + this.seriesIndex + " dataview " + this.dataView;
    }
}

