/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego.swing;

import com.openit.lego.date.DateInfo;
import com.openit.lego.logging.Logger;
import com.openit.lego.swing.CalendarPanel;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class YearMonthPanel
extends JPanel
implements ItemListener {
    CalendarPanel calendar;
    private JComboBox CHO_Month;
    private JComboBox CHO_Year;
    private int minYear;
    private int maxYear;

    public YearMonthPanel(CalendarPanel caller, int mymonth, int myyear, int minYearIn, int maxYearIn) {
        int i;
        this.minYear = minYearIn;
        this.maxYear = maxYearIn;
        this.calendar = caller;
        this.setLayout(new FlowLayout());
        this.CHO_Year = new JComboBox();
        this.CHO_Year.addItemListener(this);
        for (i = minYearIn; i <= maxYearIn; ++i) {
            this.CHO_Year.addItem("" + i);
        }
        this.CHO_Year.setSelectedItem("" + myyear);
        this.add(this.CHO_Year);
        this.CHO_Month = new JComboBox();
        this.CHO_Month.addItemListener(this);
        for (i = 0; i < 12; ++i) {
            this.CHO_Month.addItem(DateInfo.monthname[i]);
        }
        this.CHO_Month.setSelectedIndex(mymonth - 1);
        this.add(this.CHO_Month);
    }

    public void setMonth(int inmonth) {
        this.CHO_Month.setSelectedIndex(inmonth - 1);
    }

    public void setYear(int inyear) {
        this.CHO_Year.setSelectedIndex(inyear - this.minYear);
    }

    public void itemStateChanged(ItemEvent ie) {
        Object source = ie.getSource();
        if (source == this.CHO_Month) {
            for (int i = 0; i < 12; ++i) {
                if (!DateInfo.monthname[i].equals((String)ie.getItem())) continue;
                this.calendar.setMonth(i + 1);
                break;
            }
        } else if (source == this.CHO_Year) {
            int year = 0;
            try {
                year = Integer.parseInt((String)ie.getItem());
            }
            catch (Exception ex) {
                return;
            }
            this.calendar.setYear(year);
        } else {
            Logger.error("YearMonthPanel: Unregonized source for itemStateChanged.");
        }
    }
}

