/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util;

import com.sitraka.licensing.util.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class Platform {
    private static int numCPUS = -1;
    private static String hostName = null;
    private static final int WINDOWS_9X = 0;
    private static final int WINDOWS = 1;
    private static final int SOLARIS = 2;
    private static final int LINUX = 3;
    private static final int AIX = 4;
    private static final int HPUX = 5;
    private static final int MACOS = 6;
    private static final int OSX = 7;
    private static final int OS2 = 9;
    private static final int ZOS = 10;
    private static int platform = -1;
    private static final String[] CMD_ENV_WINNT = new String[]{"cmd.exe", "/c", "set"};
    private static final String[] CMD_ENV_WIN9X = new String[]{"command.com", "/c", "set"};
    private static final String[] CMD_CPU_SOLARIS = new String[]{"/usr/bin/uname", "-X"};
    private static final String[] CMD_CPU_AIX = new String[]{"/usr/sbin/lsdev", "-Cc", "processor"};
    private static final String[] CMD_CPU_HPUX = new String[]{"/bin/sh", "-c", "/usr/bin/sar -M 1 1 | awk 'END {print NR-5}'"};
    private static final String[] CMD_CPU_ZOS = new String[]{"license"};
    private static final String[] CMD_HOST_UNIX = new String[]{"/usr/bin/uname", "-n"};
    static /* synthetic */ Class class$com$sitraka$licensing$util$Platform;

    public static int getNumberProcessors() {
        if (numCPUS != -1) {
            return numCPUS;
        }
        String data = null;
        switch (Platform.getPlatform()) {
            case 0: {
                data = Platform.executeCommand(CMD_ENV_WIN9X);
                numCPUS = Platform.readPropertyInt(data, "NUMBER_OF_PROCESSORS", "=");
                break;
            }
            case 1: {
                data = Platform.executeCommand(CMD_ENV_WINNT);
                numCPUS = Platform.readPropertyInt(data, "NUMBER_OF_PROCESSORS", "=");
                break;
            }
            case 2: {
                data = Platform.executeCommand(CMD_CPU_SOLARIS);
                numCPUS = Platform.readPropertyInt(data, "NumCPU", "=");
                break;
            }
            case 3: {
                data = Platform.readFile("/proc/cpuinfo");
                numCPUS = Platform.countLines(data, "processor");
                break;
            }
            case 4: {
                data = Platform.executeCommand(CMD_CPU_AIX);
                numCPUS = Platform.countLines(data, "Available");
                break;
            }
            case 5: {
                data = Platform.executeCommand(CMD_CPU_HPUX);
                try {
                    numCPUS = Integer.parseInt(data.trim());
                }
                catch (NumberFormatException nfe) {
                    Debug.println("NumberProcessors", "getNumCPUS()\n" + nfe.toString());
                }
                break;
            }
            case 10: {
                data = Platform.executeCommand(CMD_CPU_ZOS);
                numCPUS = Platform.readPropertyInt(data, "cpus", "=");
                break;
            }
        }
        if (numCPUS == 0) {
            numCPUS = -1;
        }
        Debug.println("NumberProcessors", "getNumCPUS(): determined that there are " + numCPUS);
        return numCPUS;
    }

    public static String getHostName() {
        if (hostName != null) {
            return hostName;
        }
        switch (Platform.getPlatform()) {
            case 0: {
                hostName = Platform.readProperty(Platform.executeCommand(CMD_ENV_WIN9X), "COMPUTERNAME", "=");
                break;
            }
            case 1: {
                hostName = Platform.readProperty(Platform.executeCommand(CMD_ENV_WINNT), "COMPUTERNAME", "=");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                hostName = Platform.executeCommand(CMD_HOST_UNIX);
                break;
            }
        }
        return hostName;
    }

    /*
     * WARNING - void declaration
     */
    private static String readFile(String filename) {
        StringBuffer result = new StringBuffer();
        File file = new File(filename);
        if (file.isFile() && file.canRead()) {
            try {
                int len;
                FileReader reader = new FileReader(file);
                char[] buffer = new char[1024];
                while ((len = reader.read(buffer, 0, 1023)) != -1) {
                    void var5_7;
                    result.append(buffer, 0, (int)var5_7);
                }
                reader.close();
            }
            catch (FileNotFoundException fnfe) {
                Debug.println("NumberProcessors", "readFile(" + filename + ")\n" + fnfe.toString());
            }
            catch (IOException ioe) {
                Debug.println("NumberProcessors", "readFile(" + filename + ")\n" + ioe.toString());
            }
        } else {
            Debug.println("NumberProcessors", "readFile(" + filename + ") cannot read named file");
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String executeCommand(String[] commandLine) {
        Process child = null;
        StringBuffer result = new StringBuffer();
        try {
            try {
                int n;
                child = Runtime.getRuntime().exec(commandLine);
                InputStreamReader inputStream = new InputStreamReader(child.getInputStream());
                char[] buffer = new char[1024];
                while ((n = inputStream.read(buffer)) != -1) {
                    void var5_6;
                    result.append(buffer, 0, (int)var5_6);
                }
            }
            catch (IOException ioe) {
                Debug.println("NumberProcessors", "executeCommand(): " + ioe.toString());
                Object var7_8 = null;
                if (child != null) {
                    child.destroy();
                }
            }
            Object var7_7 = null;
            if (child != null) {
                child.destroy();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (child != null) {
                child.destroy();
            }
            throw throwable;
        }
        return result.toString();
    }

    private static int readPropertyInt(String data, String propName, String delim) {
        if (data == null || propName == null) {
            return 0;
        }
        String value = Platform.readProperty(data, propName, delim);
        int result = 0;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                result = 0;
                Debug.println("NumberProcessors", "readPropertyInt(" + propName + ")\n" + nfe.toString());
            }
        }
        return result;
    }

    private static String readProperty(String data, String propName, String delim) {
        StringTokenizer toker = new StringTokenizer(data, "\n");
        while (toker.hasMoreTokens()) {
            int idx;
            String currentLine = toker.nextToken();
            if (currentLine == null || currentLine.indexOf(propName) == -1 || (idx = currentLine.indexOf(delim)) == -1) continue;
            return currentLine.substring(idx + 1).trim();
        }
        return null;
    }

    private static int countLines(String data, String line) {
        if (data == null || line == null) {
            return 0;
        }
        int count = 0;
        String delim = "\n";
        StringTokenizer toker = new StringTokenizer(data, delim);
        while (toker.hasMoreTokens()) {
            String currentLine = toker.nextToken();
            if (currentLine == null || currentLine.indexOf(line) == -1) continue;
            ++count;
        }
        return count;
    }

    private static int getPlatform() {
        if (platform == -1) {
            String osname = System.getProperty("os.name").toLowerCase();
            String osver = System.getProperty("os.version").toLowerCase();
            if (osname.indexOf("mac os") >= 0) {
                try {
                    int majorVersion = Integer.parseInt(osver.substring(0, osver.indexOf(46)));
                    if (majorVersion >= 10) {
                        platform = 7;
                    }
                }
                catch (NumberFormatException e) {
                    platform = 6;
                }
            } else if (osname.indexOf("os/2") >= 0) {
                platform = 9;
            } else if (osname.indexOf("indows") >= 0) {
                platform = osname.indexOf("nt") >= 0 || osname.indexOf("2000") >= 0 || osname.indexOf("xp") >= 0 ? 1 : 0;
            } else if (osname.indexOf("linux") != -1) {
                platform = 3;
            } else if (osname.indexOf("aix") != -1) {
                platform = 4;
            } else if (osname.indexOf("sunos") != -1 || osname.indexOf("solaris") != -1) {
                platform = 2;
            } else if (osname.indexOf("hpux") != -1 || osname.indexOf("hp-ux") != -1) {
                platform = 5;
            } else if (osname.indexOf("z/os") != -1 || osname.indexOf("os/390") != -1) {
                platform = 10;
            } else {
                Debug.println("NumberProcessors", "getPlatform() unsupported OS " + osname);
                platform = -1;
            }
        }
        return platform;
    }

    public static void main(String[] args) {
        System.out.println("Testing: " + (class$com$sitraka$licensing$util$Platform == null ? (class$com$sitraka$licensing$util$Platform = Platform.class$("com.sitraka.licensing.util.Platform")) : class$com$sitraka$licensing$util$Platform).getName());
        System.out.println("\tos.name: " + System.getProperty("os.name"));
        System.out.println("\tos.arch: " + System.getProperty("os.arch"));
        System.out.println("\tos.version: " + System.getProperty("os.version"));
        System.out.println("\tPlatform code: " + Platform.getPlatform());
        System.out.println("\tNumber of processors: " + Platform.getNumberProcessors());
        System.out.println("\tHost name: " + Platform.getHostName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

