/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.swing.encode.AbstractImageEncoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGEncoder
extends AbstractImageEncoder {
    public void encode(Component component, OutputStream outputStream) throws IOException, EncoderException {
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument(null, "svg", null);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
        sVGGraphics2D.setClip(0, 0, component.getSize().width, component.getSize().height);
        if (!component.isShowing() && component instanceof ServerRenderable) {
            ((ServerRenderable)((Object)component)).serverPaint((Graphics)sVGGraphics2D);
        } else {
            component.paint((Graphics)sVGGraphics2D);
        }
        boolean bl = false;
        int n = component.getSize().width;
        int n2 = component.getSize().height;
        sVGGraphics2D.setSVGCanvasSize(new Dimension(n, n2));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        sVGGraphics2D.stream((Writer)outputStreamWriter, bl);
    }

    public void saveImage(Image image, OutputStream outputStream) throws IOException, EncoderException {
        this.error("SVG Encoder does not support Image encoding.  Use component.");
    }
}

