/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.swing.JCSwingWorker;
import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class JCHTMLPane
extends JEditorPane
implements Serializable {
    protected boolean inLink = false;
    protected Cursor defaultCursor = null;
    protected Cursor handCursor = null;
    protected Cursor waitCursor = null;

    public JCHTMLPane() {
        this.setEditable(false);
        this.setContentType("text/html");
        this.addHyperlinkListener(new LinkListener());
    }

    public JCHTMLPane(URL uRL) {
        this.setEditable(false);
        this.setContentType("text/html");
        Document document = this.getDocument();
        try {
            this.setPage(uRL);
        }
        catch (IOException iOException) {
            this.setDocument(document);
            this.getToolkit().beep();
        }
        this.addHyperlinkListener(new LinkListener());
    }

    public JCHTMLPane(String string) {
        this.setEditable(false);
        this.setContentType("text/html");
        this.setText(string);
        this.addHyperlinkListener(new LinkListener());
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public URL getPage() {
        return super.getPage();
    }

    public void setPage(URL uRL) throws IOException {
        super.setPage(uRL);
    }

    protected void enterLink() {
        this.inLink = true;
        this.switchCursorToHand();
    }

    protected void exitLink() {
        this.inLink = false;
        this.restoreCursor();
    }

    protected void followLink(URL uRL) {
        new PageLoader(uRL);
    }

    protected void switchCursorToHand() {
        if (this.defaultCursor == null) {
            this.defaultCursor = this.getCursor();
        }
        if (this.handCursor == null) {
            this.handCursor = Cursor.getPredefinedCursor(12);
        }
        this.setCursor(this.handCursor);
    }

    protected void restoreCursor() {
        if (this.inLink) {
            this.setCursor(this.handCursor);
        } else {
            this.setCursor(this.defaultCursor);
        }
    }

    protected void switchCursorToWait() {
        if (this.defaultCursor == null) {
            this.defaultCursor = this.getCursor();
        }
        if (this.waitCursor == null) {
            this.waitCursor = Cursor.getPredefinedCursor(3);
        }
        this.setCursor(this.waitCursor);
    }

    class PageLoader
    extends JCSwingWorker
    implements Serializable {
        protected URL url;
        protected Cursor savedCursor;
        protected JCHTMLPane pane;

        public PageLoader(URL uRL) {
            this(jCHTMLPane, uRL);
        }

        public PageLoader(JCHTMLPane jCHTMLPane2, URL uRL) {
            this.url = uRL;
            this.pane = jCHTMLPane2;
        }

        public void start() {
            JCHTMLPane.this.switchCursorToWait();
        }

        public Object construct() {
            Runnable runnable = new Runnable(this){
                private final /* synthetic */ PageLoader this$1;
                {
                    this.this$1 = pageLoader;
                }

                public void run() {
                    Document document = this.this$1.pane.getDocument();
                    try {
                        this.this$1.pane.setPage(this.this$1.url);
                    }
                    catch (IOException iOException) {
                        this.this$1.pane.setDocument(document);
                        PageLoader.access$000(this.this$1).getToolkit().beep();
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
            return null;
        }

        public void finished() {
            JCHTMLPane.this.restoreCursor();
            Container container = this.pane.getParent();
            container.repaint();
        }

        static /* synthetic */ JCHTMLPane access$000(PageLoader pageLoader) {
            return pageLoader.JCHTMLPane.this;
        }
    }

    class LinkListener
    implements HyperlinkListener,
    Serializable {
        LinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
            if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
                JCHTMLPane.this.followLink(hyperlinkEvent.getURL());
            } else if (eventType == HyperlinkEvent.EventType.ENTERED) {
                JCHTMLPane.this.enterLink();
            } else if (eventType == HyperlinkEvent.EventType.EXITED) {
                JCHTMLPane.this.exitLink();
            }
        }
    }
}

