/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.LabelledChartDataModel;
import com.klg.jclass.chart.data.BaseDataSource;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDataHandler
extends DefaultHandler {
    private static int lowCharacterBound = 32;
    private static int highCharacterBound = 126;
    protected StringBuffer sb = null;
    protected Double curValue = null;
    protected BaseDataSource baseDS = null;
    protected ArrayList xData = null;
    protected ArrayList yData = null;
    protected ArrayList xDataArrays = null;
    protected ArrayList yDataArrays = null;
    protected ArrayList seriesLabels = null;
    protected ArrayList pointLabels = null;
    protected String seriesLabel = null;
    protected String pointLabel = null;
    protected boolean inSeries = false;
    protected boolean inPoint = false;
    protected boolean usingSeries = true;
    protected boolean newTags = true;
    protected String XML_DS = null;
    protected String XML_DS_ATT_NAME = null;
    protected String XML_DS_ATT_HOLE = null;
    protected String XML_DS_SERIES = null;
    protected String XML_DS_SERIESLABEL = null;
    protected String XML_DS_POINT = null;
    protected String XML_DS_POINTLABEL = null;
    protected String XML_DS_XDATA = null;
    protected String XML_DS_YDATA = null;

    public XMLDataHandler(BaseDataSource baseDataSource) {
        this.baseDS = baseDataSource;
        this.useNewTags();
    }

    public void useNewTags() {
        this.XML_DS = "chart-data";
        this.XML_DS_ATT_NAME = "name";
        this.XML_DS_ATT_HOLE = "hole";
        this.XML_DS_SERIES = "data-series";
        this.XML_DS_SERIESLABEL = "data-series-label";
        this.XML_DS_POINT = "data-point";
        this.XML_DS_POINTLABEL = "data-point-label";
        this.XML_DS_XDATA = "x-data";
        this.XML_DS_YDATA = "y-data";
        this.newTags = true;
    }

    public void useOldTags() {
        this.XML_DS = "JCChartData";
        this.XML_DS_ATT_NAME = "Name";
        this.XML_DS_ATT_HOLE = "Hole";
        this.XML_DS_SERIES = "Series";
        this.XML_DS_SERIESLABEL = "SeriesLabel";
        this.XML_DS_POINT = "Point";
        this.XML_DS_POINTLABEL = "PointLabel";
        this.XML_DS_XDATA = "XData";
        this.XML_DS_YDATA = "YData";
        this.newTags = false;
    }

    public static void setCharacterBounds(int n, int n2) {
        if (n > n2 || n < 0) {
            throw new IllegalArgumentException("Illegal bounds - lower:" + n + " higher:" + n2);
        }
        lowCharacterBound = n;
        highCharacterBound = n2;
    }

    public static int getLowCharacterBound() {
        return lowCharacterBound;
    }

    public static int getHighCharacterBound() {
        return highCharacterBound;
    }

    public BaseDataSource getDataSource() {
        return this.baseDS;
    }

    public void setDataSource(BaseDataSource baseDataSource) {
        this.baseDS = baseDataSource;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.handleStartElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.handleEndElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.handleCharacters(cArray, n, n2);
    }

    public void handleStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.baseDS == null) {
            return;
        }
        if (string3.equals("JCChartData") && this.newTags) {
            this.useOldTags();
        } else if (string3.equals("chart-data") && !this.newTags) {
            this.useNewTags();
        }
        if (string3.equals(this.XML_DS_SERIES)) {
            this.inSeries = true;
            this.usingSeries = true;
            if (this.xData == null) {
                this.xData = new ArrayList();
            }
            if (this.yData == null) {
                this.yData = new ArrayList();
            }
        } else if (string3.equals(this.XML_DS_POINT)) {
            this.inPoint = true;
            this.usingSeries = false;
            if (this.xData == null) {
                this.xData = new ArrayList();
            }
            if (this.yData == null) {
                this.yData = new ArrayList();
            }
        } else if (string3.equals(this.XML_DS)) {
            if (attributes != null) {
                int n = attributes.getIndex(this.XML_DS_ATT_NAME);
                if (n > -1) {
                    this.baseDS.name = attributes.getValue(n);
                }
                if ((n = attributes.getIndex(this.XML_DS_ATT_HOLE)) > -1) {
                    this.baseDS.holeValue = this.getNextDouble(attributes.getValue(n));
                }
            }
            this.xDataArrays = new ArrayList();
            this.yDataArrays = new ArrayList();
            this.seriesLabels = new ArrayList();
            this.pointLabels = new ArrayList();
        }
    }

    public void handleEndElement(String string, String string2, String string3) throws SAXException {
        String string4;
        String string5 = string4 = this.sb == null ? null : this.sb.toString();
        if (string3.equals(this.XML_DS_XDATA)) {
            this.curValue = this.getNextDouble(string4);
            this.xData.add(this.curValue);
        } else if (string3.equals(this.XML_DS_YDATA)) {
            this.curValue = this.getNextDouble(string4);
            this.yData.add(this.curValue);
        } else if (string3.equals(this.XML_DS_SERIESLABEL)) {
            this.seriesLabel = string4;
            if (!this.inSeries) {
                this.seriesLabels.add(this.seriesLabel);
                this.seriesLabel = null;
            }
        } else if (string3.equals(this.XML_DS_POINTLABEL)) {
            this.pointLabel = string4;
            if (!this.inPoint) {
                this.pointLabels.add(this.pointLabel);
                this.pointLabel = null;
            }
        } else if (string3.equals(this.XML_DS_SERIES)) {
            this.processXYData();
            if (this.seriesLabel != null) {
                this.seriesLabels.add(this.seriesLabel);
            }
            this.seriesLabel = null;
            this.inSeries = false;
        } else if (string3.equals(this.XML_DS_POINT)) {
            this.processXYData();
            if (this.pointLabel != null) {
                this.pointLabels.add(this.pointLabel);
            }
            this.pointLabel = null;
            this.inPoint = false;
        } else if (string3.equals(this.XML_DS)) {
            if (this.xData != null) {
                double[] dArray = this.processArrayListToDoubles(this.xData);
                this.xDataArrays.add(dArray);
                this.xData = null;
            }
            this.processDataArrays();
        }
        this.sb = null;
    }

    public void handleCharacters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.sb == null) {
            this.sb = new StringBuffer(string);
        } else {
            this.sb.append(string);
        }
    }

    protected double[] processArrayListToDoubles(ArrayList arrayList) throws SAXException {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        double[] dArray = new double[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            this.curValue = (Double)arrayList.get(n);
            dArray[n] = this.curValue;
            ++n;
        }
        return dArray;
    }

    protected void processXYData() throws SAXException {
        double[] dArray = this.processArrayListToDoubles(this.yData);
        this.yDataArrays.add(dArray);
        this.yData = null;
        if (this.inSeries) {
            double[] dArray2 = this.processArrayListToDoubles(this.xData);
            if (dArray2 != null) {
                this.xDataArrays.add(dArray2);
            }
            this.xData = null;
        }
        if (this.inPoint && this.xData.size() < this.yDataArrays.size()) {
            this.xData.add(new Double(this.xData.size() - 1));
        }
    }

    protected double[] fillOutArray(double[] dArray, int n) {
        int n2;
        if (dArray != null && dArray.length >= n) {
            return dArray;
        }
        double[] dArray2 = new double[n];
        int n3 = n2 = dArray == null ? 0 : dArray.length;
        if (n2 > 0) {
            System.arraycopy(dArray, 0, dArray2, 0, n2);
        }
        int n4 = n2;
        while (n4 < n) {
            dArray2[n4] = this.baseDS.getHoleValue();
            ++n4;
        }
        return dArray2;
    }

    protected String[] processLabels(ArrayList arrayList, int n) {
        if (n <= 0 || arrayList == null || arrayList.size() == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            if (n2 < arrayList.size()) {
                String string = (String)arrayList.get(n2);
                if (string == null || string.length() == 0) {
                    string = "";
                }
                stringArray[n2] = string;
            } else {
                stringArray[n2] = null;
            }
            ++n2;
        }
        return stringArray;
    }

    protected void processDataArrays() {
        int n;
        double[] dArray;
        double[] dArray2;
        int n2;
        int n3 = this.xDataArrays.size();
        int n4 = 0;
        if (this.usingSeries) {
            n4 = this.yDataArrays.size();
        } else {
            n2 = 0;
            while (n2 < this.yDataArrays.size()) {
                dArray2 = (double[])this.yDataArrays.get(n2);
                n4 = Math.max(n4, dArray2.length);
                ++n2;
            }
        }
        this.baseDS.xvalues = new double[n3 > 1 ? n3 : 1][];
        this.baseDS.yvalues = new double[n4][];
        n2 = 0;
        if (n3 <= 1) {
            dArray = n3 == 1 ? (double[])this.xDataArrays.get(0) : null;
            int n5 = n2 = dArray == null ? 0 : dArray.length;
            if (this.usingSeries) {
                n = 0;
                while (n < n4) {
                    dArray2 = (double[])this.yDataArrays.get(n);
                    n2 = Math.max(n2, dArray2.length);
                    ++n;
                }
            } else {
                n2 = Math.max(n2, this.yDataArrays.size());
            }
        }
        dArray = null;
        if (n3 == 0) {
            dArray = new double[n2];
            n = 0;
            while (n < n2) {
                dArray[n] = n + 1;
                ++n;
            }
        } else if (n3 == 1) {
            dArray = (double[])this.xDataArrays.get(0);
        }
        n = n2;
        int n6 = 0;
        while (n6 < this.yDataArrays.size()) {
            dArray2 = (double[])this.yDataArrays.get(n6);
            if (n3 <= 1) {
                if (n6 == 0) {
                    this.baseDS.xvalues[0] = this.fillOutArray(dArray, n2);
                }
            } else {
                dArray = (double[])this.xDataArrays.get(n6);
                n2 = Math.max(dArray.length, dArray2.length);
                n = Math.max(n2, n);
                this.baseDS.xvalues[n6] = this.fillOutArray(dArray, n2);
            }
            if (this.usingSeries) {
                this.baseDS.yvalues[n6] = this.fillOutArray(dArray2, n2);
            } else {
                int n7 = 0;
                while (n7 < n4) {
                    if (n6 == 0) {
                        this.baseDS.yvalues[n7] = new double[n2];
                    }
                    this.baseDS.yvalues[n7][n6] = n7 < dArray2.length ? dArray2[n7] : this.baseDS.getHoleValue();
                    ++n7;
                }
            }
            ++n6;
        }
        this.xDataArrays = null;
        this.yDataArrays = null;
        this.baseDS.seriesLabels = this.processLabels(this.seriesLabels, n4);
        this.baseDS.pointLabels = this.processLabels(this.pointLabels, n);
        this.seriesLabels = null;
        this.pointLabels = null;
    }

    protected Double getNextDouble(String string) throws SAXException {
        Double d = null;
        if (string == null || string.equalsIgnoreCase("HOLE")) {
            d = new Double(this.baseDS.getHoleValue());
        } else if (string.equalsIgnoreCase("MAX")) {
            d = new Double(Double.MAX_VALUE);
        } else if (string.equalsIgnoreCase("MIN")) {
            d = new Double(Double.MIN_VALUE);
        } else {
            try {
                d = Double.valueOf(string);
            }
            catch (Exception exception) {
                this.displayErrorMessage(2, string);
                throw new SAXException("Error in data file format - ");
            }
            if (d == null) {
                d = new Double(0.0);
            }
        }
        return d;
    }

    protected void displayErrorMessage(int n, String string) {
        String string2 = "";
        switch (n) {
            case 1: {
                string2 = string2 + "Data must start with ARRAY or GENERAL and not ";
                break;
            }
            case 2: {
                string2 = string2 + "Expect either a hole or numeric value and not ";
                break;
            }
            case 3: {
                string2 = string2 + "Expect a point label and not ";
                break;
            }
            default: {
                return;
            }
        }
        if (string != null && string.length() > 0) {
            string2 = string2 + "'";
            string2 = string2 + string;
            string2 = string2 + "'";
        }
        System.err.println(string2);
    }

    protected String DoubleToString(double d, double d2, boolean bl) {
        String string = null;
        string = bl && d == d2 ? "hole" : (d == Double.MAX_VALUE ? "max" : (d == Double.MIN_VALUE ? "min" : String.valueOf(d)));
        return string;
    }

    protected void writeString(DataOutputStream dataOutputStream, StringBuffer stringBuffer, String string, int n) throws IOException {
        if (dataOutputStream == null && stringBuffer == null || string == null) {
            return;
        }
        StringBuffer stringBuffer2 = null;
        if (n > 0) {
            stringBuffer2 = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer2.append(" ");
                ++n2;
            }
        }
        if (dataOutputStream != null) {
            try {
                if (stringBuffer2 != null) {
                    dataOutputStream.write(stringBuffer2.toString().getBytes());
                }
                dataOutputStream.write(string.getBytes());
            }
            catch (IOException iOException) {
                System.out.println("Cannot write to outputstream");
                iOException.printStackTrace();
            }
        }
        if (stringBuffer != null) {
            if (stringBuffer2 != null) {
                stringBuffer.append(stringBuffer2.toString());
            }
            stringBuffer.append(string);
        }
    }

    protected void writeDataToXML(ChartDataModel chartDataModel, DataOutputStream dataOutputStream, StringBuffer stringBuffer, int n, int n2, boolean bl) throws IOException {
        int n3;
        double[] dArray;
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0) {
            return;
        }
        if (dataOutputStream == null && stringBuffer == null) {
            return;
        }
        int n4 = chartDataModel.getNumSeries();
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string = null;
        if (chartDataModel instanceof LabelledChartDataModel) {
            LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
            stringArray = labelledChartDataModel.getPointLabels();
            stringArray2 = labelledChartDataModel.getSeriesLabels();
            string = labelledChartDataModel.getDataSourceName();
        }
        boolean bl2 = false;
        double d = Double.MAX_VALUE;
        if (chartDataModel instanceof HoleValueChartDataModel) {
            d = ((HoleValueChartDataModel)((Object)chartDataModel)).getHoleValue();
            bl2 = true;
        }
        double[][] dArrayArray = new double[n4][];
        double[][] dArrayArray2 = new double[n4][];
        int n5 = 0;
        while (n5 < n4) {
            dArray = chartDataModel.getXSeries(n5);
            if (n5 == 0 || dArray != dArrayArray[0]) {
                dArrayArray[n5] = dArray;
            }
            dArrayArray2[n5] = chartDataModel.getYSeries(n5);
            ++n5;
        }
        if (dArrayArray.length > 1 && dArrayArray[1] == null) {
            dArray = dArrayArray[0];
            dArrayArray = new double[][]{dArray};
        }
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        if (bl) {
            this.writeString(dataOutputStream, stringBuffer, "<?xml version=\"1.0\"?>\n", n);
            this.writeString(dataOutputStream, stringBuffer, "<!DOCTYPE chart-data SYSTEM \"JCChartData.dtd\">\n", n);
        }
        this.writeString(dataOutputStream, stringBuffer, "<" + this.XML_DS, n);
        if (string != null) {
            this.writeString(dataOutputStream, stringBuffer, " " + this.XML_DS_ATT_NAME + "=\"" + XMLDataHandler.expandReservedCharacters(string) + "\"", 0);
        }
        if (bl2) {
            this.writeString(dataOutputStream, stringBuffer, " " + this.XML_DS_ATT_HOLE + "=\"" + this.DoubleToString(d, d, false) + "\"", 0);
        }
        this.writeString(dataOutputStream, stringBuffer, ">\n", 0);
        n += n2;
        if (stringArray != null && stringArray.length > 0) {
            boolean bl3 = false;
            n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3] != null && stringArray[n3].length() > 0) {
                    bl3 = true;
                    break;
                }
                ++n3;
            }
            if (bl3) {
                int n6 = 0;
                while (n6 < stringArray.length) {
                    this.writeString(dataOutputStream, stringBuffer, "<" + this.XML_DS_POINTLABEL + ">", n);
                    this.writeString(dataOutputStream, stringBuffer, XMLDataHandler.expandReservedCharacters(stringArray[n6]), 0);
                    this.writeString(dataOutputStream, stringBuffer, "</" + this.XML_DS_POINTLABEL + ">\n", 0);
                    ++n6;
                }
            }
        }
        int n7 = 0;
        while (n7 < n4) {
            this.writeString(dataOutputStream, stringBuffer, "<" + this.XML_DS_SERIES + ">\n", n);
            n += n2;
            if (stringArray2 != null && n7 < stringArray2.length && stringArray2[n7] != null) {
                this.writeString(dataOutputStream, stringBuffer, "<" + this.XML_DS_SERIESLABEL + ">", n);
                this.writeString(dataOutputStream, stringBuffer, XMLDataHandler.expandReservedCharacters(stringArray2[n7]), 0);
                this.writeString(dataOutputStream, stringBuffer, "</" + this.XML_DS_SERIESLABEL + ">\n", 0);
            }
            if (n7 == 0 || dArrayArray.length > 1) {
                n3 = 0;
                while (n3 < dArrayArray[n7].length) {
                    this.writeString(dataOutputStream, stringBuffer, "<" + this.XML_DS_XDATA + ">", n);
                    this.writeString(dataOutputStream, stringBuffer, this.DoubleToString(dArrayArray[n7][n3], d, bl2), 0);
                    this.writeString(dataOutputStream, stringBuffer, "</" + this.XML_DS_XDATA + ">\n", 0);
                    ++n3;
                }
            }
            n3 = 0;
            while (n3 < dArrayArray2[n7].length) {
                this.writeString(dataOutputStream, stringBuffer, "<" + this.XML_DS_YDATA + ">", n);
                this.writeString(dataOutputStream, stringBuffer, this.DoubleToString(dArrayArray2[n7][n3], d, bl2), 0);
                this.writeString(dataOutputStream, stringBuffer, "</" + this.XML_DS_YDATA + ">\n", 0);
                ++n3;
            }
            this.writeString(dataOutputStream, stringBuffer, "</" + this.XML_DS_SERIES + ">\n", n -= n2);
            ++n7;
        }
        this.writeString(dataOutputStream, stringBuffer, "</" + this.XML_DS + ">\n", n -= n2);
    }

    public String writeDataToXML(ChartDataModel chartDataModel, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.writeDataToXML(chartDataModel, null, stringBuffer, n, n2, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public void writeDataToXML(ChartDataModel chartDataModel, String string, int n, int n2) throws IOException {
        if (string == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.writeDataToXML(chartDataModel, fileOutputStream, n, n2, true);
    }

    public void writeDataToXML(ChartDataModel chartDataModel, OutputStream outputStream, int n, int n2, boolean bl) throws IOException {
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0 || outputStream == null) {
            return;
        }
        DataOutputStream dataOutputStream = null;
        dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        if (dataOutputStream == null) {
            return;
        }
        this.writeDataToXML(chartDataModel, dataOutputStream, null, n, n2, bl);
    }

    public void writeDataToXML(ChartDataModel chartDataModel, StringBuffer stringBuffer, int n, int n2, boolean bl) {
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0 || stringBuffer == null) {
            return;
        }
        try {
            this.writeDataToXML(chartDataModel, null, stringBuffer, n, n2, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String expandReservedCharacters(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String[] stringArray = new String[]{"&", "<", ">", "'", "\""};
        String[] stringArray2 = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"};
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.indexOf(stringArray[n2]) >= 0) {
                bl = true;
            }
            ++n2;
        }
        StringBuffer stringBuffer = null;
        if (bl) {
            stringBuffer = new StringBuffer(string);
            n = 0;
            while (n < stringArray.length) {
                String string2 = stringBuffer.toString();
                int n3 = string2.indexOf(stringArray[n]);
                while (n3 >= 0) {
                    stringBuffer.replace(n3, n3 + 1, stringArray2[n]);
                    string2 = stringBuffer.toString();
                    n3 = string2.indexOf(stringArray[n], n3 + 1);
                }
                ++n;
            }
        }
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(string);
        }
        n = stringBuffer.length() - 1;
        while (n >= 0) {
            char c = stringBuffer.charAt(n);
            if (c < lowCharacterBound || c > highCharacterBound) {
                String string3 = Integer.toHexString(c);
                StringBuffer stringBuffer2 = new StringBuffer("&#x");
                int n4 = 4;
                while (n4 > string3.length()) {
                    stringBuffer2.append("0");
                    --n4;
                }
                stringBuffer2.append(string3);
                stringBuffer2.append(";");
                stringBuffer.replace(n, n + 1, stringBuffer2.toString());
            }
            --n;
        }
        return stringBuffer.toString();
    }
}

