/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartNumberFormat;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCLabelGenerator;
import java.io.Serializable;

public class JCValueLabel
implements Serializable {
    protected double value = 0.0;
    protected ChartText label = new ChartText();

    public ChartText getChartText() {
        return this.label;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        if (this.value == d) {
            return;
        }
        this.value = d;
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String string) {
        this.label.setText(string);
    }

    public JCValueLabel() {
        this.value = 0.0;
    }

    public JCValueLabel(double d, String string, JCAxis jCAxis) {
        this.value = d;
        this.label = new ChartText(null, string, jCAxis);
    }

    public JCValueLabel(double d, String string) {
        this.value = d;
        this.label.updateParent = false;
        this.label.setText(string);
        this.label.updateParent = true;
    }

    void setParent(JCAxis jCAxis) {
        if (this.label.parentChart == null) {
            this.label.setParentChart(jCAxis.getParentChart());
        }
        this.label.setParentAxis(jCAxis);
        if (this.label.getHeight() == 0) {
            this.label.setChanged(true, 2, false);
            this.label.recalc();
        }
    }

    JCValueLabel(JCAxis jCAxis, double d, int n) {
        JCChart jCChart;
        this.value = d;
        JCChart jCChart2 = jCChart = jCAxis == null ? null : jCAxis.getParentChart();
        if (jCAxis != null && jCAxis.labelGenerator != null) {
            this.setGeneratedLabel(jCChart, d, n, jCAxis.labelGenerator, jCAxis);
        } else {
            String string = JCChartUtil.format(d, n);
            String string2 = null;
            if (jCAxis != null) {
                JCChartNumberFormat jCChartNumberFormat = null;
                jCChartNumberFormat = jCAxis.getNumberFormatter();
                string2 = jCChartNumberFormat.localize(string);
                this.label = new ChartText(jCChart, string2, jCAxis);
            } else {
                this.label = new ChartText(jCChart, string, jCAxis);
            }
            this.label.updateParent = false;
            if (jCAxis != null) {
                this.label.setRotation(jCAxis.annotationRotation);
            }
            this.label.updateParent = true;
        }
        this.setParent(jCAxis);
    }

    JCValueLabel(JCAxis jCAxis, int n, int n2) {
        JCChart jCChart;
        this.value = JCChartUtil.pow10(n);
        JCChart jCChart2 = jCChart = jCAxis == null ? null : jCAxis.getParentChart();
        if (jCAxis != null && jCAxis.labelGenerator != null) {
            this.setGeneratedLabel(jCChart, n, n2, jCAxis.labelGenerator, jCAxis);
        } else {
            String string = JCChartUtil.logFormat(n);
            String string2 = null;
            if (jCAxis != null) {
                JCChartNumberFormat jCChartNumberFormat = null;
                jCChartNumberFormat = jCAxis.getNumberFormatter();
                string2 = jCChartNumberFormat.localize(string);
                this.label = new ChartText(jCChart, string2, jCAxis);
            } else {
                this.label = new ChartText(jCChart, string, jCAxis);
            }
            this.label.updateParent = false;
            if (jCAxis != null) {
                this.label.setRotation(jCAxis.annotationRotation);
            }
            this.label.updateParent = true;
        }
        this.setParent(jCAxis);
    }

    private void setGeneratedLabel(JCChart jCChart, double d, int n, JCLabelGenerator jCLabelGenerator, JCAxis jCAxis) {
        if (jCLabelGenerator == null) {
            return;
        }
        Object object = jCLabelGenerator.makeLabel(d, n);
        if (object instanceof ChartText) {
            this.label = (ChartText)object;
            this.label.setParentChart(jCChart);
        } else {
            String string = object instanceof String ? (String)object : object.toString();
            this.label = new ChartText(jCChart, string, jCAxis);
            this.label.updateParent = false;
            if (jCAxis != null) {
                this.label.setRotation(jCAxis.annotationRotation);
            }
            this.label.updateParent = true;
        }
    }

    public String toString() {
        return this.label.getText();
    }
}

