/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Diamond;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCShape;
import com.klg.jclass.chart.JCStyle;
import com.klg.jclass.chart.Triangle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class JCSymbolStyle
extends JCStyle {
    protected int shape = 1;
    protected int colorIndex;
    protected int shapeIndex = 1;
    protected Color color = null;
    protected int size = 6;
    protected JCShape customShape = null;
    public static final int NONE = 0;
    public static final int DOT = 1;
    public static final int BOX = 2;
    public static final int TRIANGLE = 3;
    public static final int DIAMOND = 4;
    public static final int STAR = 5;
    public static final int VERT_LINE = 6;
    public static final int HORIZ_LINE = 7;
    public static final int CROSS = 8;
    public static final int CIRCLE = 9;
    public static final int SQUARE = 10;
    public static final int OTHER = 11;
    public static final int LAST = 10;

    public JCSymbolStyle(int n, Color color, int n2) {
        this.setShape(n);
        this.color = color;
        this.size = n2;
    }

    public static JCSymbolStyle makeDefault(JCChart jCChart) {
        JCSymbolStyle jCSymbolStyle = new JCSymbolStyle(JCSymbolStyle.getDefaultShape(jCChart), JCSymbolStyle.getDefaultColor(jCChart), 6);
        int n = 1;
        int n2 = 0;
        if (jCChart != null) {
            n2 = jCChart.getSymbolColorIndex();
            n2 = n2 == 0 ? JCStyle.defaultColors.length - 1 : --n2;
            n = jCChart.getSymbolShapeIndex();
            n = n == 1 ? 10 : --n;
        }
        jCSymbolStyle.colorIndex = n2;
        jCSymbolStyle.shapeIndex = n;
        return jCSymbolStyle;
    }

    public void draw(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2, this.size, (Color)null);
    }

    public void draw(Graphics graphics, int n, int n2, Color color) {
        this.draw(graphics, n, n2, this.size, color);
    }

    public void draw(Graphics graphics, double d, double d2, Color color) {
        this.draw(graphics, d, d2, this.size, color);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        this.draw(graphics, n, n2, n3, (Color)null);
    }

    public void draw(Graphics graphics, int n, int n2, int n3, Color color) {
        Color color2 = color != null ? color : this.color;
        graphics.setColor(color2);
        if (this.customShape != null) {
            this.customShape.resize(n3);
            this.customShape.draw(graphics, n, n2);
            return;
        }
        boolean bl = n3 % 2 == 0;
        int n4 = n3 / 2;
        if (bl) {
            n4 = (n3 - 1) / 2;
        }
        int n5 = (int)((double)n3 / 2.8284271247461903);
        switch (this.shape) {
            case 0: {
                break;
            }
            case 1: {
                graphics.fillOval(n - n3 / 2, n2 - n3 / 2, n3, n3);
                break;
            }
            case 2: {
                graphics.fillRect(n - n3 / 2, n2 - n3 / 2, n3, n3);
                break;
            }
            case 5: {
                graphics.drawLine(n - n3 / 2, n2, n + n4, n2);
                graphics.drawLine(n, n2 - n3 / 2, n, n2 + n4);
                graphics.drawLine(n - n5, n2 - n5, n + n5, n2 + n5);
                graphics.drawLine(n - n5, n2 + n5, n + n5, n2 - n5);
                break;
            }
            case 6: {
                graphics.drawLine(n, n2 - n3 / 2, n, n2 + n4);
                break;
            }
            case 7: {
                graphics.drawLine(n - n3 / 2, n2, n + n4, n2);
                break;
            }
            case 8: {
                graphics.drawLine(n, n2 - n3 / 2, n, n2 + n4);
                graphics.drawLine(n - n3 / 2, n2, n + n4, n2);
                break;
            }
            case 9: {
                graphics.drawArc(n - n3 / 2, n2 - n3 / 2, n3 - 1, n3 - 1, 0, 360);
                break;
            }
            case 10: {
                graphics.drawRect(n - n3 / 2, n2 - n3 / 2, n3 - 1, n3 - 1);
            }
        }
    }

    public void draw(Graphics graphics, double d, double d2, int n, Color color) {
        Color color2 = color != null ? color : this.color;
        graphics.setColor(color2);
        if (this.customShape != null) {
            this.customShape.resize(n);
            this.customShape.draw(graphics, d, d2);
            return;
        }
        boolean bl = n % 2 == 0;
        int n2 = n / 2;
        if (bl) {
            n2 = (n - 1) / 2;
        }
        int n3 = (int)((double)n / 2.8284271247461903);
        Graphics2D graphics2D = (Graphics2D)graphics;
        switch (this.shape) {
            case 0: {
                break;
            }
            case 1: {
                graphics2D.fill(new Ellipse2D.Double(d - (double)n / 2.0, d2 - (double)n / 2.0, n, n));
                break;
            }
            case 2: {
                graphics2D.fill(new Rectangle2D.Double(d - (double)n / 2.0, d2 - (double)n / 2.0, n, n));
                break;
            }
            case 5: {
                graphics2D.draw(new Line2D.Double(d - (double)n / 2.0, d2, d + (double)n2, d2));
                graphics2D.draw(new Line2D.Double(d, d2 - (double)n / 2.0, d, d2 + (double)n2));
                graphics2D.draw(new Line2D.Double(d - (double)n3, d2 - (double)n3, d + (double)n3, d2 + (double)n3));
                graphics2D.draw(new Line2D.Double(d - (double)n3, d2 + (double)n3, d + (double)n3, d2 - (double)n3));
                break;
            }
            case 6: {
                graphics2D.draw(new Line2D.Double(d, d2 - (double)n / 2.0, d, d2 + (double)n2));
                break;
            }
            case 7: {
                graphics2D.draw(new Line2D.Double(d - (double)n / 2.0, d2, d + (double)n2, d2));
                break;
            }
            case 8: {
                graphics2D.draw(new Line2D.Double(d, d2 - (double)n / 2.0, d, d2 + (double)n2));
                graphics2D.draw(new Line2D.Double(d - (double)n / 2.0, d2, d + (double)n2, d2));
                break;
            }
            case 9: {
                graphics2D.draw(new Arc2D.Double(d - (double)n / 2.0, d2 - (double)n / 2.0, n - 1, n - 1, 0.0, 360.0, 0));
                break;
            }
            case 10: {
                graphics2D.draw(new Rectangle2D.Double(d - (double)n / 2.0, d2 - (double)n / 2.0, n - 1, n - 1));
            }
        }
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int n) {
        if (this.shape == n) {
            return;
        }
        this.shapeIndex = n;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.shape = n;
                this.customShape = null;
                break;
            }
            case 3: {
                this.shape = n;
                this.customShape = new Triangle();
                break;
            }
            case 4: {
                this.shape = n;
                this.customShape = new Diamond();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for Shape in JCSymbolStyle.");
            }
        }
        this.setChanged(true, 17);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.setChanged(true, 17);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        if (this.size == n) {
            return;
        }
        this.size = n;
        this.setChanged(true, 18);
    }

    static int getDefaultShape(JCChart jCChart) {
        int n;
        if (jCChart == null) {
            n = 1;
        } else {
            int n2 = jCChart.getSymbolShapeIndex();
            n = n2++;
            if (n2 > 10) {
                n2 = 1;
            }
            jCChart.setSymbolShapeIndex(n2);
        }
        return n;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    static Color getDefaultColor(JCChart jCChart) {
        Color color;
        if (jCChart == null) {
            color = JCStyle.defaultColors[0];
        } else {
            int n = jCChart.getSymbolColorIndex();
            color = JCStyle.defaultColors[n++];
            if (n >= JCStyle.defaultColors.length) {
                n = 0;
            }
            if (jCChart != null && jCChart.getChartArea() != null && JCChartUtil.colorsNear(color, jCChart.getChartArea().getPlotArea().getBackground())) {
                color = JCStyle.defaultColors[n++];
                if (n >= JCStyle.defaultColors.length) {
                    n = 0;
                }
            }
            jCChart.setSymbolColorIndex(n);
        }
        return color;
    }

    public JCShape getCustomShape() {
        return this.customShape;
    }

    public void setCustomShape(JCShape jCShape) {
        if (this.customShape == jCShape) {
            return;
        }
        this.shape = jCShape == null ? 0 : 11;
        this.customShape = jCShape;
        this.setChanged(true, 17);
    }
}

