/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;

public class JCLineStyle
extends JCStyle {
    protected int join = 0;
    protected int cap = 0;
    protected int pattern = 1;
    protected int width = 1;
    protected int colorIndex;
    protected Color color = null;
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int LONG_DASH = 2;
    public static final int SHORT_DASH = 3;
    public static final int LSL_DASH = 4;
    public static final int DASH_DOT = 5;
    public static final int CUSTOM = 6;
    public static final float[] LONG_DASH_ARRAY = new float[]{10.0f, 10.0f};
    public static final float[] SHORT_DASH_ARRAY = new float[]{5.0f, 10.0f};
    public static final float[] LSL_DASH_ARRAY = new float[]{10.0f, 10.0f, 5.0f, 10.0f};
    public static final float[] DASH_DOT_ARRAY = new float[]{10.0f, 10.0f, 1.0f, 10.0f};
    public static final float[] LEGEND_LONG_DASH_ARRAY = new float[]{5.0f, 5.0f};
    public static final float[] LEGEND_SHORT_DASH_ARRAY = new float[]{2.5f, 5.0f};
    public static final float[] LEGEND_LSL_DASH_ARRAY = new float[]{5.0f, 5.0f, 2.5f, 5.0f};
    public static final float[] LEGEND_DASH_DOT_ARRAY = new float[]{5.0f, 5.0f, 1.0f, 5.0f};
    protected float[] dashArray = null;
    protected float[] legendDashArray = null;
    int[] xp = null;
    int[] yp = null;

    public JCLineStyle(int n, Color color, int n2) {
        this.width = n;
        this.color = color;
        this.pattern = n2;
        this.join = 0;
        this.cap = 0;
        this.updateDashArray();
    }

    public JCLineStyle(int n, Color color, int n2, int n3, int n4) {
        this(n, color, n2, n3, n4, null, null);
    }

    public JCLineStyle(int n, Color color, int n2, int n3, int n4, float[] fArray, float[] fArray2) {
        this.width = n;
        this.color = color;
        this.pattern = n2;
        this.cap = n3;
        this.join = n4;
        this.dashArray = fArray;
        this.legendDashArray = fArray2 != null ? fArray2 : fArray;
        this.updateDashArray();
    }

    public static JCLineStyle makeDefault(JCChart jCChart) {
        JCLineStyle jCLineStyle = new JCLineStyle(1, JCLineStyle.getDefaultColor(jCChart), JCLineStyle.getDefaultPattern(jCChart));
        int n = 0;
        if (jCChart != null) {
            n = jCChart.getLineColorIndex();
            n = n == 0 ? JCStyle.defaultColors.length - 1 : --n;
        }
        jCLineStyle.colorIndex = n;
        return jCLineStyle;
    }

    public boolean updateGraphics(Graphics graphics) {
        return this.updateGraphics(graphics, -1);
    }

    public boolean updateGraphics(Graphics graphics, int n) {
        if (this.pattern == 0 || this.width <= 0) {
            return false;
        }
        if (!graphics.getColor().equals(this.color)) {
            graphics.setColor(this.color);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pattern == 1) {
            graphics2D.setStroke(new BasicStroke(this.width, this.cap, this.join));
        } else if (n > 0) {
            float f;
            float f2;
            float f3 = 0.0f;
            int n2 = 0;
            while (n2 < this.dashArray.length) {
                f3 += this.dashArray[n2];
                ++n2;
            }
            f3 += this.dashArray[0];
            float[] fArray = new float[this.dashArray.length + 1];
            int n3 = 0;
            int n4 = 0;
            while (n4 < fArray.length) {
                f2 = n4 == fArray.length - 1 ? this.dashArray[0] : this.dashArray[n4];
                f = (float)Math.floor((float)n / f3 * f2);
                if ((double)f < 1.0) {
                    ++n3;
                }
                ++n4;
            }
            f2 = f3 - (float)n3;
            f = (float)n - (float)n3;
            int n5 = 0;
            while (n5 < fArray.length) {
                float f4 = n5 == fArray.length - 1 ? this.dashArray[0] : this.dashArray[n5];
                float f5 = (float)Math.floor((float)n / f3 * f4);
                f5 = (double)f5 < 1.0 ? 1.0f : f / f2 * f4;
                fArray[n5] = f5;
                ++n5;
            }
            graphics2D.setStroke(new BasicStroke(this.width, this.cap, this.join, 10.0f, fArray, 0.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(this.width, this.cap, this.join, 10.0f, this.dashArray, 0.0f));
        }
        return true;
    }

    public void resetGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f));
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        this.draw(graphics, n, n2, n3, n4, null);
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        if (!this.updateGraphics(graphics)) {
            return;
        }
        if (color != null && !graphics.getColor().equals(color)) {
            graphics.setColor(color);
        }
        this.drawLine(graphics, n, n2, n3, n4);
        this.resetGraphics(graphics);
    }

    public void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n, n2, n3, n4);
    }

    public void drawLine(Graphics graphics, double d, double d2, double d3, double d4) {
        if (this.updateGraphics(graphics)) {
            ((Graphics2D)graphics).draw(new Line2D.Double(d, d2, d3, d4));
        }
    }

    public void drawSquaredLine(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        if (this.width == 1) {
            graphics.drawLine(n, n2, n3, n4);
        } else if (n == n3) {
            int n8 = Math.min(n2, n4);
            int n9 = Math.abs(n4 - n2);
            if (!bl) {
                graphics.fillRect(n - this.width / 2, n8, this.width, n9 + 1);
            } else {
                int n10 = this.width;
                int n11 = n - this.width / 2;
                if (n11 < n6) {
                    n10 -= n6 - n11;
                    n11 = n6;
                } else if (n11 + n10 > n7) {
                    n10 -= n11 + n10 - n7;
                }
                graphics.fillRect(n11, n8, n10, n9 + 1);
            }
        } else if (n2 == n4) {
            int n12 = Math.min(n, n3);
            int n13 = Math.abs(n3 - n);
            if (!bl) {
                int n14 = this.width;
                int n15 = n2 - this.width / 2;
                if (n15 < n6) {
                    n14 -= n6 - n15;
                    n15 = n6;
                } else if (n15 + n14 > n7) {
                    n14 -= n15 + n14 - n7;
                }
                graphics.fillRect(n12, n15, n13, n14);
            } else {
                graphics.fillRect(n12, n2 - this.width / 2, n13, this.width);
            }
        } else {
            if (this.xp == null || this.yp == null) {
                this.xp = new int[4];
                this.yp = new int[4];
            }
            if (!bl) {
                int n16 = this.width / 2;
                int n17 = (this.width + 1) / 2;
                this.xp[0] = n;
                this.yp[0] = n2 + n16;
                this.xp[1] = n3;
                this.yp[1] = n4 + n16;
                this.xp[2] = n3;
                this.yp[2] = n4 - n17;
                this.xp[3] = n;
                this.yp[3] = n2 - n17;
                int n18 = 0;
                while (n18 < 4) {
                    int n19 = 0;
                    if (n18 == 1 || n18 == 2) {
                        n19 = n5;
                    }
                    if (this.yp[n18] < n6 + n19) {
                        this.yp[n18] = n6 + n19;
                    } else if (this.yp[n18] > n7 + n19) {
                        this.yp[n18] = n7 + n19;
                    }
                    ++n18;
                }
            } else {
                int n20 = this.width / 2;
                int n21 = (this.width + 1) / 2;
                this.xp[0] = n + n20;
                this.yp[0] = n2;
                this.xp[1] = n3 + n20;
                this.yp[1] = n4 + 1;
                this.xp[2] = n3 - n21;
                this.yp[2] = n4 + 1;
                this.xp[3] = n - n21;
                this.yp[3] = n2;
                int n22 = 0;
                while (n22 < 4) {
                    int n23 = 0;
                    if (n22 == 1 || n22 == 2) {
                        n23 = n5;
                    }
                    if (this.xp[n22] < n6 + n23) {
                        this.xp[n22] = n6 + n23;
                    } else if (this.xp[n22] >= n7 + n23) {
                        this.xp[n22] = n7 + n23;
                    }
                    ++n22;
                }
            }
            graphics.fillPolygon(this.xp, this.yp, 4);
        }
    }

    public void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.updateGraphics(graphics)) {
            graphics.drawRect(n, n2, n3, n4);
            this.resetGraphics(graphics);
        }
    }

    public void fillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.updateGraphics(graphics)) {
            graphics.fillRect(n, n2, n3, n4);
            this.resetGraphics(graphics);
        }
    }

    public void drawCircle(Graphics graphics, int n, int n2, int n3) {
        if (this.updateGraphics(graphics)) {
            int n4 = 2 * n3;
            graphics.drawArc(n - n3, n2 - n3, n4, n4, 0, 360);
            this.resetGraphics(graphics);
        }
    }

    public void drawArc(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.updateGraphics(graphics)) {
            ((Graphics2D)graphics).draw(new Arc2D.Double(d, d2, d3, d4, d5, d6, 0));
        }
    }

    public int getPattern() {
        return this.pattern;
    }

    public void setPattern(int n) {
        if (n == this.pattern) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.pattern = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for Pattern in JCLineStyle.  Should be one of NONE, SOLID, LONG_DASH, SHORT_DASH, LSL_DASH or DASH_DOT");
            }
        }
        this.updateDashArray();
        this.setChanged(true, 17);
    }

    public void setPattern(float[] fArray, float[] fArray2) {
        this.pattern = 6;
        this.dashArray = fArray;
        this.legendDashArray = fArray2 != null ? fArray2 : fArray;
        this.setChanged(true, 17);
    }

    public float[] getCustomPatternArray() {
        return this.dashArray;
    }

    public float[] getCustomLegendPatternArray() {
        return this.legendDashArray;
    }

    private void updateDashArray() {
        switch (this.pattern) {
            case 0: {
                this.dashArray = null;
                this.legendDashArray = null;
                break;
            }
            case 1: {
                this.dashArray = null;
                this.legendDashArray = null;
                break;
            }
            case 2: {
                this.dashArray = LONG_DASH_ARRAY;
                this.legendDashArray = LONG_DASH_ARRAY;
                break;
            }
            case 3: {
                this.dashArray = SHORT_DASH_ARRAY;
                this.legendDashArray = SHORT_DASH_ARRAY;
                break;
            }
            case 4: {
                this.dashArray = LSL_DASH_ARRAY;
                this.legendDashArray = LSL_DASH_ARRAY;
                break;
            }
            case 5: {
                this.dashArray = DASH_DOT_ARRAY;
                this.legendDashArray = DASH_DOT_ARRAY;
                break;
            }
            case 6: {
                break;
            }
            default: {
                this.dashArray = null;
                this.legendDashArray = null;
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        if (this.width == n) {
            return;
        }
        this.width = n;
        this.setChanged(true, 18);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.setChanged(true, 17);
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    static Color getDefaultColor(JCChart jCChart) {
        Color color;
        if (jCChart == null) {
            color = JCStyle.defaultColors[0];
        } else {
            int n = jCChart.getLineColorIndex();
            color = JCStyle.defaultColors[n++];
            if (n >= JCStyle.defaultColors.length) {
                n = 0;
            }
            if (jCChart != null && jCChart.getChartArea() != null && JCChartUtil.colorsNear(color, jCChart.getChartArea().getPlotArea().getBackground())) {
                color = JCStyle.defaultColors[n++];
                if (n >= JCStyle.defaultColors.length) {
                    n = 0;
                }
            }
            jCChart.setLineColorIndex(n);
        }
        return color;
    }

    static int getDefaultPattern(JCChart jCChart) {
        return 1;
    }

    public int getJoin() {
        return this.join;
    }

    public void setJoin(int n) {
        if (n == this.join) {
            return;
        }
        this.join = n;
        this.setChanged(true, 17);
    }

    public int getCap() {
        return this.cap;
    }

    public void setCap(int n) {
        if (n == this.cap) {
            return;
        }
        this.cap = n;
        this.setChanged(true, 17);
    }
}

