/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util;

import com.sitraka.licensing.util.ParameterCheck;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;

public class PropertyUtils {
    protected static final String[] MODIFIER_NAMES = new String[]{"second", "seconds", "minute", "minutes", "hour", "hours", "day", "days"};
    protected static final long[] MODIFIER_VALUES = new long[]{1000L, 1000L, 60000L, 60000L, 3600000L, 3600000L, 86400000L, 86400000L};
    protected static final String[] LONG_DATE_FORMATS = new String[]{"yyyy/MM/dd h:mm:ss a z", "yyyy/MM/dd hh:mm:ss z", "yyyy/MM/dd hh:mm:ss", "yyyy/MM/dd hh:mm z", "yyyy/MM/dd hh:mm", "yyyy/MM/dd h:mm:ss a", "yyyy/MM/dd h:mm a z", "yyyy/MM/dd h:mm a", "yyyy.MM.dd h:mm:ss a z", "yyyy.MM.dd hh:mm:ss z", "yyyy.MM.dd hh:mm:ss", "yyyy.MM.dd hh:mm z", "yyyy.MM.dd hh:mm", "yyyy.MM.dd h:mm:ss a", "yyyy.MM.dd h:mm a z", "yyyy.MM.dd h:mm a"};
    protected static final String[] SHORT_DATE_FORMATS = new String[]{"MMM dd, yyyy", "yyyy/MMM/dd", "yyyy.MM.dd", "yyyy/MM/dd"};
    protected static final String DATE_NOW = "now";
    protected static final String DATE_TODAY = "today";
    protected static final String DATE_TOMORROW = "tomorrow";
    protected static final String[] SPECIAL_DATES = new String[]{"now", "today", "tomorrow"};
    static /* synthetic */ Class class$com$sitraka$licensing$util$PropertyUtils;

    protected static double readBaseInterval(String value) {
        int index = value.indexOf(32);
        double result = Double.MIN_VALUE;
        String base = null;
        base = index != -1 ? value.substring(0, index) : value;
        try {
            result = Double.valueOf(base);
        }
        catch (NumberFormatException e) {
            result = Double.MIN_VALUE;
        }
        catch (Exception e) {
            System.err.print("\n--- DEBUG " + (class$com$sitraka$licensing$util$PropertyUtils == null ? (class$com$sitraka$licensing$util$PropertyUtils = PropertyUtils.class$("com.sitraka.licensing.util.PropertyUtils")) : class$com$sitraka$licensing$util$PropertyUtils).getName() + ": ");
            System.err.println("--- DEBUG parsing double '" + base + "'");
            e.printStackTrace();
            result = Double.MIN_VALUE;
        }
        return result;
    }

    protected static long readModifier(String value) {
        long result = 1L;
        int index = value.lastIndexOf(32);
        if (index != -1) {
            String modifier = value.substring(index + 1);
            int i = 0;
            while (i < MODIFIER_NAMES.length) {
                if (modifier.equalsIgnoreCase(MODIFIER_NAMES[i])) {
                    result = MODIFIER_VALUES[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static long readInterval(Properties props, String prop_name) {
        long result = Long.MIN_VALUE;
        String value = props.getProperty(prop_name);
        if (value != null) {
            value = value.trim();
            double base = PropertyUtils.readBaseInterval(value);
            long modifier = PropertyUtils.readModifier(value);
            if (base == Double.MIN_VALUE) {
                result = Long.MIN_VALUE;
            } else {
                Double temp = new Double(base * (double)modifier);
                result = temp.longValue();
            }
        }
        return result;
    }

    public static long readInterval(Properties props, String prop_name, long default_value) {
        long value = PropertyUtils.readInterval(props, prop_name);
        if (value == Long.MIN_VALUE) {
            value = default_value;
        }
        return value;
    }

    protected static long checkForSpecialDate(String value) {
        long result = 0L;
        ParameterCheck.nonNull(value);
        if (value == null) {
            return 0L;
        }
        if (value.equalsIgnoreCase(DATE_NOW)) {
            result = System.currentTimeMillis();
        } else if (value.equalsIgnoreCase(DATE_TODAY)) {
            Calendar cal = Calendar.getInstance();
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            result = cal.getTime().getTime();
        } else if (value.equalsIgnoreCase(DATE_TOMORROW)) {
            Calendar cal = Calendar.getInstance();
            cal.roll(5, true);
            result = cal.getTime().getTime();
        }
        return result;
    }

    public static String[] getLongDateFormats() {
        return LONG_DATE_FORMATS;
    }

    public static String[] getShortDateFormats() {
        return SHORT_DATE_FORMATS;
    }

    public static long parseLongDate(String value) {
        return PropertyUtils.parseDateInternal(value, LONG_DATE_FORMATS);
    }

    public static String writeLongDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(LONG_DATE_FORMATS[0]);
        return formatter.format(date);
    }

    public static String writeShortDate(Date date) {
        return PropertyUtils.writeShortDate(date, SHORT_DATE_FORMATS[0]);
    }

    public static String writeShortDate(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static long parseShortDate(String value) {
        return PropertyUtils.parseDateInternal(value, SHORT_DATE_FORMATS);
    }

    protected static long parseDateInternal(String value, String[] formats) {
        long result = 0L;
        ParameterCheck.nonNull(formats);
        ParameterCheck.nonNull(value);
        if (value == null || formats == null) {
            return result;
        }
        int i = 0;
        while (i < formats.length) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(formats[i]);
                Date when = dateFormat.parse(value);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(when);
                result = cal.getTime().getTime();
                break;
            }
            catch (ParseException pe) {
            }
            catch (Exception e) {
                System.err.println("\n--- DEBUG " + (class$com$sitraka$licensing$util$PropertyUtils == null ? PropertyUtils.class$("com.sitraka.licensing.util.PropertyUtils") : class$com$sitraka$licensing$util$PropertyUtils).getName() + ": ");
                System.err.println("--- DEBUG parsing '" + value + "' against '" + formats[i] + "'");
                e.printStackTrace();
            }
            ++i;
        }
        return result;
    }

    public static long readDate(Properties props, String prop_name) {
        long result = 0L;
        ParameterCheck.nonNull(props);
        ParameterCheck.nonNull(prop_name);
        if (props == null || prop_name == null) {
            return result;
        }
        String value = props.getProperty(prop_name);
        if (value != null) {
            result = PropertyUtils.checkForSpecialDate(value = value.trim());
            if (result != 0L) {
                return result;
            }
            result = PropertyUtils.parseLongDate(value);
        }
        return result;
    }

    public static long readShortDate(Properties props, String prop_name) {
        long result = 0L;
        ParameterCheck.nonNull(props);
        ParameterCheck.nonNull(prop_name);
        if (props == null || prop_name == null) {
            return result;
        }
        String value = props.getProperty(prop_name);
        if (value != null) {
            result = PropertyUtils.checkForSpecialDate(value = value.trim());
            if (result != 0L) {
                return result;
            }
            result = PropertyUtils.parseShortDate(value);
        }
        return result;
    }

    public static boolean parseLine(String line, String[] pair) {
        boolean result = false;
        line.trim();
        int equals_location = line.indexOf(61);
        if (equals_location > 0) {
            result = true;
            pair[0] = line.substring(0, equals_location);
            pair[1] = null;
            pair[1] = equals_location == line.length() - 1 ? "" : PropertyUtils.removeEscapeChars(line.substring(equals_location + 1));
        }
        return result;
    }

    protected static String removeEscapeChars(String value) {
        int index = value.indexOf(92);
        if (index == -1) {
            return value;
        }
        StringBuffer b = new StringBuffer(value);
        while (index < b.length()) {
            if (b.charAt(index) == '\\') {
                b.deleteCharAt(index);
            }
            ++index;
        }
        return b.toString();
    }

    public static void main(String[] args) {
        System.out.println("com.sitraka.util.PropertyUtils: Testing date parsing routines:");
        long d = PropertyUtils.parseLongDate("1979/07/13 11:11");
        if (d == -1L || d != 300726660000L) {
            System.out.println("\tParsing '1979/07/13 11:11' failed. Error!");
        } else {
            System.out.println("\tParsing '1979/07/13 11:11' succeeded as " + PropertyUtils.writeLongDate(new Date(d)) + " (" + d + ")");
        }
        System.out.println("\n\tParsing '2000/03/15 2:50:12 PM EST'");
        d = PropertyUtils.parseLongDate("2000/03/15 2:50:12 PM EST");
        Date date = new Date(d);
        System.out.println("\tParsed to java.util.Date: " + date);
        System.out.println("\tConverted back to: " + PropertyUtils.writeLongDate(date));
        System.out.println("\n\tParsing '2000/03/15 14:50:12 EST'");
        d = PropertyUtils.parseLongDate("2000/03/15 14:50:12 EST");
        date = new Date(d);
        System.out.println("\tParsed to java.util.Date: " + date);
        System.out.println("\tConverted back to: " + PropertyUtils.writeLongDate(date));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

