/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing;

import com.sitraka.licensing.SignableBlock;
import com.sitraka.licensing.SitrakaPublicKey;
import com.sitraka.licensing.util.Codecs;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;

public class ValidateSignature {
    protected static boolean validate(byte[] data, byte[] signature) {
        Signature dsa = null;
        try {
            dsa = Signature.getInstance("SHA/DSA");
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        SitrakaPublicKey key = new SitrakaPublicKey();
        try {
            dsa.initVerify(key);
        }
        catch (InvalidKeyException e) {
            return false;
        }
        try {
            dsa.update(data);
        }
        catch (SignatureException e) {
            return false;
        }
        boolean verifies = false;
        try {
            verifies = dsa.verify(signature);
        }
        catch (SignatureException e) {
            // empty catch block
        }
        return verifies;
    }

    public static boolean validateSignatureBytes(String[] properties, byte[] signature) {
        byte[] data = SignableBlock.createSignableBlock(properties);
        return ValidateSignature.validate(data, signature);
    }

    public static boolean validateSignature(String[] properties, String signature) {
        byte[] byteArray = null;
        try {
            byteArray = Codecs.base64Decode(signature.getBytes());
        }
        catch (Exception e) {
            return false;
        }
        return ValidateSignature.validateSignatureBytes(properties, byteArray);
    }
}

