/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing.encode;

import com.klg.jclass.util.swing.encode.AbstractImageEncoder;
import com.klg.jclass.util.swing.encode.EncoderException;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class PNGEncoder
extends AbstractImageEncoder {
    long[] crc_table = null;

    public void saveImage(Image image, OutputStream outputStream) throws IOException, EncoderException {
        int n;
        byte by;
        if (image == null) {
            this.error("PNG encoding error: Image is NULL.");
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getHeight(null), false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            this.error("PNG encoding error: Unable to retrieve pixels from image.");
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n2 = colorModel.getPixelSize();
        int n3 = (int)Math.pow(2.0, n2);
        if (n2 < 8 || n2 > 32) {
            this.error("PNG encoding error: PNG method needs color mode to be between 8 and 32 bits.");
        }
        int[] nArray = null;
        byte[] byArray = null;
        if (n2 > 8) {
            nArray = (int[])pixelGrabber.getPixels();
        } else {
            byArray = (byte[])pixelGrabber.getPixels();
        }
        outputStream.write(AbstractImageEncoder.byteFromInt(137));
        outputStream.write(AbstractImageEncoder.byteFromInt(80));
        outputStream.write(AbstractImageEncoder.byteFromInt(78));
        outputStream.write(AbstractImageEncoder.byteFromInt(71));
        outputStream.write(AbstractImageEncoder.byteFromInt(13));
        outputStream.write(AbstractImageEncoder.byteFromInt(10));
        outputStream.write(AbstractImageEncoder.byteFromInt(26));
        outputStream.write(AbstractImageEncoder.byteFromInt(10));
        long l = this.start_crc();
        outputStream.write(AbstractImageEncoder.bytesFromLong(13L));
        outputStream.write(AbstractImageEncoder.byteFromChar('I'));
        outputStream.write(AbstractImageEncoder.byteFromChar('H'));
        outputStream.write(AbstractImageEncoder.byteFromChar('D'));
        outputStream.write(AbstractImageEncoder.byteFromChar('R'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('I'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('H'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('D'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('R'));
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        l = this.update_crc(l, AbstractImageEncoder.bytesFromLong(n4));
        l = this.update_crc(l, AbstractImageEncoder.bytesFromLong(n5));
        l = this.update_crc(l, AbstractImageEncoder.byteFromInt(8));
        l = n2 > 8 ? this.update_crc(l, AbstractImageEncoder.byteFromInt(6)) : this.update_crc(l, AbstractImageEncoder.byteFromInt(3));
        l = this.update_crc(l, AbstractImageEncoder.byteFromInt(0));
        l = this.update_crc(l, AbstractImageEncoder.byteFromInt(0));
        l = this.update_crc(l, AbstractImageEncoder.byteFromInt(0));
        outputStream.write(AbstractImageEncoder.bytesFromLong(n4));
        outputStream.write(AbstractImageEncoder.bytesFromLong(n5));
        outputStream.write(AbstractImageEncoder.byteFromInt(8));
        if (n2 > 8) {
            outputStream.write(AbstractImageEncoder.byteFromInt(6));
        } else {
            outputStream.write(AbstractImageEncoder.byteFromInt(3));
        }
        outputStream.write(AbstractImageEncoder.byteFromInt(0));
        outputStream.write(AbstractImageEncoder.byteFromInt(0));
        outputStream.write(AbstractImageEncoder.byteFromInt(0));
        outputStream.write(AbstractImageEncoder.bytesFromLong(this.end_crc(l)));
        if (n2 == 8) {
            l = this.start_crc();
            outputStream.write(AbstractImageEncoder.bytesFromLong(n3 * 3));
            outputStream.write(AbstractImageEncoder.byteFromChar('P'));
            outputStream.write(AbstractImageEncoder.byteFromChar('L'));
            outputStream.write(AbstractImageEncoder.byteFromChar('T'));
            outputStream.write(AbstractImageEncoder.byteFromChar('E'));
            l = this.update_crc(l, AbstractImageEncoder.byteFromChar('P'));
            l = this.update_crc(l, AbstractImageEncoder.byteFromChar('L'));
            l = this.update_crc(l, AbstractImageEncoder.byteFromChar('T'));
            l = this.update_crc(l, AbstractImageEncoder.byteFromChar('E'));
            int n6 = 0;
            while (n6 < n3) {
                by = AbstractImageEncoder.byteFromInt(colorModel.getRed(n6));
                n = AbstractImageEncoder.byteFromInt(colorModel.getGreen(n6));
                byte by2 = AbstractImageEncoder.byteFromInt(colorModel.getBlue(n6));
                l = this.update_crc(l, by);
                l = this.update_crc(l, (byte)n);
                l = this.update_crc(l, by2);
                outputStream.write(by);
                outputStream.write(n);
                outputStream.write(by2);
                ++n6;
            }
            outputStream.write(AbstractImageEncoder.bytesFromLong(this.end_crc(l)));
        }
        byte[] byArray2 = null;
        byArray2 = n2 == 8 ? new byte[byArray.length + n5] : new byte[nArray.length * 4 + n5];
        by = 0;
        by = n2 > 8 ? this.compress(byArray2, nArray, colorModel, n4, n5) : this.compress(byArray2, byArray, n4, n5);
        l = this.start_crc();
        outputStream.write(AbstractImageEncoder.bytesFromLong(by));
        outputStream.write(AbstractImageEncoder.byteFromChar('I'));
        outputStream.write(AbstractImageEncoder.byteFromChar('D'));
        outputStream.write(AbstractImageEncoder.byteFromChar('A'));
        outputStream.write(AbstractImageEncoder.byteFromChar('T'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('I'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('D'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('A'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('T'));
        outputStream.write(byArray2, 0, by);
        n = 0;
        while (n < by) {
            l = this.update_crc(l, byArray2[n]);
            ++n;
        }
        outputStream.write(AbstractImageEncoder.bytesFromLong(this.end_crc(l)));
        l = this.start_crc();
        outputStream.write(AbstractImageEncoder.bytesFromLong(0L));
        outputStream.write(AbstractImageEncoder.byteFromChar('I'));
        outputStream.write(AbstractImageEncoder.byteFromChar('E'));
        outputStream.write(AbstractImageEncoder.byteFromChar('N'));
        outputStream.write(AbstractImageEncoder.byteFromChar('D'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('I'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('E'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('N'));
        l = this.update_crc(l, AbstractImageEncoder.byteFromChar('D'));
        outputStream.write(AbstractImageEncoder.bytesFromLong(this.end_crc(l)));
    }

    public int compress(byte[] byArray, int[] nArray, ColorModel colorModel, int n, int n2) throws EncoderException {
        Deflater deflater = new Deflater(-1);
        byte[] byArray2 = new byte[nArray.length * 4 + n2];
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            n3 = n5 * (n * 4 + 1);
            byArray2[n3++] = AbstractImageEncoder.byteFromInt(0);
            int n6 = 0;
            while (n6 < n * 4) {
                n4 = nArray[n5 * n + (int)Math.floor(n6 / 4)];
                byArray2[n3++] = (byte)colorModel.getRed(n4);
                byArray2[n3++] = (byte)colorModel.getGreen(n4);
                byArray2[n3++] = (byte)colorModel.getBlue(n4);
                byArray2[n3++] = (byte)colorModel.getAlpha(n4);
                n6 += 4;
            }
            ++n5;
        }
        deflater.setInput(byArray2, 0, byArray2.length);
        deflater.finish();
        deflater.deflate(byArray);
        if (!deflater.finished()) {
            this.error("PNG encoding error: Deflater could not compress image data.");
        }
        byte[] byArray3 = AbstractImageEncoder.bytesFromLong(deflater.getAdler());
        return deflater.getTotalOut();
    }

    public int compress(byte[] byArray, byte[] byArray2, int n, int n2) throws EncoderException {
        Deflater deflater = new Deflater(-1);
        byte[] byArray3 = new byte[byArray2.length + n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray3[n3 * (n + 1)] = AbstractImageEncoder.byteFromInt(0);
            int n4 = 0;
            while (n4 < n) {
                byArray3[n3 * (n + 1) + n4 + 1] = byArray2[n3 * n + n4];
                ++n4;
            }
            ++n3;
        }
        deflater.setInput(byArray3, 0, byArray3.length);
        deflater.finish();
        deflater.deflate(byArray);
        if (!deflater.finished()) {
            this.error("PNG encoding error: Deflater could not compress image data.");
        }
        return deflater.getTotalOut();
    }

    void make_crc_table() {
        this.crc_table = new long[256];
        int n = 0;
        while (n < 256) {
            long l = n;
            int n2 = 0;
            while (n2 < 8) {
                l = (l & 1L) != 0L ? 0xEDB88320L ^ l >> 1 : (l >>= 1);
                ++n2;
            }
            this.crc_table[n] = l;
            ++n;
        }
    }

    long start_crc() {
        return 0xFFFFFFFFL;
    }

    long end_crc(long l) {
        return l ^ 0xFFFFFFFFL;
    }

    long update_crc(long l, byte[] byArray) {
        long l2 = l;
        int n = 0;
        while (n < byArray.length) {
            l2 = this.update_crc(l2, byArray[n]);
            ++n;
        }
        return l2;
    }

    long update_crc(long l, byte by) {
        if (this.crc_table == null) {
            this.make_crc_table();
        }
        return this.crc_table[(int)((l ^ (long)by) & 0xFFL)] ^ l >> 8;
    }
}

