/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;

public class JCGridLayout
extends GridLayout {
    protected int hgap;
    protected int vgap;
    protected int rows;
    protected int cols;
    protected int[] row_heights = new int[0];
    protected int[] col_widths = new int[0];
    public static final int VARIABLE = 0;

    public JCGridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public JCGridLayout(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
    }

    protected void getGridSizes(Container container, boolean bl) {
        int n = container.getComponentCount();
        if (n == 0) {
            return;
        }
        int n2 = this.rows;
        int n3 = this.cols;
        if (n2 > 0) {
            n3 = (n + n2 - 1) / n2;
        } else {
            n2 = (n + n3 - 1) / n3;
        }
        this.row_heights = new int[n2];
        this.col_widths = new int[n3];
        int n4 = 0;
        while (n4 < n) {
            int n5;
            Component component = container.getComponent(n4);
            Dimension dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
            int n6 = n4 / n3;
            if (dimension.height > this.row_heights[n6]) {
                this.row_heights[n6] = dimension.height;
            }
            if (dimension.width > this.col_widths[n5 = n4 % n3]) {
                this.col_widths[n5] = dimension.width;
            }
            ++n4;
        }
    }

    final int sum(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2];
            ++n2;
        }
        return n;
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getGridSizes(container, false);
        return new Dimension(insets.left + insets.right + this.sum(this.col_widths) + (this.col_widths.length + 1) * this.hgap, insets.top + insets.bottom + this.sum(this.row_heights) + (this.row_heights.length + 1) * this.vgap);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        this.getGridSizes(container, true);
        return new Dimension(insets.left + insets.right + this.sum(this.col_widths) + (this.col_widths.length + 1) * this.hgap, insets.top + insets.bottom + this.sum(this.row_heights) + (this.row_heights.length + 1) * this.vgap);
    }

    protected void setBounds(int n, int n2, int n3, Component component, int n4, int n5, int n6, int n7) {
        component.setBounds(n4, n5, n6, n7);
    }

    public void layoutContainer(Container container) {
        int n = container.getComponentCount();
        if (n == 0) {
            return;
        }
        Insets insets = container.getInsets();
        this.getGridSizes(container, false);
        int n2 = this.rows;
        int n3 = this.cols;
        if (n2 > 0) {
            n3 = (n + n2 - 1) / n2;
        } else {
            n2 = (n + n3 - 1) / n3;
        }
        Dimension dimension = container.getSize();
        int n4 = 0;
        int n5 = insets.left + this.hgap;
        while (n4 < n3) {
            int n6 = 0;
            int n7 = insets.top + this.vgap;
            while (n6 < n2) {
                int n8 = n6 * n3 + n4;
                if (n8 < n) {
                    int n9 = Math.max(0, Math.min(this.col_widths[n4], dimension.width - insets.right - n5));
                    int n10 = Math.max(0, Math.min(this.row_heights[n6], dimension.height - insets.bottom - n7));
                    this.setBounds(n8, n6, n4, container.getComponent(n8), n5, n7, n9, n10);
                }
                n7 += this.row_heights[n6] + this.vgap;
                ++n6;
            }
            n5 += this.col_widths[n4] + this.hgap;
            ++n4;
        }
    }
}

