/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.customizer;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCPolarRadarChartFormat;
import com.klg.jclass.chart.customizer.JBooleanEditor;
import com.klg.jclass.chart.customizer.JCustomizerBundle;
import com.klg.jclass.chart.customizer.JDoubleEditor;
import com.klg.jclass.chart.customizer.JPropertyPage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PolarRadarChartPage
extends JPropertyPage {
    private JDoubleEditor originBaseField = null;
    private JDoubleEditor rAxisAngleField = null;
    private JBooleanEditor halfRangeCheckBox = null;
    private JBooleanEditor webGridLinesCheckBox = null;
    private ChartDataView view = null;

    public void init() {
        super.init();
        this.setToolTipText(PolarRadarChartPage.getPageTitle());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        this.add(new JLabel(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key58") + ":"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 4));
        this.originBaseField = new JDoubleEditor(7);
        this.originBaseField.addPropertyChangeListener(this);
        jPanel.add(this.originBaseField);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        this.add(new JLabel(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key59") + ":"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 4));
        this.rAxisAngleField = new JDoubleEditor(7);
        this.rAxisAngleField.addPropertyChangeListener(this);
        jPanel2.add(this.rAxisAngleField);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 0, 4));
        this.halfRangeCheckBox = new JBooleanEditor(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key60"));
        this.halfRangeCheckBox.addPropertyChangeListener(this);
        jPanel3.add(this.halfRangeCheckBox);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 0, 4));
        this.webGridLinesCheckBox = new JBooleanEditor(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key61"));
        this.webGridLinesCheckBox.addPropertyChangeListener(this);
        jPanel4.add(this.webGridLinesCheckBox);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        this.add(jPanel4);
    }

    public void setObject(Object object) {
        JCPolarRadarChartFormat jCPolarRadarChartFormat;
        if (object instanceof JCChart) {
            this.view = ((JCChart)object).getDataView(0);
        } else if (object instanceof ChartDataView) {
            this.view = (ChartDataView)object;
        }
        if (this.isPolarRadar(this.view) && (jCPolarRadarChartFormat = (JCPolarRadarChartFormat)this.view.getChartFormat()) != null) {
            Double d = new Double(jCPolarRadarChartFormat.getOriginBase(1));
            this.originBaseField.setValue(d);
            d = new Double(jCPolarRadarChartFormat.getYAxisAngle(1));
            this.rAxisAngleField.setValue(d);
            Boolean bl = new Boolean(jCPolarRadarChartFormat.isHalfRange());
            this.halfRangeCheckBox.setValue(bl);
            Boolean bl2 = new Boolean(!jCPolarRadarChartFormat.isRadarCircularGrid());
            this.webGridLinesCheckBox.setValue(bl2);
        }
    }

    public void propertyChanged(Object object, Object object2) {
        if (!this.isPolarRadar(this.view) || object == null) {
            return;
        }
        JCPolarRadarChartFormat jCPolarRadarChartFormat = (JCPolarRadarChartFormat)this.view.getChartFormat();
        if (jCPolarRadarChartFormat == null) {
            return;
        }
        if (object2 instanceof Double) {
            if (object == this.originBaseField) {
                jCPolarRadarChartFormat.setOriginBase(1, (Double)object2);
            } else if (object == this.rAxisAngleField) {
                jCPolarRadarChartFormat.setYAxisAngle(1, (Double)object2);
            }
            this.setObject(this.view);
        } else if (object2 instanceof Boolean) {
            if (object == this.halfRangeCheckBox) {
                jCPolarRadarChartFormat.setHalfRange((Boolean)object2);
            } else if (object == this.webGridLinesCheckBox) {
                jCPolarRadarChartFormat.setRadarCircularGrid((Boolean)object2 == false);
            }
        }
    }

    private boolean isPolarRadar(ChartDataView chartDataView) {
        if (chartDataView == null) {
            return false;
        }
        int n = chartDataView.getChartType();
        return n == 2 || n == 3 || n == 4;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("com.klg.jclass.chart.customizer.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(PolarRadarChartPage.getPageTitle());
        serializable = new PolarRadarChartPage();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((PolarRadarChartPage)serializable).init();
        ((PolarRadarChartPage)serializable).setObject(new JCChart());
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        jFrame.setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key57");
    }

    public static String getPageName() {
        return "PolarRadarChartPage";
    }
}

