/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaRadarChartDraw;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.chart.PolarChartDraw;
import java.awt.Point;
import java.awt.geom.Line2D;

public class RadarChartDraw
extends PolarChartDraw {
    protected int firstPoint = Integer.MIN_VALUE;
    protected int lastPoint = Integer.MAX_VALUE;
    double thetaEditPoint = 0.0;

    public void recalc(int n, int n2, int n3) {
        super.recalc(n, n2, n3);
        if (n3 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.firstPoint = Integer.MIN_VALUE;
        this.lastPoint = Integer.MAX_VALUE;
        int n4 = n3 == -1 ? 0 : n3;
        int n5 = n3 == -1 ? this.seriesList.size() : n3 + 1;
        int n6 = n4;
        while (n6 < n5) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n6);
            if (chartDataViewSeries.isVisible()) {
                int n7 = chartDataViewSeries.getFirstPoint();
                if (n7 > this.firstPoint) {
                    this.firstPoint = n7;
                }
                if ((n7 = chartDataViewSeries.getLastPoint()) < this.lastPoint) {
                    this.lastPoint = n7;
                }
            }
            ++n6;
        }
    }

    PlotPoint getPlotPoint(int n, int n2, double d, double d2) {
        PlotPoint plotPoint = new PlotPoint();
        if (this.xaxis != null && this.yaxis != null && d2 != this.holeValue) {
            Point point = null;
            double d3 = JCChartUtil.getRadarAngle(2, n2, n, false);
            point = this.yaxis.toPixelPolar(d3, d2, true);
            plotPoint.px = point.x;
            plotPoint.py = point.y;
            plotPoint.drawPoint = true;
            plotPoint.valid = true;
        } else {
            plotPoint.px = 2.147483647E9;
            plotPoint.py = 2.147483647E9;
            plotPoint.drawPoint = false;
            plotPoint.valid = false;
        }
        return plotPoint;
    }

    protected double getThetaValue(int n, int n2, int n3, double[] dArray) {
        int n4 = n3 - n2 + 1;
        return JCChartUtil.getRadarAngle(2, n4, n - n2, false);
    }

    protected int getFirstPoint(ChartDataViewSeries chartDataViewSeries) {
        return this.firstPoint;
    }

    protected int getLastPoint(ChartDataViewSeries chartDataViewSeries) {
        return this.lastPoint;
    }

    public Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
        double d = chartDataViewSeries.getY(n);
        int[] nArray = ChartDataView.getFirstLastPoints(this.dataObject);
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = n4 - n3 + 1;
        double d2 = JCChartUtil.getRadarAngle(2, n5, n - n3, false);
        if (this.yaxis != null && d != this.holeValue && d2 != this.holeValue) {
            return this.yaxis.toPixelPolar(d2, d, true);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || jCDataIndex.series == null) {
            return;
        }
        int n = jCDataIndex.series.getDrawingOrder();
        this.last = null;
        this.next = null;
        this.prev = null;
        int[] nArray = ChartDataView.getFirstLastPoints(this.dataObject);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = n3 - n2 + 1;
        int n5 = jCDataIndex.point;
        int n6 = -1;
        double d = Double.MAX_VALUE;
        double d2 = jCDataIndex.series.getX(n5);
        double d3 = jCDataIndex.series.getY(n5);
        if (this instanceof AreaRadarChartDraw) {
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        }
        if (d2 != Double.MAX_VALUE && d3 != Double.MAX_VALUE && d2 != this.dataObject.getHoleValue() && d3 != this.dataObject.getHoleValue()) {
            this.thetaEditPoint = d = JCChartUtil.getRadarAngle(2, n4, n5 - n2, this.xaxis.isReversed());
            double d4 = this.yaxis.isReversed() ? this.yaxis.min.value : this.yaxis.max.value;
            Point point = this.yaxis.toPixelPolar(JCChartUtil.boundAngle(2, d + 1.5707963267948966), d4, true);
            Point point2 = this.yaxis.toPixelPolar(JCChartUtil.boundAngle(2, d - 1.5707963267948966), d4, true);
            this.perpendicular = new Line2D.Double(point.x, point.y, point2.x, point2.y);
        }
        n6 = n5 - 1 < n2 ? n3 : n5 - 1;
        d2 = jCDataIndex.series.getX(n6);
        d3 = jCDataIndex.series.getY(n6);
        if (d2 != Double.MAX_VALUE && d3 != Double.MAX_VALUE && d2 != this.dataObject.getHoleValue() && d3 != this.dataObject.getHoleValue()) {
            d = JCChartUtil.getRadarAngle(2, n4, n6 - n2, this.xaxis.isReversed());
            this.prev = this.yaxis.toPixelPolar(d, d3, true);
        }
        n6 = n5 + 1 > n3 ? n2 : n5 + 1;
        d2 = jCDataIndex.series.getX(n6);
        d3 = jCDataIndex.series.getY(n6);
        if (d2 != Double.MAX_VALUE && d3 != Double.MAX_VALUE && d2 != this.dataObject.getHoleValue() && d3 != this.dataObject.getHoleValue()) {
            d = JCChartUtil.getRadarAngle(2, n4, n6 - n2, this.xaxis.isReversed());
            this.next = this.yaxis.toPixelPolar(d, d3, true);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || this.perpendicular == null) {
            return;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        double d = this.perpendicular.ptLineDist(n, n2);
        int n3 = this.perpendicular.relativeCCW(n, n2);
        if (n3 == -1) {
            d *= -1.0;
        }
        JCAxis jCAxis = jCDataIndex.dataView.getYAxis();
        this.last = jCAxis.toPixelPolar(this.thetaEditPoint, d, false);
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }
}

