/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.JCStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class JCFillStyle
extends JCStyle {
    protected Color color = null;
    protected Color backgroundColor = null;
    protected int pattern = 1;
    protected int colorIndex;
    protected Image image = null;
    protected Rectangle anchorRect = null;
    protected int orientation = 0;
    protected TexturePaint customPaint = null;
    protected Paint fillPaint = null;
    protected Paint hiFillPaint = null;
    protected Paint shFillPaint = null;
    protected transient BufferedImage buffImage = null;
    protected int fillCorrection = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int CENTER = 5;
    public static final int BOTTOM_LEFT = 6;
    public static final int TOP_LEFT = 7;
    public static final int BOTTOM_RIGHT = 8;
    public static final int TOP_RIGHT = 9;
    public static final int NONE = 0;
    public static final int SOLID = 1;
    public static final int PER_25 = 2;
    public static final int PER_50 = 3;
    public static final int PER_75 = 4;
    public static final int HORIZ_STRIPE = 5;
    public static final int VERT_STRIPE = 6;
    public static final int STRIPE_45 = 7;
    public static final int STRIPE_135 = 8;
    public static final int DIAG_HATCHED = 9;
    public static final int CROSS_HATCHED = 10;
    public static final int CUSTOM_FILL = 11;
    public static final int CUSTOM_STACK = 12;
    public static final int CUSTOM_PAINT = 13;
    public static final String[] PER_25_PIXELS = new String[]{"C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                ", "C C C C C C C C C C C C C C C C ", "                                "};
    public static final String[] PER_50_PIXELS = new String[]{"C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C", "C C C C C C C C C C C C C C C C ", " C C C C C C C C C C C C C C C C"};
    public static final String[] PER_75_PIXELS = new String[]{"CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC", "CCC CCC CCC CCC CCC CCC CCC CCC ", "C CCC CCC CCC CCC CCC CCC CCC CC"};
    public static final String[] HORIZ_STRIPE_PIXELS = new String[]{"                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                ", "                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                ", "                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                ", "                                ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "                                "};
    public static final String[] VERT_STRIPE_PIXELS = new String[]{"CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  ", "CC  CC  CC  CC  CC  CC  CC  CC  "};
    public static final String[] STRIPE_45_PIXELS = new String[]{"   CC      CC      CC      CC   ", "  CC      CC      CC      CC    ", " CC      CC      CC      CC     ", "CC      CC      CC      CC      ", "C      CC      CC      CC      C", "      CC      CC      CC      CC", "     CC      CC      CC      CC ", "    CC      CC      CC      CC  ", "   CC      CC      CC      CC   ", "  CC      CC      CC      CC    ", " CC      CC      CC      CC     ", "CC      CC      CC      CC      ", "C      CC      CC      CC      C", "      CC      CC      CC      CC", "     CC      CC      CC      CC ", "    CC      CC      CC      CC  "};
    public static final String[] STRIPE_135_PIXELS = new String[]{"C      CC      CC      CC      C", "CC      CC      CC      CC      ", " CC      CC      CC      CC     ", "  CC      CC      CC      CC    ", "   CC      CC      CC      CC   ", "    CC      CC      CC      CC  ", "     CC      CC      CC      CC ", "      CC      CC      CC      CC", "C      CC      CC      CC      C", "CC      CC      CC      CC      ", " CC      CC      CC      CC     ", "  CC      CC      CC      CC    ", "   CC      CC      CC      CC   ", "    CC      CC      CC      CC  ", "     CC      CC      CC      CC ", "      CC      CC      CC      CC"};
    public static final String[] DIAG_HATCHED_PIXELS = new String[]{"CC      CC      CC      CC      ", "CCC    CCCC    CCCC    CCCC    C", "  CC  CC  CC  CC  CC  CC  CC  CC", "   CCCC    CCCC    CCCC    CCCC ", "    CC      CC      CC      CC  ", "   CCCC    CCCC    CCCC    CCCC ", "  CC  CC  CC  CC  CC  CC  CC  CC", "CCC    CCCC    CCCC    CCCC    C", "CC      CC      CC      CC      ", "CCC    CCCC    CCCC    CCCC    C", "  CC  CC  CC  CC  CC  CC  CC  CC", "   CCCC    CCCC    CCCC    CCCC ", "    CC      CC      CC      CC  ", "   CCCC    CCCC    CCCC    CCCC ", "  CC  CC  CC  CC  CC  CC  CC  CC", "CCC    CCCC    CCCC    CCCC    C"};
    public static final String[] CROSS_HATCHED_PIXELS = new String[]{"CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      ", "CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      ", "CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      ", "CC      CC      CC      CC      ", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC", "CC      CC      CC      CC      "};

    public JCFillStyle(Color color, int n) {
        this.color = color;
        this.pattern = n;
        this.buffImage = this.makeBufferedImage();
        this.fillPaint = null;
        this.hiFillPaint = null;
        this.shFillPaint = null;
    }

    public static JCFillStyle makeDefault(JCChart jCChart) {
        return JCFillStyle.makeDefault(jCChart, false);
    }

    public static JCFillStyle makeDefault(JCChart jCChart, boolean bl) {
        JCFillStyle jCFillStyle = new JCFillStyle(JCFillStyle.getDefaultColor(jCChart, bl), JCFillStyle.getDefaultPattern(jCChart));
        int n = 0;
        if (jCChart != null) {
            n = jCChart.getFillColorIndex();
            n = n == 0 ? JCStyle.defaultColors.length - 1 : --n;
        }
        jCFillStyle.colorIndex = n;
        return jCFillStyle;
    }

    public boolean updateGraphics(Graphics graphics) {
        if (this.pattern == 0) {
            return false;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!graphics.getColor().equals(this.color)) {
            graphics.setColor(this.color);
        }
        if (this.pattern != 12 || this.image == null) {
            if (this.pattern == 13) {
                this.fillPaint = this.customPaint != null ? this.makeFillPaint(this.customPaint.getImage(), this.color, this.anchorRect, this.orientation) : this.color;
            } else if (this.pattern != 1 || this.fillPaint == null) {
                this.fillPaint = this.makeFillPaint(this.buffImage, this.color, this.anchorRect, this.orientation);
            }
            graphics2D.setPaint(this.fillPaint);
        }
        return true;
    }

    public boolean updateGraphicsToShadow(Graphics graphics) {
        if (this.pattern == 0) {
            return false;
        }
        Color color = JCChartUtil.darker(this.color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pattern != 12 || this.image == null) {
            if (this.pattern == 13) {
                this.shFillPaint = this.customPaint != null ? this.makeFillPaint(this.customPaint.getImage(), color, this.anchorRect, this.orientation) : color;
            } else if (this.pattern != 1 || this.shFillPaint == null) {
                this.shFillPaint = this.pattern == 11 ? this.makeFillPaint(this.buffImage, color, this.anchorRect, this.orientation) : this.makeFillPaint(this.makeBufferedImage(color), color, this.anchorRect, this.orientation);
            }
            graphics2D.setPaint(this.shFillPaint);
        }
        return true;
    }

    public boolean updateGraphicsToHighlight(Graphics graphics) {
        if (this.pattern == 0) {
            return false;
        }
        Color color = JCChartUtil.brighter(this.color);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.pattern != 12 || this.image == null) {
            if (this.pattern == 13) {
                this.hiFillPaint = this.customPaint != null ? this.makeFillPaint(this.customPaint.getImage(), color, this.anchorRect, this.orientation) : color;
            } else if (this.pattern != 1 || this.hiFillPaint == null) {
                this.hiFillPaint = this.pattern == 11 ? this.makeFillPaint(this.buffImage, color, this.anchorRect, this.orientation) : this.makeFillPaint(this.makeBufferedImage(color), color, this.anchorRect, this.orientation);
            }
            graphics2D.setPaint(this.hiFillPaint);
        }
        return true;
    }

    public void resetGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.color);
    }

    public void updateFillOrientation(Rectangle rectangle, int n) {
        this.anchorRect = rectangle;
        this.orientation = n;
    }

    public void resetFillOrientation() {
        this.anchorRect = null;
        this.orientation = 0;
    }

    public void fillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.updateGraphics(graphics)) {
            graphics.fillRect(n, n2, n3, n4);
            this.resetGraphics(graphics);
        }
    }

    public void fillImageRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (this.image == null) {
            return;
        }
        int n5 = this.image.getHeight(null);
        int n6 = this.image.getWidth(null);
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        Graphics graphics2 = graphics.create();
        graphics2.clipRect(n, n2, n3, n4);
        if (!bl2) {
            int n7 = n + (n3 - n6) / 2;
            if (bl) {
                int n8 = n2 + n4 - n5;
                while (n8 > n2) {
                    graphics2.drawImage(this.image, n7, n8, null);
                    n8 -= n5;
                }
                graphics2.drawImage(this.image, n7, n8, null);
            } else {
                int n9 = n2 + 1;
                while (n9 < n2 + n4) {
                    graphics2.drawImage(this.image, n7, n9, null);
                    n9 += n5;
                }
            }
        } else {
            int n10 = n2 + (n4 - n5) / 2;
            if (bl) {
                int n11 = n + 1;
                while (n11 < n + n3) {
                    graphics2.drawImage(this.image, n11, n10, null);
                    n11 += n6;
                }
            } else {
                int n12 = n + n3 - n6;
                while (n12 > n) {
                    graphics2.drawImage(this.image, n12, n10, null);
                    n12 -= n6;
                }
                graphics2.drawImage(this.image, n12, n10, null);
            }
        }
        graphics2.dispose();
    }

    public void fillOutlineRect(Graphics graphics, int n, int n2, int n3, int n4) {
        this.fillOutlineRect(graphics, n, n2, n3, n4, (Color)null);
    }

    public void fillOutlineRect(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.fillOutlineRect(graphics, n, n2, n3, n4, new JCLineStyle(1, color, 1));
    }

    public void fillOutlineRect(Graphics graphics, int n, int n2, int n3, int n4, JCLineStyle jCLineStyle) {
        this.fillRect(graphics, n, n2, n3, n4);
        this.drawOutlineRect(graphics, n, n2, n3, n4, jCLineStyle);
    }

    public void drawOutlineRect(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.drawOutlineRect(graphics, n, n2, n3, n4, new JCLineStyle(1, color, 1));
    }

    public void drawOutlineRect(Graphics graphics, int n, int n2, int n3, int n4, JCLineStyle jCLineStyle) {
        if (jCLineStyle != null) {
            jCLineStyle.drawRect(graphics, n, n2, n3, n4);
        }
    }

    public void fillPolygon(Graphics graphics, Polygon polygon) {
        if (this.updateGraphics(graphics)) {
            graphics.fillPolygon(polygon);
            this.resetGraphics(graphics);
        }
    }

    public void fillPolygon(Graphics graphics, Shape shape) {
        if (this.updateGraphics(graphics)) {
            ((Graphics2D)graphics).fill(shape);
            this.resetGraphics(graphics);
        }
    }

    public void fillOutlinePolygon(Graphics graphics, Polygon polygon, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.fillOutlinePolygon(graphics, polygon, new JCLineStyle(1, color, 1));
    }

    public void fillOutlinePolygon(Graphics graphics, Polygon polygon, JCLineStyle jCLineStyle) {
        this.fillPolygon(graphics, polygon);
        this.drawOutlinePolygon(graphics, polygon, jCLineStyle);
    }

    public void drawOutlinePolygon(Graphics graphics, Polygon polygon, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.drawOutlinePolygon(graphics, polygon, new JCLineStyle(1, color, 1));
    }

    public void drawOutlinePolygon(Graphics graphics, Polygon polygon, JCLineStyle jCLineStyle) {
        this.drawOutlineLine(graphics, polygon, 0, 0, jCLineStyle);
    }

    public void drawOutlineLine(Graphics graphics, Polygon polygon, int n, int n2, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.drawOutlineLine(graphics, polygon, n, n2, new JCLineStyle(1, color, 1));
    }

    public void drawOutlineLine(Graphics graphics, Polygon polygon, int n, int n2, JCLineStyle jCLineStyle) {
        if (jCLineStyle == null) {
            return;
        }
        if (n2 <= n) {
            int n3 = n;
            while (n3 < polygon.npoints - 1) {
                jCLineStyle.drawLine(graphics, (double)polygon.xpoints[n3], (double)polygon.ypoints[n3], (double)polygon.xpoints[n3 + 1], (double)polygon.ypoints[n3 + 1]);
                ++n3;
            }
            jCLineStyle.drawLine(graphics, (double)polygon.xpoints[polygon.npoints - 1], (double)polygon.ypoints[polygon.npoints - 1], (double)polygon.xpoints[0], (double)polygon.ypoints[0]);
            int n4 = 0;
            while (n4 < n2) {
                jCLineStyle.drawLine(graphics, (double)polygon.xpoints[n4], (double)polygon.ypoints[n4], (double)polygon.xpoints[n4 + 1], (double)polygon.ypoints[n4 + 1]);
                ++n4;
            }
        } else {
            int n5 = n;
            while (n5 < n2 && n5 < polygon.npoints - 1) {
                jCLineStyle.drawLine(graphics, (double)polygon.xpoints[n5], (double)polygon.ypoints[n5], (double)polygon.xpoints[n5 + 1], (double)polygon.ypoints[n5 + 1]);
                ++n5;
            }
        }
    }

    public void fillOutlinePartialPolygon(Graphics graphics, Polygon polygon, Color color) {
        if (color == null) {
            color = this.calcOutlineColor();
        }
        this.fillOutlinePartialPolygon(graphics, polygon, new JCLineStyle(1, color, 1));
    }

    public void fillOutlinePartialPolygon(Graphics graphics, Polygon polygon, JCLineStyle jCLineStyle) {
        this.fillPolygon(graphics, polygon);
        if (jCLineStyle == null) {
            return;
        }
        Color color = jCLineStyle.getColor();
        int n = jCLineStyle.getPattern();
        Color color2 = graphics.getColor();
        if (!color.equals(color2)) {
            jCLineStyle.setColor(color2);
        }
        jCLineStyle.setPattern(1);
        jCLineStyle.drawLine(graphics, (double)polygon.xpoints[0], (double)polygon.ypoints[0], (double)polygon.xpoints[polygon.npoints - 1], (double)polygon.ypoints[polygon.npoints - 1]);
        jCLineStyle.setPattern(n);
        if (!color.equals(color2)) {
            jCLineStyle.setColor(color);
        }
        int n2 = 0;
        while (n2 < polygon.npoints - 1) {
            jCLineStyle.drawLine(graphics, (double)polygon.xpoints[n2], (double)polygon.ypoints[n2], (double)polygon.xpoints[n2 + 1], (double)polygon.ypoints[n2 + 1]);
            ++n2;
        }
    }

    public void fillPolygonShadow(Graphics graphics, Polygon polygon) {
        if (this.updateGraphicsToShadow(graphics)) {
            graphics.fillPolygon(polygon);
            this.resetGraphics(graphics);
        }
    }

    public void fillPolygonShadow(Graphics graphics, Shape shape) {
        if (this.updateGraphicsToShadow(graphics)) {
            ((Graphics2D)graphics).fill(shape);
            this.resetGraphics(graphics);
        }
    }

    public void fillPolygonHighlight(Graphics graphics, Polygon polygon) {
        if (this.updateGraphicsToHighlight(graphics)) {
            graphics.fillPolygon(polygon);
            this.resetGraphics(graphics);
        }
    }

    public void fillOutlinePolygonShadow(Graphics graphics, Polygon polygon) {
        this.fillOutlinePolygonShadow(graphics, polygon, null);
    }

    public void fillOutlinePolygonShadow(Graphics graphics, Polygon polygon, Color color) {
        this.fillPolygonShadow(graphics, polygon);
        this.drawOutlinePolygon(graphics, polygon, color);
    }

    public void fillOutlinePolygonHighlight(Graphics graphics, Polygon polygon) {
        this.fillOutlinePolygonHighlight(graphics, polygon, null);
    }

    public void fillOutlinePolygonHighlight(Graphics graphics, Polygon polygon, Color color) {
        this.fillPolygonHighlight(graphics, polygon);
        this.drawOutlinePolygon(graphics, polygon, color);
    }

    Color calcOutlineColor() {
        Color color = JCChartUtil.darker(this.color);
        if (color.equals(this.color)) {
            color = JCChartUtil.brighter(this.color);
        }
        return color;
    }

    public void fillArc(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.updateGraphics(graphics)) {
            graphics.fillArc(n, n2, n3 + this.fillCorrection, n4 + this.fillCorrection, n5, n6);
            this.resetGraphics(graphics);
        }
    }

    public void fillArcShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.updateGraphicsToShadow(graphics)) {
            graphics.fillArc(n, n2, n3 + this.fillCorrection, n4 + this.fillCorrection, n5, n6);
            this.resetGraphics(graphics);
        }
    }

    public void fillArc(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.updateGraphics(graphics)) {
            ((Graphics2D)graphics).fill(new Arc2D.Double(d, d2, d3, d4, d5, d6, 2));
            this.resetGraphics(graphics);
        }
    }

    public void fillArcShadow(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.updateGraphicsToShadow(graphics)) {
            ((Graphics2D)graphics).fill(new Arc2D.Double(d, d2, d3, d4, d5, d6, 2));
            this.resetGraphics(graphics);
        }
    }

    public void fillCircle(Graphics graphics, int n, int n2, int n3) {
        if (this.updateGraphics(graphics)) {
            int n4 = 2 * n3 + this.fillCorrection;
            graphics.fillArc(n - n3, n2 - n3, n4, n4, 0, 360);
            this.resetGraphics(graphics);
        }
    }

    public void setFillCorrection(int n) {
        this.fillCorrection = n;
    }

    public int getFillCorrection() {
        return this.fillCorrection;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.pattern != 11 && this.pattern != 12 && this.pattern != 13) {
            this.buffImage = this.makeBufferedImage();
            this.fillPaint = null;
            this.hiFillPaint = null;
            this.shFillPaint = null;
        }
        this.setChanged(true, 17);
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
        if (this.pattern != 11 && this.pattern != 12 && this.pattern != 13) {
            this.buffImage = this.makeBufferedImage();
            this.fillPaint = null;
            this.hiFillPaint = null;
            this.shFillPaint = null;
        }
        this.setChanged(true, 17);
    }

    public int getPattern() {
        return this.pattern;
    }

    public void setPattern(int n) {
        if (n == this.pattern) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.pattern = n;
                this.buffImage = this.makeBufferedImage();
                this.fillPaint = null;
                this.hiFillPaint = null;
                this.shFillPaint = null;
                break;
            }
            case 11: {
                this.pattern = n;
                this.buffImage = this.makeBufferedImage(this.image);
                this.fillPaint = null;
                this.hiFillPaint = null;
                this.shFillPaint = null;
                break;
            }
            case 12: {
                this.pattern = n;
                this.fillPaint = null;
                this.hiFillPaint = null;
                this.shFillPaint = null;
                break;
            }
            case 13: {
                this.pattern = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for Pattern in JCFillStyle.  Must be one of NONE, SOLID, PER_25, PER_50, PER_75, HORIZ_STRIPE, VERT_STRIPE, STRIPE_45, STRIPE_135, DIAG_HATCHED, CROSS_HATCHED, CUSTOM_FILL, or CUSTOM_STACK");
            }
        }
        this.setChanged(true, 33);
    }

    public TexturePaint getCustomPaint() {
        return this.customPaint;
    }

    public void setCustomPaint(TexturePaint texturePaint) {
        if (texturePaint == this.customPaint) {
            return;
        }
        this.buffImage = null;
        this.customPaint = texturePaint;
        this.setChanged(true, 33);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.image != null) {
            int n = this.image.getHeight(null);
            int n2 = this.image.getWidth(null);
            if (n <= 0 || n2 <= 0) {
                this.image = null;
            }
        }
        if (this.pattern == 11 || this.pattern == 12) {
            this.buffImage = this.makeBufferedImage(this.image);
            this.fillPaint = null;
            this.hiFillPaint = null;
            this.shFillPaint = null;
        }
        this.setChanged(true, 33);
    }

    public void setImage(String string) {
        Image image = new ImageIcon(string).getImage();
        this.setImage(image);
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    static Color getDefaultColor(JCChart jCChart) {
        return JCFillStyle.getDefaultColor(jCChart, false);
    }

    static Color getDefaultColor(JCChart jCChart, boolean bl) {
        Color color;
        int n = 0;
        if (jCChart == null) {
            color = JCStyle.defaultColors[0];
        } else {
            n = jCChart.getFillColorIndex();
            color = JCSymbolStyle.defaultColors[n++];
            if (n >= JCSymbolStyle.defaultColors.length) {
                n = 0;
            }
        }
        if (jCChart != null && jCChart.getChartArea() != null) {
            ChartDataView chartDataView = jCChart.getDataView(0);
            int n2 = n;
            while (!bl && chartDataView != null && chartDataView.getChartType() == 11 && JCChartUtil.colorsNear(color, ((JCPieChartFormat)chartDataView.getChartFormat()).getOtherStyle().getFillColor()) || JCChartUtil.colorsNear(color, jCChart.getChartArea().getPlotArea().getBackground())) {
                color = JCSymbolStyle.defaultColors[n++];
                if (n >= JCSymbolStyle.defaultColors.length) {
                    n = 0;
                }
                if (n == n2) break;
            }
            jCChart.setFillColorIndex(n);
        }
        return color;
    }

    static int getDefaultPattern(JCChart jCChart) {
        return 1;
    }

    public BufferedImage makeBufferedImage() {
        return this.makeBufferedImage(this.color);
    }

    public BufferedImage makeBufferedImage(Color color) {
        if (this.pattern == 0 || this.pattern == 1) {
            return null;
        }
        JCIconCreator jCIconCreator = new JCIconCreator(32, 16);
        jCIconCreator.setColor('C', color);
        Color color2 = this.backgroundColor;
        if (color2 == null) {
            color2 = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        }
        jCIconCreator.setColor(' ', color2);
        String[] stringArray = null;
        switch (this.pattern) {
            case 2: {
                stringArray = PER_25_PIXELS;
                break;
            }
            case 3: {
                stringArray = PER_50_PIXELS;
                break;
            }
            case 4: {
                stringArray = PER_75_PIXELS;
                break;
            }
            case 5: {
                stringArray = HORIZ_STRIPE_PIXELS;
                break;
            }
            case 6: {
                stringArray = VERT_STRIPE_PIXELS;
                break;
            }
            case 7: {
                stringArray = STRIPE_45_PIXELS;
                break;
            }
            case 8: {
                stringArray = STRIPE_135_PIXELS;
                break;
            }
            case 9: {
                stringArray = DIAG_HATCHED_PIXELS;
                break;
            }
            case 10: {
                stringArray = CROSS_HATCHED_PIXELS;
            }
        }
        if (stringArray == null) {
            return null;
        }
        jCIconCreator.setPixels(stringArray);
        Image image = jCIconCreator.getIcon().getImage();
        return this.makeBufferedImage(image);
    }

    public BufferedImage makeBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n < 0 || n2 < 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public Paint makeFillPaint() {
        return this.makeFillPaint(this.buffImage, this.color, null, 0);
    }

    public Paint makeFillPaint(BufferedImage bufferedImage, Color color, Rectangle rectangle, int n) {
        if (this.pattern == 0) {
            return null;
        }
        if (this.pattern == 1) {
            return color;
        }
        if (bufferedImage == null) {
            return color;
        }
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Rectangle rectangle2 = null;
        if (rectangle != null && n != 0) {
            int n4 = (rectangle.width - n2) / 2;
            int n5 = (rectangle.height - n3) / 2;
            switch (n) {
                case 2: {
                    rectangle2 = new Rectangle(n4 + rectangle.x, rectangle.y + rectangle.height - n3, n2, n3);
                    break;
                }
                case 1: {
                    rectangle2 = new Rectangle(n4 + rectangle.x, rectangle.y, n2, n3);
                    break;
                }
                case 3: {
                    rectangle2 = new Rectangle(rectangle.x, n5 + rectangle.y, n2, n3);
                    break;
                }
                case 4: {
                    rectangle2 = new Rectangle(rectangle.x + rectangle.width - n2, n5 + rectangle.y, n2, n3);
                    break;
                }
                case 5: {
                    rectangle2 = new Rectangle(n4 + rectangle.x, n5 + rectangle.y, n2, n3);
                    break;
                }
                case 6: {
                    rectangle2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height - n3, n2, n3);
                    break;
                }
                case 7: {
                    rectangle2 = new Rectangle(rectangle.x, rectangle.y, n2, n3);
                    break;
                }
                case 8: {
                    rectangle2 = new Rectangle(rectangle.x + rectangle.width - n2, rectangle.y + rectangle.height - n3, n2, n3);
                    break;
                }
                case 9: {
                    rectangle2 = new Rectangle(rectangle.x + rectangle.width - n2, rectangle.y, n2, n3);
                    break;
                }
                default: {
                    rectangle2 = null;
                    break;
                }
            }
        } else {
            rectangle2 = new Rectangle(0, 0, n2, n3);
        }
        return new TexturePaint(bufferedImage, rectangle2);
    }

    protected boolean isCustomStackable() {
        return this.pattern == 12 && this.image != null;
    }
}

