/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartUtil;
import java.io.Serializable;

public class JCAxisFormula
implements Serializable {
    private JCAxis originator = null;
    private JCAxis parent = null;
    protected double constant = 0.0;
    protected double multiplier = 1.0;

    JCAxisFormula() {
    }

    JCAxisFormula(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    public void setConstant(double d) {
        if (this.constant == d) {
            return;
        }
        this.constant = d;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public double getConstant() {
        return this.constant;
    }

    public void setMultiplier(double d) {
        if (this.multiplier == d) {
            return;
        }
        this.multiplier = d;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public JCAxis getOriginator() {
        return this.originator;
    }

    public void setOriginator(JCAxis jCAxis) {
        if (this.originator == jCAxis) {
            return;
        }
        if (this.originator == this.parent) {
            throw new IllegalArgumentException("JCAxis cannot be related to itself");
        }
        this.originator = jCAxis;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public JCAxis getParent() {
        return this.parent;
    }

    void calcRelatedParams() {
        double d;
        if (this.originator == null) {
            return;
        }
        if (this.multiplier == 0.0) {
            return;
        }
        double d2 = d = this.multiplier < 0.0 ? -this.multiplier : this.multiplier;
        if (this.parent.vertical != this.originator.vertical) {
            this.parent.vertical = this.originator.vertical;
            this.parent.setInitialSize();
        }
        this.parent.reversed = this.originator.reversed;
        if (this.parent.tickSpacing.isDefault && this.parent.numSpacing.isDefault) {
            this.parent.numSpacing.value = this.originator.numSpacing.value * d;
            this.parent.numSpacing.value = JCChartUtil.precCorrect(this.parent.getPrecision(), this.parent.numSpacing.value);
            if (this.parent.tickSpacing.isDefault) {
                this.parent.tickSpacing.value = this.parent.numSpacing.value / 2.0;
            }
        } else if (this.parent.tickSpacing.isDefault) {
            this.parent.tickSpacing.value = this.parent.numSpacing.value / 2.0;
        } else if (this.parent.numSpacing.isDefault) {
            this.parent.numSpacing.value = this.parent.tickSpacing.value * 2.0;
        }
        if (this.multiplier > 0.0) {
            if (this.parent.min.isDefault) {
                this.parent.min.value = this.originator.min.value * this.multiplier + this.constant;
            } else if (this.originator.min.isDefault) {
                this.originator.min.value = (this.parent.min.value - this.constant) / this.multiplier;
            }
            if (this.parent.max.isDefault) {
                this.parent.max.value = this.originator.max.value * this.multiplier + this.constant;
            } else if (this.originator.max.isDefault) {
                this.originator.max.value = (this.parent.max.value - this.constant) / this.multiplier;
            }
        } else {
            if (this.parent.max.isDefault) {
                this.parent.max.value = this.originator.min.value * this.multiplier + this.constant;
            } else if (this.originator.max.isDefault) {
                this.originator.max.value = (this.parent.min.value - this.constant) / this.multiplier;
            }
            if (this.parent.min.isDefault) {
                this.parent.min.value = this.originator.max.value * this.multiplier + this.constant;
            } else if (this.originator.min.isDefault) {
                this.originator.min.value = (this.parent.max.value - this.constant) / this.multiplier;
            }
        }
    }
}

