/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaPolygon;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

public class AreaChartDraw
extends ChartDraw {
    protected Point firstLast = null;
    JCLineStyle outlineStyle = null;
    protected MinMax xlim = null;
    protected MinMax ylim = null;
    protected Vector[] polyList;
    static final int XINSIDE = 1;
    static final int XBYX1 = 2;
    static final int XBYX2 = 3;
    static final int YINSIDE = 10;
    static final int YBYTOP = 11;
    static final int YBYORIGIN = 12;
    Point prev = null;
    Point next = null;
    Point last = null;
    Rectangle r = null;

    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    public void recalc(int n, int n2) {
        this.recalc(n, n2, -1);
    }

    public void recalc(int n, int n2, int n3) {
        super.recalc();
        this.fastUpdate = this.dataObject.getFastUpdate();
        this.cachePlotData = this.fastUpdate ? true : this.dataObject.getBufferPlotData();
        boolean bl = false;
        if (n >= 0 && n2 >= 0 && n2 >= n && this.polyList != null) {
            bl = true;
        }
        if (n3 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.inverted = this.dataObject.getXAxis().vertical;
        this.holeValue = this.dataObject.getHoleValue();
        this.firstLast = this.dataObject.getFirstLast();
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
        this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        this.dataObject.getDataBounds(this.xlim, this.ylim);
        boolean bl2 = this.xaxis.isLogarithmic();
        boolean bl3 = this.yaxis.isLogarithmic();
        int n4 = this.dataObject.getChartType();
        if (!this.cachePlotData && n3 == -1) {
            if (this.polyList == null) {
                this.polyList = new Vector[this.seriesList.size()];
            }
            return;
        }
        if (!bl) {
            this.polyList = new Vector[this.seriesList.size()];
        }
        int n5 = n3 == -1 ? 0 : n3;
        int n6 = n3 == -1 ? this.seriesList.size() : n3 + 1;
        Object object = null;
        int n7 = n5;
        while (n7 < n6) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n7);
            if (!bl) {
                this.polyList[n7] = null;
            }
            if (chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                int n8;
                Object object2;
                int n9;
                if (!bl) {
                    n = chartDataViewSeries.getFirstPoint();
                    n2 = chartDataViewSeries.getLastPoint();
                    n9 = n2 - n + 1;
                    this.polyList[n7] = new Vector();
                } else {
                    int n10;
                    n9 = n2 + 1;
                    int n11 = n10 = this.polyList[n7] == null ? 0 : this.polyList[n7].size();
                    if (n < n10) {
                        n = n10;
                    }
                }
                double[] dArray = this.getYVals(chartDataViewSeries);
                double d = 0.0;
                double d2 = Double.MAX_VALUE;
                boolean bl4 = false;
                int n12 = 0;
                if (bl && n > 0) {
                    d = chartDataViewSeries.getX(n - 1);
                    d2 = dArray[n - 1];
                    n12 = this.findLastPoly(this.polyList[n7]);
                    if (n12 >= 0) {
                        object2 = (AreaPolygon)this.polyList[n7].elementAt(n12);
                        if (n - 1 >= ((AreaPolygon)object2).startPoint && n - 1 <= ((AreaPolygon)object2).endPoint) {
                            bl4 = true;
                            ((AreaPolygon)object2).poly.npoints -= 2;
                        }
                    } else {
                        bl4 = false;
                        ++n12;
                        if (d == this.holeValue || d2 == Double.MAX_VALUE) {
                            d = 0.0;
                            d2 = Double.MAX_VALUE;
                        }
                        object2 = new AreaPolygon();
                        ((AreaPolygon)object2).series = n7;
                        this.polyList[n7].addElement(object2);
                    }
                } else {
                    object2 = new AreaPolygon();
                    ((AreaPolygon)object2).series = n7;
                    this.polyList[n7].addElement(object2);
                }
                object2 = null;
                if (n4 == 12) {
                    object2 = new int[n2 - n + 1];
                    n8 = 0;
                    while (n8 < ((Object)object2).length) {
                        object2[n8] = object != null && n8 < (object).length ? object[n8] : (Object)this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront);
                        ++n8;
                    }
                }
                n8 = n;
                while (n8 <= n2) {
                    if (n8 < dArray.length) {
                        double d3 = chartDataViewSeries.getX(n8);
                        if (bl2 && d3 <= 0.0) {
                            d3 = this.holeValue;
                        }
                        double d4 = dArray[n8];
                        if (bl3 && d4 <= 0.0) {
                            d4 = this.holeValue;
                        }
                        if (!(bl4 = this.clipAreaPolygon(d, d2, d3, d4, n8, (AreaPolygon)this.polyList[n7].elementAt(n12), bl4, this.inverted)) && ((AreaPolygon)this.polyList[n7].elementAt((int)n12)).poly.npoints > 0) {
                            AreaPolygon areaPolygon = (AreaPolygon)this.polyList[n7].elementAt(n12);
                            if (n4 == 12) {
                                this.finishAreaPolygon(areaPolygon, (int[])object, (int[])object2, this.inverted);
                            } else {
                                this.finishAreaPolygon(areaPolygon.poly, this.inverted);
                            }
                            ++n12;
                            AreaPolygon areaPolygon2 = new AreaPolygon();
                            areaPolygon2.series = n7;
                            this.polyList[n7].addElement(areaPolygon2);
                        }
                        d = d3;
                        d2 = d4;
                    }
                    ++n8;
                }
                AreaPolygon areaPolygon = (AreaPolygon)this.polyList[n7].elementAt(n12);
                if (areaPolygon.poly.npoints > 0) {
                    if (n4 == 12) {
                        this.finishAreaPolygon(areaPolygon, (int[])object, (int[])object2, this.inverted);
                    } else {
                        this.finishAreaPolygon(areaPolygon.poly, this.inverted);
                    }
                } else {
                    this.polyList[n7].setElementAt(null, n12);
                }
                if (n4 == 12) {
                    object = object2;
                }
            }
            ++n7;
        }
    }

    protected double[] getYVals(ChartDataViewSeries chartDataViewSeries) {
        double[] dArray = chartDataViewSeries.getY();
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray2.length) {
            dArray2[n] = dArray[n] == this.holeValue || this.yaxis.isLogarithmic() && dArray[n] <= 0.0 ? Double.MAX_VALUE : dArray[n];
            ++n;
        }
        return dArray2;
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1, true);
    }

    public void draw(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2, true);
    }

    public void draw(Graphics graphics, int n, int n2, boolean bl) {
        if (this.seriesList == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        boolean bl2 = false;
        if (n >= 0 && n2 >= 0 && n2 >= n) {
            bl2 = true;
        }
        if (this.polyList == null) {
            return;
        }
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
        }
        this.outlineStyle = this.dataObject.getOutlineStyle();
        int n3 = bl ? 0 : this.polyList.length - 1;
        while (!bl ? n3 >= 0 : n3 < this.polyList.length) {
            JCChartStyle jCChartStyle;
            ChartDataViewSeries chartDataViewSeries;
            if (!this.cachePlotData) {
                this.recalc(-1, -1, n3);
            }
            if (this.polyList[n3] != null && (chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3)).isVisible() && (jCChartStyle = chartDataViewSeries.getStyle()) != null) {
                int n4;
                int n5;
                AreaPolygon areaPolygon;
                JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
                if (!bl2) {
                    areaPolygon = null;
                    n5 = 0;
                    while (n5 < this.polyList[n3].size()) {
                        areaPolygon = (AreaPolygon)this.polyList[n3].elementAt(n5);
                        if (areaPolygon != null) {
                            Rectangle rectangle2 = areaPolygon.poly.getBounds();
                            n4 = this.calcFillOrientation(rectangle2, this.yaxis.origin.value, this.inverted, this.xaxis.reversed, this.yaxis.reversed);
                            jCFillStyle.updateFillOrientation(rectangle2, n4);
                            jCFillStyle.fillOutlinePolygon(graphics, areaPolygon.poly, this.outlineStyle);
                            jCFillStyle.resetFillOrientation();
                            if (defineShape != null) {
                                this.defineAreaShapes(defineShape, graphics, jCFillStyle, this.inverted, areaPolygon, chartDataViewSeries);
                            }
                        }
                        ++n5;
                    }
                } else {
                    areaPolygon = null;
                    n5 = 0;
                    while (n5 < this.polyList[n3].size()) {
                        areaPolygon = (AreaPolygon)this.polyList[n3].elementAt(n5);
                        if (areaPolygon != null && n <= areaPolygon.endPoint) {
                            if (areaPolygon.startPoint >= n - 1 && areaPolygon.endPoint <= n2) {
                                jCFillStyle.fillOutlinePolygon(graphics, areaPolygon.poly, this.outlineStyle);
                            } else if (n - 1 > areaPolygon.startPoint) {
                                int n6 = n - areaPolygon.startPoint;
                                if (n6 < 0) {
                                    n6 = 0;
                                }
                                n4 = areaPolygon.poly.npoints - n6;
                                int[] nArray = new int[n4];
                                int[] nArray2 = new int[n4];
                                int n7 = 0;
                                while (n7 < n4) {
                                    nArray[n7] = areaPolygon.poly.xpoints[n6 + n7];
                                    nArray2[n7] = areaPolygon.poly.ypoints[n6 + n7];
                                    ++n7;
                                }
                                if (this.inverted) {
                                    nArray2[n4 - 1] = nArray2[0];
                                } else {
                                    nArray[n4 - 1] = nArray[0];
                                }
                                Polygon polygon = new Polygon(nArray, nArray2, n4);
                                jCFillStyle.fillOutlinePartialPolygon(graphics, polygon, this.outlineStyle);
                            }
                        }
                        ++n5;
                    }
                }
                if (!this.cachePlotData) {
                    this.polyList[n3] = null;
                }
            }
            n3 += bl ? 1 : -1;
        }
    }

    private boolean clipAreaPolygon(double d, double d2, double d3, double d4, int n, AreaPolygon areaPolygon, boolean bl, boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        if (!bl) {
            if (d == this.holeValue || d2 == Double.MAX_VALUE) {
                n3 = 1;
                n2 = 1;
            } else {
                n2 = JCChartUtil.locateX(d, this.xaxis.min.value, this.xaxis.max.value);
            }
        }
        if (n3 == 0) {
            if (d3 == this.holeValue || d4 == Double.MAX_VALUE) {
                n3 = 1;
                n2 = 1;
            } else {
                n3 = JCChartUtil.locateX(d3, this.xaxis.min.value, this.xaxis.max.value);
                if (bl && n3 != 0) {
                    n2 = JCChartUtil.locateX(d, this.xaxis.min.value, this.xaxis.max.value);
                }
            }
        }
        if (n2 != 0 && n3 != 0 && n2 == n3) {
            return false;
        }
        if (bl) {
            if (bl2) {
                areaPolygon.poly.addPoint(this.yaxis.toPixel(d4, this.drawFront), this.xaxis.toPixel(d3, this.drawFront));
            } else {
                areaPolygon.poly.addPoint(this.xaxis.toPixel(d3, this.drawFront), this.yaxis.toPixel(d4, this.drawFront));
            }
            areaPolygon.endPoint = n;
        } else {
            if (bl2) {
                areaPolygon.poly.addPoint(this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront), this.xaxis.toPixel(d, this.drawFront));
                areaPolygon.poly.addPoint(this.yaxis.toPixel(d2, this.drawFront), this.xaxis.toPixel(d, this.drawFront));
                areaPolygon.poly.addPoint(this.yaxis.toPixel(d4, this.drawFront), this.xaxis.toPixel(d3, this.drawFront));
            } else {
                areaPolygon.poly.addPoint(this.xaxis.toPixel(d, this.drawFront), this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront));
                areaPolygon.poly.addPoint(this.xaxis.toPixel(d, this.drawFront), this.yaxis.toPixel(d2, this.drawFront));
                areaPolygon.poly.addPoint(this.xaxis.toPixel(d3, this.drawFront), this.yaxis.toPixel(d4, this.drawFront));
            }
            areaPolygon.startPoint = n - 1;
            areaPolygon.endPoint = n;
        }
        return true;
    }

    private void finishAreaPolygon(Polygon polygon, boolean bl) {
        if (bl) {
            polygon.addPoint(this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront), polygon.ypoints[polygon.npoints - 1]);
        } else {
            polygon.addPoint(polygon.xpoints[polygon.npoints - 1], this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront));
        }
        polygon.addPoint(polygon.xpoints[0], polygon.ypoints[0]);
    }

    private void finishAreaPolygon(AreaPolygon areaPolygon, int[] nArray, int[] nArray2, boolean bl) {
        int n;
        int n2;
        Polygon polygon = areaPolygon.poly;
        int n3 = polygon.npoints;
        int n4 = areaPolygon.endPoint;
        while (n4 >= areaPolygon.startPoint) {
            n2 = n3 - 1 - (areaPolygon.endPoint - n4);
            n = nArray == null ? this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront) : nArray[n4];
            if (bl) {
                polygon.addPoint(n, polygon.ypoints[n2]);
            } else {
                polygon.addPoint(polygon.xpoints[n2], n);
            }
            --n4;
        }
        if (bl) {
            polygon.xpoints[0] = polygon.xpoints[polygon.npoints - 1];
        } else {
            polygon.ypoints[0] = polygon.ypoints[polygon.npoints - 1];
        }
        n2 = areaPolygon.startPoint;
        while (n2 <= areaPolygon.endPoint) {
            n = n2 - areaPolygon.startPoint + 1;
            nArray2[n2] = bl ? areaPolygon.poly.xpoints[n] : areaPolygon.poly.ypoints[n];
            ++n2;
        }
    }

    private int findLastPoly(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) == null) {
                return n - 1;
            }
            ++n;
        }
        return vector.size() - 1;
    }

    protected int calcFillOrientation(Rectangle rectangle, double d, boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            int n = this.yaxis.toPixel(d, this.drawFront);
            if (rectangle.y < n) {
                rectangle.height = Math.abs(n - rectangle.y);
                if (!bl2) {
                    return 6;
                }
                return 8;
            }
            if (!bl2) {
                return 7;
            }
            return 9;
        }
        int n = this.yaxis.toPixel(d, this.drawFront);
        if (rectangle.x < n) {
            rectangle.width = Math.abs(n - rectangle.x);
            if (!bl2) {
                return 8;
            }
            return 9;
        }
        if (!bl2) {
            return 6;
        }
        return 7;
    }

    public JCDataIndex pick(Point point, int n) {
        return this.pick(point, n, false);
    }

    public JCDataIndex pick(Point point, int n, boolean bl) {
        Object object;
        double d;
        Object object2;
        double d2;
        Object object3;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n2 = -1;
        int n3 = -1;
        JCDataIndex jCDataIndex = null;
        int n4 = this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront);
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        long l = 0L;
        int n8 = 0;
        int n9 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n10 = 0;
        int n11 = 0;
        long l2 = rectangle.width + rectangle.height;
        int n12 = bl ? 0 : this.seriesList.size() - 1;
        while ((bl ? n12 < this.seriesList.size() : n12 >= 0) && l2 > 0L) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n12);
            if (chartDataViewSeries != null && chartDataViewSeries.isVisible() && this.firstLast != null && (double)this.firstLast.x != this.holeValue && (double)this.firstLast.y != this.holeValue) {
                object3 = this.getYVals(chartDataViewSeries);
                n7 = n12;
                d2 = chartDataViewSeries.getX(this.firstLast.x);
                object2 = object3[this.firstLast.x];
                bl2 = d2 == this.holeValue || object2 == Double.MAX_VALUE;
                n10 = bl2 ? 1 : JCChartUtil.locateXY(d2, object2, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max);
                boolean bl4 = false;
                int n13 = this.firstLast.x + 1;
                while (n13 <= this.firstLast.y && l2 > 0L) {
                    boolean bl5;
                    d = chartDataViewSeries.getX(n13);
                    object = object3[n13];
                    bl3 = d == this.holeValue || object == Double.MAX_VALUE;
                    n11 = bl3 ? 2 : JCChartUtil.locateXY(d, object, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max);
                    boolean bl6 = bl5 = bl2 || bl3;
                    if (!(n10 != 0 && n11 != 0 || bl5)) {
                        long l3;
                        double d7;
                        long l4;
                        if (this.inverted) {
                            if (!bl4) {
                                d4 = this.xaxis.toPixel(d2, this.drawFront);
                                d3 = this.yaxis.toPixel((double)object2, this.drawFront);
                            }
                            d6 = this.xaxis.toPixel(d, this.drawFront);
                            d5 = this.yaxis.toPixel((double)object, this.drawFront);
                            l = d5 < (double)n4 && d3 > (double)n4 || d3 < (double)n4 && d5 > (double)n4 ? ((l4 = JCChartUtil.distTrap(point2.y, point2.x, n4, d4, d7 = d4 + ((double)n4 - d3) * (d6 - d4) / (d5 - d3), d3, n4)) < (l3 = JCChartUtil.distTrap(point2.y, point2.x, n4, d7, d6, n4, d5)) ? l4 : l3) : JCChartUtil.distTrap(point2.y, point2.x, n4, d4, d6, d3, d5);
                        } else {
                            if (!bl4) {
                                d3 = this.xaxis.toPixel(d2, this.drawFront);
                                d4 = this.yaxis.toPixel((double)object2, this.drawFront);
                            }
                            d5 = this.xaxis.toPixel(d, this.drawFront);
                            d6 = this.yaxis.toPixel((double)object, this.drawFront);
                            l = d6 < (double)n4 && d4 > (double)n4 || d4 < (double)n4 && d6 > (double)n4 ? ((l4 = JCChartUtil.distTrap(point2.x, point2.y, n4, d3, d7 = d3 + ((double)n4 - d4) * (d5 - d3) / (d6 - d4), d4, n4)) < (l3 = JCChartUtil.distTrap(point2.x, point2.y, n4, d7, d5, n4, d6)) ? l4 : l3) : JCChartUtil.distTrap(point2.x, point2.y, n4, d3, d5, d4, d6);
                        }
                        if (l < l2) {
                            n5 = n13 - 1;
                            n6 = n12;
                            l2 = l;
                        }
                        bl4 = true;
                        d3 = d5;
                        d4 = d6;
                    } else {
                        bl4 = false;
                    }
                    d2 = d;
                    object2 = object;
                    bl2 = bl3;
                    n10 = n11;
                    ++n13;
                }
            }
            n12 += bl ? 1 : -1;
        }
        if (n6 == -1) {
            return null;
        }
        int n14 = n6;
        n8 = n5;
        if (n8 < this.firstLast.x) {
            n8 = this.firstLast.x;
            n9 = this.firstLast.x + 1;
        } else if (n8 > this.firstLast.y) {
            n8 = this.firstLast.y - 1;
            n9 = this.firstLast.y;
        } else {
            n9 = n8 + 1;
            if (n9 > this.firstLast.y) {
                n9 = --n8 + 1;
            }
        }
        if (n8 < this.firstLast.x) {
            n8 = n9 = this.firstLast.x;
        }
        object3 = (ChartDataViewSeries)this.seriesList.get(n14);
        double[] dArray = this.getYVals((ChartDataViewSeries)object3);
        d2 = ((ChartDataViewSeries)object3).getX(n8);
        object2 = dArray[n8];
        d = ((ChartDataViewSeries)object3).getX(n9);
        object = dArray[n9];
        n10 = d2 == this.holeValue || object2 == Double.MAX_VALUE ? 1 : JCChartUtil.locateXY(d2, object2, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max);
        int n15 = n11 = d == this.holeValue || object == Double.MAX_VALUE ? 1 : JCChartUtil.locateXY(d, object, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max);
        if (this.inverted) {
            if (n10 == 0) {
                d4 = this.xaxis.toPixel(d2, this.drawFront);
                d3 = this.yaxis.toPixel((double)object2, this.drawFront);
            }
            if (n11 == 0) {
                d6 = this.xaxis.toPixel(d, this.drawFront);
                d5 = this.yaxis.toPixel((double)object, this.drawFront);
            }
        } else {
            if (n10 == 0) {
                d3 = this.xaxis.toPixel(d2, this.drawFront);
                d4 = this.yaxis.toPixel((double)object2, this.drawFront);
            }
            if (n11 == 0) {
                d5 = this.xaxis.toPixel(d, this.drawFront);
                d6 = this.yaxis.toPixel((double)object, this.drawFront);
            }
        }
        if (n10 == 0 || n11 == 0) {
            if (n10 == 0 && n11 == 0) {
                switch (n) {
                    case 1: {
                        n3 = Math.abs((double)point2.x - d3) < Math.abs((double)point2.x - d5) ? n8 : n9;
                        break;
                    }
                    case 2: {
                        n3 = Math.abs((double)point2.y - d4) < Math.abs((double)point2.y - d6) ? n8 : n9;
                        break;
                    }
                    default: {
                        long l5 = (long)(((double)point2.x - d3) * ((double)point2.x - d3) + ((double)point2.y - d4) * ((double)point2.y - d4));
                        long l6 = (long)(((double)point2.x - d5) * ((double)point2.x - d5) + ((double)point2.y - d6) * ((double)point2.y - d6));
                        n3 = l5 < l6 ? n8 : n9;
                        break;
                    }
                }
            } else {
                n3 = n10 != 0 ? n9 : n8;
            }
            if ((n2 = n6) >= 0 && n3 >= 0) {
                jCDataIndex = new JCDataIndex(n3, (ChartDataViewSeries)this.seriesList.get(n2), n2);
                jCDataIndex.distance = (int)l2;
            }
        }
        return jCDataIndex;
    }

    public Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
        double[] dArray = this.getYVals(chartDataViewSeries);
        double d = dArray[n];
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d2 != this.holeValue && d != Double.MAX_VALUE) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d;
        double d2;
        double d3;
        double d4;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n = jCDataIndex.series.getDrawingOrder();
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.series;
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        this.r = this.chartArea.getDrawingArea();
        this.last = null;
        this.next = null;
        this.prev = null;
        double[] dArray = this.getYVals(chartDataViewSeries);
        if (jCDataIndex.point - 1 >= 0 && jCDataIndex.point - 1 >= chartDataViewSeries.getFirstPoint() && jCDataIndex.point - 1 <= chartDataViewSeries.getLastPoint()) {
            d4 = chartDataViewSeries.getX(jCDataIndex.point - 1);
            d3 = dArray[jCDataIndex.point - 1];
            if (d4 == jCDataIndex.dataView.getHoleValue() || d3 == jCDataIndex.dataView.getHoleValue()) {
                d3 = jCDataIndex.dataView.getYAxis().origin.value;
                d4 = chartDataViewSeries.getX(jCDataIndex.point);
            }
        } else {
            d4 = chartDataViewSeries.getX(jCDataIndex.point);
            d3 = jCDataIndex.dataView.getYAxis().origin.value;
        }
        this.prev = bl ? new Point(jCDataIndex.dataView.getYAxis().toPixel(d3, this.drawFront) + this.r.x, jCDataIndex.dataView.getXAxis().toPixel(d4, this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(d4, this.drawFront) + this.r.x, jCDataIndex.dataView.getYAxis().toPixel(d3, this.drawFront) + this.r.y);
        if (jCDataIndex.point + 1 < chartDataViewSeries.maxXIndex() && jCDataIndex.point + 1 >= chartDataViewSeries.getFirstPoint() && jCDataIndex.point + 1 <= chartDataViewSeries.getLastPoint()) {
            d2 = chartDataViewSeries.getX(jCDataIndex.point + 1);
            d = dArray[jCDataIndex.point + 1];
            if (d2 == jCDataIndex.dataView.getHoleValue() || d == jCDataIndex.dataView.getHoleValue()) {
                d = jCDataIndex.dataView.getYAxis().origin.value;
                d2 = chartDataViewSeries.getX(jCDataIndex.point);
            }
        } else {
            d2 = chartDataViewSeries.getX(jCDataIndex.point);
            d = jCDataIndex.dataView.getYAxis().origin.value;
        }
        this.next = bl ? new Point(jCDataIndex.dataView.getYAxis().toPixel(d, this.drawFront) + this.r.x, jCDataIndex.dataView.getXAxis().toPixel(d2, this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(d2, this.drawFront) + this.r.x, jCDataIndex.dataView.getYAxis().toPixel(d, this.drawFront) + this.r.y);
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (this.last == null) {
            this.last = jCDataIndex.dataView.getXAxis().vertical ? new Point(n, jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n2);
        } else if (jCDataIndex.dataView.getXAxis().vertical) {
            this.last.x = n;
        } else {
            this.last.y = n2;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        return jCDataIndex.dataView.getXAxis().vertical ? n - this.r.x : n2 - this.r.y;
    }

    protected void defineAreaShapes(DefineShape defineShape, Graphics graphics, JCFillStyle jCFillStyle, boolean bl, AreaPolygon areaPolygon, ChartDataViewSeries chartDataViewSeries) {
        int n = areaPolygon.startPoint;
        while (n < areaPolygon.endPoint) {
            Polygon polygon;
            int n2;
            int n3;
            double d;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            if (!bl) {
                n8 = areaPolygon.poly.ypoints[0];
                n7 = areaPolygon.poly.xpoints[n - areaPolygon.startPoint + 1];
                n6 = areaPolygon.poly.ypoints[n - areaPolygon.startPoint + 1];
                n5 = areaPolygon.poly.xpoints[n - areaPolygon.startPoint + 2];
                n4 = areaPolygon.poly.ypoints[n - areaPolygon.startPoint + 2];
                d = (double)(n4 - n6) / (double)(n5 - n7);
                n3 = n7 + (int)((double)(n5 - n7) / 2.0);
                n2 = n6 - (int)(d * (double)(n7 - n3));
                polygon = new Polygon();
                polygon.addPoint(n7, n8);
                polygon.addPoint(n7, n6);
                polygon.addPoint(n3, n2);
                polygon.addPoint(n3, n8);
                defineShape.beginShape(new JCDataIndex(n, chartDataViewSeries));
                jCFillStyle.fillPolygon(graphics, polygon);
                defineShape.endShape(false);
                polygon = new Polygon();
                polygon.addPoint(n3, n8);
                polygon.addPoint(n3, n2);
                polygon.addPoint(n5, n4);
                polygon.addPoint(n5, n8);
                defineShape.beginShape(new JCDataIndex(n + 1, chartDataViewSeries));
                jCFillStyle.fillPolygon(graphics, polygon);
                defineShape.endShape(false);
            } else {
                n8 = areaPolygon.poly.xpoints[0];
                n7 = areaPolygon.poly.xpoints[n - areaPolygon.startPoint + 1];
                n6 = areaPolygon.poly.ypoints[n - areaPolygon.startPoint + 1];
                n5 = areaPolygon.poly.xpoints[n - areaPolygon.startPoint + 2];
                n4 = areaPolygon.poly.ypoints[n - areaPolygon.startPoint + 2];
                d = (double)(n5 - n7) / (double)(n4 - n6);
                n3 = n6 + (int)((double)(n4 - n6) / 2.0);
                n2 = n7 - (int)(d * (double)(n6 - n3));
                polygon = new Polygon();
                polygon.addPoint(n8, n6);
                polygon.addPoint(n7, n6);
                polygon.addPoint(n2, n3);
                polygon.addPoint(n8, n3);
                defineShape.beginShape(new JCDataIndex(n, chartDataViewSeries));
                jCFillStyle.fillPolygon(graphics, polygon);
                defineShape.endShape(false);
                polygon = new Polygon();
                polygon.addPoint(n8, n3);
                polygon.addPoint(n2, n3);
                polygon.addPoint(n5, n4);
                polygon.addPoint(n8, n4);
                defineShape.beginShape(new JCDataIndex(n + 1, chartDataViewSeries));
                jCFillStyle.fillPolygon(graphics, polygon);
                defineShape.endShape(false);
            }
            ++n;
        }
    }
}

