/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AnnoBoundsInfo;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.ErrorDialog;
import com.klg.jclass.chart.Extents;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartDateFormat;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCValueLabel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

class AnnotationHandler
implements Serializable {
    Vector valueLabels = new Vector();
    Vector userValueLabels = new Vector();
    Extents extents = new Extents();
    int realPlacement = 1;
    int anchor = 16;
    int thetaAxisLabelOffset = 4;
    JCAxis parent = null;
    private transient JCChartDateFormat dateFormatter = null;

    AnnotationHandler(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    public JCChartDateFormat getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new JCChartDateFormat();
        }
        return this.dateFormatter;
    }

    protected AnnoBoundsInfo getPolarAnnotationBounds() {
        AnnoBoundsInfo annoBoundsInfo = null;
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        JCValueLabel jCValueLabel = null;
        JCValueLabel jCValueLabel2 = null;
        JCValueLabel jCValueLabel3 = null;
        JCValueLabel jCValueLabel4 = null;
        int n5 = this.firstVisibleLabel();
        int n6 = this.lastVisibleLabel();
        if (n5 >= 0 && n5 < this.valueLabels.size() && n6 >= 0 && n6 < this.valueLabels.size()) {
            int n7 = n5;
            while (n7 <= n6) {
                JCValueLabel jCValueLabel5 = (JCValueLabel)this.valueLabels.elementAt(n7);
                jCValueLabel5.label.recalc();
                if (n > jCValueLabel5.label.left.value) {
                    n = jCValueLabel5.label.left.value;
                    jCValueLabel = jCValueLabel5;
                }
                if (n2 > jCValueLabel5.label.top.value) {
                    n2 = jCValueLabel5.label.top.value;
                    jCValueLabel3 = jCValueLabel5;
                }
                if (n3 < jCValueLabel5.label.left.value + jCValueLabel5.label.width.value) {
                    n3 = jCValueLabel5.label.left.value + jCValueLabel5.label.width.value;
                    jCValueLabel2 = jCValueLabel5;
                }
                if (n4 < jCValueLabel5.label.top.value + jCValueLabel5.label.height.value) {
                    n4 = jCValueLabel5.label.top.value + jCValueLabel5.label.height.value;
                    jCValueLabel4 = jCValueLabel5;
                }
                ++n7;
            }
            annoBoundsInfo = new AnnoBoundsInfo();
            annoBoundsInfo.x = n;
            annoBoundsInfo.y = n2;
            annoBoundsInfo.width = n3 - n;
            annoBoundsInfo.height = n4 - n2;
            annoBoundsInfo.valueLabelMinBoundsX = jCValueLabel;
            annoBoundsInfo.valueLabelMaxBoundsX = jCValueLabel2;
            annoBoundsInfo.valueLabelMinBoundsY = jCValueLabel3;
            annoBoundsInfo.valueLabelMaxBoundsY = jCValueLabel4;
        }
        return annoBoundsInfo;
    }

    void calcAnnotationExtents() {
        this.extents.ortho = 0;
        this.extents.minor = 0;
        this.extents.major = 0;
        if (!this.parent.visible) {
            return;
        }
        int n = this.firstVisibleLabel();
        int n2 = this.lastVisibleLabel();
        if (n >= 0 && n < this.valueLabels.size() && n2 >= 0 && n2 < this.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n);
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.valueLabels.elementAt(n2);
            jCValueLabel.label.recalc();
            jCValueLabel2.label.recalc();
            if (this.parent.vertical) {
                this.extents.minor = jCValueLabel2.label.getHeight() / 2 + 1;
                this.extents.major = jCValueLabel.label.getHeight() / 2 + 1;
            } else {
                this.extents.minor = jCValueLabel.label.getWidth() / 2 + 1;
                this.extents.major = jCValueLabel2.label.getWidth() / 2 + 1;
            }
            int n3 = n;
            while (n3 <= n2) {
                int n4;
                JCValueLabel jCValueLabel3 = (JCValueLabel)this.valueLabels.elementAt(n3);
                jCValueLabel3.label.recalc();
                int n5 = n4 = this.parent.vertical ? jCValueLabel3.label.getWidth() : jCValueLabel3.label.getHeight();
                if ((n4 += this.parent.tickLength / 2 + 1) > this.extents.ortho) {
                    this.extents.ortho = n4;
                }
                ++n3;
            }
        }
        if (this.parent.reversed) {
            int n6 = this.extents.minor;
            this.extents.minor = this.extents.major;
            this.extents.major = n6;
        }
        if (this.parent.title.visible) {
            if (this.parent.vertical) {
                switch (this.parent.title.placement.value) {
                    case 17: 
                    case 18: {
                        this.extents.minor += this.parent.title.getHeight() + 1;
                        this.extents.ortho = Math.max(this.parent.title.getWidth() + 1, this.extents.ortho);
                        break;
                    }
                    case 33: 
                    case 34: {
                        this.extents.major += this.parent.title.getHeight() + 1;
                        this.extents.ortho = Math.max(this.parent.title.getWidth() + 1, this.extents.ortho);
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.extents.ortho += this.parent.title.getWidth() + 1;
                    }
                }
            } else {
                switch (this.parent.title.placement.value) {
                    case 16: 
                    case 32: {
                        this.extents.ortho += this.parent.title.getHeight() + 1;
                    }
                }
            }
        }
    }

    void calcAnchor() {
        this.realPlacement = this.parent.placement.value;
        if (this.realPlacement == 0) {
            this.realPlacement = 1;
        }
        boolean bl = false;
        if (this.parent.otherAxis != null) {
            boolean bl2 = bl = this.parent.otherAxis.origin.value - this.parent.otherAxis.min.value > this.parent.otherAxis.max.value - this.parent.otherAxis.origin.value;
        }
        if (this.parent.vertical) {
            this.anchor = this.realPlacement == 2 || this.realPlacement == 5 && bl ? 1 : 2;
            if (this.parent.otherAxis != null && this.parent.otherAxis.reversed) {
                switch (this.anchor) {
                    case 1: {
                        this.anchor = 2;
                        break;
                    }
                    case 2: {
                        this.anchor = 1;
                    }
                }
            }
        } else {
            this.anchor = this.realPlacement == 2 || this.realPlacement == 5 && bl ? 16 : 32;
            if (this.parent.otherAxis != null && this.parent.otherAxis.reversed) {
                switch (this.anchor) {
                    case 16: {
                        this.anchor = 32;
                        break;
                    }
                    case 32: {
                        this.anchor = 16;
                    }
                }
            }
        }
    }

    void checkAnnotations() {
        if (this.valueLabels == null) {
            return;
        }
        if (this.valueLabels.size() < 1) {
            return;
        }
        if (this.parent.annotationMethod == 0) {
            this.checkValueAnnotations();
        } else if (this.parent.annotationMethod == 2) {
            this.checkTimeAnnotations();
        } else {
            this.checkUserProvidedAnnotations();
        }
    }

    void layout() {
        int n = this.valueLabels.size();
        int n2 = 0;
        while (n2 < n) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n2);
            if (!this.parent.isLogarithmic() || !(jCValueLabel.value <= 0.0) || (this.parent.isPolar() || this.parent.isRadar()) && !this.parent.vertical) {
                if (this.parent.isPolar() || this.parent.isRadar() && this.parent.vertical) {
                    this.layoutPolar(jCValueLabel.label, jCValueLabel.value);
                } else if (this.parent.isRadar() && !this.parent.vertical) {
                    double d = JCChartUtil.getRadarAngle(this.parent.chartArea.getAngleUnit(), n, n2, false);
                    this.layoutPolar(jCValueLabel.label, d);
                } else {
                    int n3 = this.parent.toPixel(jCValueLabel.value);
                    this.layout(jCValueLabel.label, n3);
                }
            }
            ++n2;
        }
    }

    Date dataToTime(double d, long l) {
        Date date = this.parent.timeBase;
        if (l < 86400000L) {
            return new Date(date.getTime() + (long)(d * (double)l));
        }
        Date date2 = new Date(date.getTime());
        boolean bl = l >= 604800000L && l < 2678400000L;
        long l2 = (long)d;
        double d2 = d - (double)l2;
        long l3 = bl ? l2 * 7L : l2;
        this.getDateFormatter().addToUnit(date2, l, (int)l3);
        try {
            if (d < 0.0 && date2.after(date)) {
                return null;
            }
            if (d > 0.0 && date2.before(date)) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (10.0 + d2 != 10.0) {
            Date date3 = new Date(date.getTime());
            if (d < 0.0) {
                --l2;
                d2 = -d2;
            } else {
                ++l2;
            }
            l3 = bl ? l2 * 7L : l2;
            this.getDateFormatter().addToUnit(date3, l, (int)l3);
            Date date4 = date2;
            date2 = new Date(date4.getTime() + (long)(d2 * (double)(date3.getTime() - date4.getTime())));
        }
        return date2;
    }

    double timeToData(Date date, long l) {
        double d;
        double d2 = l;
        if (date == null) {
            return 0.0;
        }
        long l2 = this.parent.timeBase.getTime();
        Date date2 = JCChartDateFormat.getMinTime();
        Date date3 = JCChartDateFormat.getMaxTime();
        if (date.before(date2)) {
            return (double)(date2.getTime() - l2) / d2;
        }
        if (date.after(date3)) {
            return (double)(date3.getTime() - l2) / d2;
        }
        double d3 = d = (double)(date.getTime() - l2) / d2;
        if (l < 86400000L) {
            return d;
        }
        double d4 = d - 2.0;
        double d5 = d + 2.0;
        Date date4 = this.dataToTime(d4, l);
        Date date5 = this.dataToTime(d5, l);
        if (date4 == null || date4.after(date)) {
            d4 = (double)(date2.getTime() - l2) / d2;
            date4 = this.dataToTime(d4, l);
        }
        if (date5 == null || date5.before(date)) {
            d5 = (double)(date3.getTime() - l2) / d2;
            date5 = this.dataToTime(d5, l);
        }
        while (d5 - d4 > 1.0E-6) {
            d = (d4 + d5) / 2.0;
            Date date6 = this.dataToTime(d, l);
            if (date6 == null) {
                return d3;
            }
            if (date6.before(date) || date4 == null) {
                d4 = d;
                date4 = date6;
                continue;
            }
            if (date6.after(date) || date5 == null) {
                d5 = d;
                date5 = date6;
                continue;
            }
            return d;
        }
        return d;
    }

    protected double getCircumference(int n) {
        double d;
        switch (n) {
            case 2: {
                d = Math.PI * 2;
                break;
            }
            case 3: {
                d = 400.0;
                break;
            }
            default: {
                d = 360.0;
            }
        }
        return d;
    }

    private void checkValueAnnotations() {
        if (this.parent.isPolar() && !this.parent.vertical) {
            int n = this.parent.chartArea.getAngleUnit();
            double d = this.parent.polarAxisParams.radius;
            double d2 = ((JCValueLabel)this.valueLabels.elementAt((int)0)).label.height.value;
            double d3 = Math.acos(1.0 - 0.25 * d2 / d);
            d3 = JCChartUtil.convertAngle(2, n, d3);
            int n2 = this.valueLabels.size();
            double d4 = this.getCircumference(this.parent.chartArea.getAngleUnit());
            double d5 = d4 / (double)n2;
            if (d5 < d3) {
                n2 = (int)(d4 / d3);
                switch (n) {
                    case 3: {
                        if (n2 > 80) {
                            n2 = 80;
                            break;
                        }
                        if (n2 > 40) {
                            n2 = 40;
                            break;
                        }
                        if (n2 > 20) {
                            n2 = 20;
                            break;
                        }
                        if (n2 > 10) {
                            n2 = 10;
                            break;
                        }
                        if (n2 > 8) {
                            n2 = 8;
                            break;
                        }
                        n2 = 4;
                        break;
                    }
                    case 2: {
                        if (n2 > 64) {
                            n2 = 64;
                            break;
                        }
                        if (n2 > 32) {
                            n2 = 32;
                            break;
                        }
                        if (n2 > 16) {
                            n2 = 16;
                            break;
                        }
                        if (n2 > 8) {
                            n2 = 8;
                            break;
                        }
                        n2 = 4;
                        break;
                    }
                    default: {
                        n2 = n2 > 72 ? 72 : (n2 > 36 ? 36 : (n2 > 24 ? 24 : (n2 > 12 ? 12 : (n2 > 8 ? 8 : 4))));
                    }
                }
                d3 = d4 / (double)n2;
                this.valueLabels = new Vector();
                int n3 = this.parent.getPrecision();
                int n4 = 0;
                while (n4 < n2) {
                    double d6 = d3 * (double)n4;
                    if (this.parent.polarAxisParams.isPolarHalfRange() && d6 > d4 / 2.0) {
                        d6 += -d4;
                    }
                    JCValueLabel jCValueLabel = new JCValueLabel(this.parent, d6, n3);
                    this.valueLabels.addElement(jCValueLabel);
                    ++n4;
                }
                this.layout();
            }
        } else if (!this.parent.isRadar()) {
            int n = this.parent.toPixel(this.parent.min.value);
            int n5 = this.parent.toPixel(this.parent.max.value);
            int n6 = JCChartUtil.abs(n5 - n);
            int n7 = this.valueLabels.size();
            if (n7 > n6) {
                n7 = n6;
                this.valueLabels = new Vector();
                int n8 = this.parent.getPrecision();
                int n9 = 0;
                while (n9 < n7) {
                    double d = this.parent.toData(n + n9);
                    d = JCChartUtil.precCorrect(n8, d);
                    JCValueLabel jCValueLabel = new JCValueLabel(this.parent, d, n8);
                    this.valueLabels.addElement(jCValueLabel);
                    ++n9;
                }
                this.layout();
            }
        }
    }

    private void checkTimeAnnotations() {
        double d = this.parent.max.value - this.parent.min.value;
        int n = this.valueLabels.size();
        int n2 = this.firstVisibleLabel();
        int n3 = this.lastVisibleLabel();
        Dimension dimension = new Dimension(0, 0);
        this.timeLabelExtents(dimension);
        int n4 = this.parent.vertical ? this.parent.getHeight() : this.parent.getWidth();
        int n5 = 0;
        if (n >= 2) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(0);
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.valueLabels.elementAt(1);
            n5 = (int)JCChartUtil.precCorrect(0, (double)n4 * (Math.abs(jCValueLabel2.value - jCValueLabel.value) / d));
            n5 = Math.max(n5, 1);
        } else {
            n5 = 1;
        }
        int n6 = this.parent.vertical ? dimension.height : dimension.width;
        int n7 = (n6 + this.parent.gap * 2) / n5;
        boolean bl = n7 >= 1;
        ++n7;
        if (n2 >= 0) {
            int n8 = n2;
            while (n8 <= n3) {
                JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n8);
                ChartText chartText = jCValueLabel.getChartText();
                chartText.visible = this.checkLocation(jCValueLabel);
                if (chartText.visible && bl) {
                    jCValueLabel.getChartText().visible = (n8 - n2) % n7 == 0;
                }
                ++n8;
            }
        }
    }

    private boolean checkLocation(JCValueLabel jCValueLabel) {
        if (jCValueLabel == null) {
            return false;
        }
        ChartText chartText = jCValueLabel.getChartText();
        if (this.parent.vertical) {
            int n = chartText.getTop() + chartText.getHeight() / 2;
            return n >= this.parent.getTop() && n <= this.parent.getTop() + this.parent.getHeight();
        }
        int n = chartText.getLeft() + chartText.getWidth() / 2;
        return n >= this.parent.getLeft() && n <= this.parent.getLeft() + this.parent.getWidth();
    }

    private boolean isPolarRadarThetaAxis() {
        return (this.parent.isPolar() || this.parent.isRadar()) && !this.parent.vertical;
    }

    private void checkUserProvidedAnnotations() {
        ChartText chartText;
        JCValueLabel jCValueLabel;
        if (this.valueLabels == null) {
            return;
        }
        if (this.valueLabels.size() < 1) {
            return;
        }
        int n = 0;
        Rectangle rectangle = null;
        while (n < this.valueLabels.size()) {
            jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n);
            chartText = jCValueLabel.getChartText();
            if (this.isPolarRadarThetaAxis() || !(jCValueLabel.value < this.parent.min.value)) {
                chartText.visible = true;
                rectangle = new Rectangle(chartText.getLeft(), chartText.getTop(), chartText.getWidth() + this.parent.gap, chartText.getHeight() + this.parent.gap);
                break;
            }
            chartText.visible = false;
            ++n;
        }
        if (rectangle == null || n >= this.valueLabels.size()) {
            return;
        }
        ++n;
        while (n < this.valueLabels.size()) {
            jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n);
            chartText = jCValueLabel.getChartText();
            if (!this.isPolarRadarThetaAxis() && jCValueLabel.value > this.parent.max.value) {
                chartText.visible = false;
            } else {
                Rectangle rectangle2 = new Rectangle(chartText.getLeft(), chartText.getTop(), chartText.getWidth() + this.parent.gap, chartText.getHeight() + this.parent.gap);
                if (this.isPolarRadarThetaAxis()) {
                    chartText.visible = true;
                    rectangle = rectangle2;
                } else if (rectangle2.intersects(rectangle)) {
                    chartText.visible = false;
                } else {
                    chartText.visible = true;
                    rectangle = rectangle2;
                }
            }
            ++n;
        }
    }

    private void layout(ChartText chartText, int n) {
        chartText.recalc();
        if (this.parent.vertical) {
            switch (this.anchor) {
                case 2: {
                    chartText.setLocation(this.parent.getLeft() + this.parent.getWidth() - chartText.getWidth() - this.parent.tickLength / 2 - 1, n - chartText.getHeight() / 2);
                    break;
                }
                case 1: {
                    chartText.setLocation(this.parent.getLeft() + this.parent.tickLength / 2 + 1, n - chartText.getHeight() / 2);
                }
            }
        } else {
            switch (this.anchor) {
                case 16: {
                    chartText.setLocation(n - chartText.getWidth() / 2, this.parent.getTop() + this.parent.getHeight() - chartText.getHeight() - this.parent.tickLength / 2 - 1);
                    break;
                }
                default: {
                    chartText.setLocation(n - chartText.getWidth() / 2, this.parent.getTop() + this.parent.tickLength / 2 + 1);
                }
            }
        }
    }

    private void layoutPolar(ChartText chartText, double d) {
        chartText.recalc();
        if (this.parent.vertical) {
            this.layoutPolarRAxis(chartText, d);
        } else {
            this.layoutPolarThetaAxis(chartText, d);
        }
    }

    private void layoutPolarRAxis(ChartText chartText, double d) {
        double d2;
        Point point = null;
        JCAxis jCAxis = this.parent.vertical ? this.parent : this.parent.otherAxis;
        double d3 = Double.MAX_VALUE;
        if (this.parent.isLogarithmic()) {
            d2 = JCChartUtil.log10(d);
            d3 = jCAxis.isReversed() ? this.parent.applyDataToPixelScaling(JCChartUtil.log10(this.parent.max.value)) - this.parent.applyDataToPixelScaling(d2) : this.parent.applyDataToPixelScaling(d2) - this.parent.applyDataToPixelScaling(JCChartUtil.log10(this.parent.min.value));
        } else {
            d3 = jCAxis.isReversed() ? this.parent.applyDataToPixelScaling(this.parent.max.value) - this.parent.applyDataToPixelScaling(d) : this.parent.applyDataToPixelScaling(d) - this.parent.applyDataToPixelScaling(this.parent.min.value);
        }
        d2 = JCChartUtil.getAngleRatio(2, this.parent.polarAxisParams.rAxisAngle, this.parent.polarAxisParams.originBase, false);
        double d4 = this.parent.polarAxisParams.rAxisAngle;
        double d5 = this.parent.tickLength / 2;
        double d6 = Math.sqrt(d5 * d5 + d3 * d3);
        double d7 = 0.0;
        if (d6 != 0.0) {
            d7 = Math.asin(d5 / d6);
        }
        switch (this.anchor) {
            case 2: {
                if (d2 <= 0.0625) {
                    point = this.parent.toPixelPolar(d4 + d7, d6, false);
                    double d8 = chartText.getWidth() / 2;
                    point.x -= (int)Math.round(d8);
                    point.y -= chartText.getHeight();
                    break;
                }
                if (d2 > 0.0625 && d2 < 0.4375) {
                    point = this.parent.toPixelPolar(d4 + d7, d6, false);
                    double d9 = (double)chartText.getWidth() + d5 + 1.0;
                    point.x -= (int)Math.round(d9);
                    point.y -= chartText.getHeight() / 2;
                    break;
                }
                if (d2 >= 0.4375 && d2 <= 0.5625) {
                    point = this.parent.toPixelPolar(d4 + d7, d6, false);
                    double d10 = chartText.getWidth() / 2;
                    point.x -= (int)Math.round(d10);
                    break;
                }
                if (d2 > 0.5625 && d2 < 0.9375) {
                    point = this.parent.toPixelPolar(d4 + d7, d6, false);
                    double d11 = (double)chartText.getWidth() + d5 + 1.0;
                    point.x -= (int)Math.round(d11);
                    point.y -= chartText.getHeight() / 2;
                    break;
                }
                if (!(d2 >= 0.9375)) break;
                point = this.parent.toPixelPolar(d4 - d7, d6, false);
                double d12 = chartText.getWidth() / 2;
                point.x -= (int)Math.round(d12);
                break;
            }
            case 1: {
                if (d2 <= 0.0625) {
                    point = this.parent.toPixelPolar(d4 - d7, d6, false);
                    double d13 = chartText.getWidth() / 2;
                    point.x -= (int)Math.round(d13);
                    break;
                }
                if (d2 > 0.0625 && d2 < 0.4375) {
                    point = this.parent.toPixelPolar(d4 - d7, d6, false);
                    double d14 = d5 + 1.0;
                    point.x += (int)Math.round(d14);
                    point.y -= chartText.getHeight() / 2;
                    break;
                }
                if (d2 >= 0.4375 && d2 <= 0.5625) {
                    point = this.parent.toPixelPolar(d4 - d7, d6, false);
                    double d15 = chartText.getWidth() / 2;
                    point.x -= (int)Math.round(d15);
                    point.y -= chartText.getHeight();
                    break;
                }
                if (d2 > 0.5625 && d2 < 0.9375) {
                    point = this.parent.toPixelPolar(d4 + d7, d6, false);
                    double d16 = d5 + 1.0;
                    point.x += (int)Math.round(d16);
                    point.y -= chartText.getHeight() / 2;
                    break;
                }
                if (!(d2 >= 0.9375)) break;
                point = this.parent.toPixelPolar(d4 - d7, d6, false);
                double d17 = chartText.getWidth() / 2;
                point.x -= (int)Math.round(d17);
                break;
            }
            default: {
                point = this.parent.toPixelPolar(d4, d6, false);
                double d18 = (double)(chartText.getWidth() / 2) + d5 + 1.0;
                point.x -= (int)Math.round(d18);
                point.y -= chartText.getHeight() / 2;
            }
        }
        chartText.setLocation(point.x, point.y);
    }

    private void layoutPolarThetaAxis(ChartText chartText, double d) {
        this.thetaAxisLabelOffset = this.parent.tickLength / 2 + 2;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = chartText.getHeight();
        double d5 = JCChartUtil.convertAngle(this.parent.chartArea.getAngleUnit(), 2, d);
        Point point = this.parent.toPixelPolar(d5, (int)Math.round(this.parent.polarAxisParams.radius) + this.thetaAxisLabelOffset, false);
        JCAxis jCAxis = this.parent.vertical ? this.parent.otherAxis : this.parent;
        double d6 = JCChartUtil.getAngleRatio(2, d5, this.parent.polarAxisParams.originBase, jCAxis.isReversed());
        if (d6 <= 0.25 || d6 >= 0.75) {
            d2 = d6 <= 0.25 ? (double)((int)(2.0 * d4 * (-d6 - 0.25))) : (double)((int)(2.0 * d4 * (1.0 - d6) - d4 / 2.0));
            d3 = d6 < 0.25 || d6 > 0.75 ? 0.0 : (double)(-chartText.getWidth() / 2);
        } else {
            d2 = d6 <= 0.5 ? (double)((int)(2.0 * d4 * (-1.0 + d6) + d4 / 2.0)) : (double)((int)(2.0 * d4 * (d6 - 0.75)));
            d3 = -chartText.getWidth();
        }
        chartText.setLocation((int)((double)point.x + d3), (int)((double)point.y + d2));
    }

    void draw(Graphics graphics) {
        int n = this.firstVisibleLabel();
        int n2 = this.lastVisibleLabel();
        if (n < 0 || n > this.valueLabels.size() || n2 < 0 || n2 > this.valueLabels.size()) {
            return;
        }
        int n3 = n;
        while (n3 <= n2) {
            try {
                JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n3);
                jCValueLabel.label.draw(graphics);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
            ++n3;
        }
    }

    void makeAnnotations() {
        block13: {
            double d;
            double d2;
            double d3;
            int n;
            block17: {
                ChartDataView chartDataView;
                block16: {
                    block15: {
                        block14: {
                            block12: {
                                chartDataView = ((JCChart)this.parent.chartArea.getParent()).findData(this.parent);
                                if (this.parent.annotationMethod != 1) break block12;
                                this.sortValueLabels();
                                this.makeValueLabels(chartDataView);
                                break block13;
                            }
                            if (this.parent.annotationMethod != 2) break block14;
                            this.makeTimeLabels();
                            break block13;
                        }
                        if (this.parent.annotationMethod != 3) break block15;
                        if (this.parent.isRadar()) {
                            this.makePointLabelsRadar(chartDataView);
                        } else {
                            this.makePointLabels(chartDataView);
                        }
                        break block13;
                    }
                    if (this.parent.annotationMethod != 0) break block13;
                    this.valueLabels = new Vector();
                    n = this.parent.getPrecision();
                    if (!this.parent.logarithmic || (this.parent.isPolar() || this.parent.isRadar()) && !this.parent.vertical) break block16;
                    int n2 = JCChartUtil.intLog10(this.parent.min.value);
                    int n3 = JCChartUtil.intLog10(this.parent.max.value);
                    int n4 = n3 - n2 + 1;
                    boolean bl = false;
                    if (this.parent.logIncrement > 1) {
                        bl = n4 % this.parent.logIncrement != 0;
                        n4 /= this.parent.logIncrement;
                        if (bl) {
                            ++n4;
                        }
                    }
                    int n5 = n2;
                    int n6 = 0;
                    while (n5 <= n3) {
                        JCValueLabel jCValueLabel = new JCValueLabel(this.parent, n5, n);
                        this.valueLabels.addElement(jCValueLabel);
                        n5 += this.parent.logIncrement;
                        ++n6;
                    }
                    break block13;
                }
                d3 = this.parent.numSpacing.value;
                d2 = JCChartUtil.calcError(n);
                if ((!this.parent.isPolar() && !this.parent.isRadar() || this.parent.vertical) && (d3 = JCChartUtil.precCorrect(n, d3)) < d2) {
                    return;
                }
                d = this.getCircumference(this.parent.getChartArea().getAngleUnit());
                if (!this.parent.isRadar() || this.parent.vertical) break block17;
                this.makeValueAnnotationsRadar(chartDataView);
                break block13;
            }
            JCValueLabel jCValueLabel = null;
            if (d3 == 0.0) break block13;
            double d4 = this.parent.firstInc(d3);
            if (d4 + d3 == d4) {
                return;
            }
            int n7 = this.parent.pixelLength();
            int n8 = 0;
            while (n8 < n7 && d4 <= this.parent.max.value + d2) {
                if (!this.parent.isPolar() || this.parent.vertical || !(d4 >= d)) {
                    if (this.parent.isPolar() && !this.parent.vertical) {
                        double d5 = d4;
                        if (this.parent.polarAxisParams.isPolarHalfRange() && d5 > d / 2.0) {
                            d5 += -d;
                        }
                        jCValueLabel = new JCValueLabel(this.parent, d5, n);
                    } else {
                        jCValueLabel = new JCValueLabel(this.parent, d4, n);
                    }
                    this.valueLabels.addElement(jCValueLabel);
                }
                d4 += d3;
                ++n8;
            }
        }
    }

    int firstVisibleLabel() {
        int n = 0;
        while (n < this.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n);
            if (jCValueLabel.getChartText().visible) break;
            ++n;
        }
        return n;
    }

    int lastVisibleLabel() {
        int n = this.valueLabels.size() - 1;
        while (n >= 0) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n);
            if (jCValueLabel.getChartText().visible) break;
            --n;
        }
        return n;
    }

    void sortValueLabels() {
        Vector vector = this.userValueLabels;
        this.userValueLabels = new Vector();
        try {
            int n = 0;
            while (n < vector.size()) {
                JCValueLabel jCValueLabel = (JCValueLabel)vector.elementAt(n);
                int n2 = 0;
                while (n2 < this.userValueLabels.size()) {
                    JCValueLabel jCValueLabel2 = (JCValueLabel)this.userValueLabels.elementAt(n2);
                    if (jCValueLabel.value < jCValueLabel2.value) break;
                    ++n2;
                }
                this.userValueLabels.insertElementAt(jCValueLabel, n2);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private void makeValueLabels(ChartDataView chartDataView) {
        int n = 0;
        int n2 = this.userValueLabels.size() - 1;
        if (chartDataView != null && this.parent.isRadar() && !this.parent.vertical) {
            int[] nArray = ChartDataView.getFirstLastPoints(chartDataView);
            if (nArray != null) {
                n = nArray[0];
                n2 = nArray[1];
            } else {
                return;
            }
        }
        this.valueLabels = new Vector();
        try {
            int n3 = n;
            while (n3 <= n2) {
                JCValueLabel jCValueLabel = (JCValueLabel)this.userValueLabels.elementAt(n3);
                JCValueLabel jCValueLabel2 = new JCValueLabel(jCValueLabel.value, jCValueLabel.label.text, this.parent);
                jCValueLabel2.label.setRotation(this.parent.annotationRotation);
                jCValueLabel2.label.setBackground(jCValueLabel.label.background);
                jCValueLabel2.label.setForeground(jCValueLabel.label.foreground);
                jCValueLabel2.label.setFont(jCValueLabel.label.font);
                jCValueLabel2.setParent(this.parent);
                this.valueLabels.insertElementAt(jCValueLabel2, n3 - n);
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private void makePointLabelsRadar(ChartDataView chartDataView) {
        int[] nArray;
        if (chartDataView != null && (nArray = ChartDataView.getFirstLastPoints(chartDataView)) != null) {
            this.valueLabels = new Vector();
            ChartDataViewSeries chartDataViewSeries = chartDataView.getSeries(0);
            int n = nArray[0];
            while (n <= nArray[1]) {
                String string = (String)chartDataView.getPointLabels().get(n);
                if (string != null) {
                    JCValueLabel jCValueLabel = new JCValueLabel(chartDataViewSeries.getX(n), string, this.parent);
                    jCValueLabel.label.setRotation(this.parent.annotationRotation);
                    jCValueLabel.setParent(this.parent);
                    this.valueLabels.addElement(jCValueLabel);
                }
                ++n;
            }
        }
    }

    private void makeValueAnnotationsRadar(ChartDataView chartDataView) {
        int[] nArray;
        if (chartDataView != null && (nArray = ChartDataView.getFirstLastPoints(chartDataView)) != null) {
            JCValueLabel jCValueLabel = null;
            int n = nArray[1] - nArray[0] + 1;
            int n2 = 0;
            while (n2 < n) {
                double d = JCChartUtil.getRadarAngle(this.parent.getChartArea().getAngleUnit(), n, n2, false);
                jCValueLabel = new JCValueLabel(d, Integer.toString(n2), this.parent);
                jCValueLabel.setParent(this.parent);
                this.valueLabels.addElement(jCValueLabel);
                ++n2;
            }
        }
    }

    private void makePointLabels(ChartDataView chartDataView) {
        if (chartDataView != null) {
            ChartDataViewSeries chartDataViewSeries = null;
            try {
                chartDataViewSeries = chartDataView.getSeries(0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (chartDataViewSeries != null) {
                int n = 0;
                int n2 = Math.min(chartDataView.getPointLabels().size(), chartDataViewSeries.maxXIndex()) - 1;
                this.valueLabels = new Vector();
                int n3 = n;
                while (n3 <= n2) {
                    String string = (String)chartDataView.getPointLabels().get(n3);
                    if (string != null) {
                        JCValueLabel jCValueLabel = new JCValueLabel(chartDataViewSeries.getX(n3), string, this.parent);
                        jCValueLabel.label.setRotation(this.parent.annotationRotation);
                        jCValueLabel.setParent(this.parent);
                        this.valueLabels.addElement(jCValueLabel);
                    }
                    ++n3;
                }
            }
        }
    }

    private void makeTimeLabels() {
        this.valueLabels = new Vector();
        if (this.parent.timeBase == null) {
            this.parent.timeBase = new Date();
        }
        long l = this.parent.timeUnit;
        double d = (this.parent.max.value - this.parent.min.value) * (double)l;
        if (this.parent.getTimeFormatIsDefault() || this.parent.getTimeFormat() == null || this.parent.getTimeFormat().equals("")) {
            this.getDateFormatter();
            this.parent.setTimeFormat(JCChartDateFormat.getDefaultTimeFormat(d), false);
            this.parent.setTimeFormatIsDefault(true, false);
        }
        String string = this.parent.getTimeFormat();
        int n = this.parent.annotationRotation;
        String string2 = this.getDateFormatter().getLargestTimeLabel(string);
        boolean bl = this.parent.getNumberLocalization();
        this.parent.setNumberLocalization(false);
        JCValueLabel jCValueLabel = new JCValueLabel(0.0, string2, this.parent);
        if (bl) {
            this.parent.setNumberLocalization(true);
        }
        jCValueLabel.label.setRotation(n);
        jCValueLabel.setParent(this.parent);
        Dimension dimension = jCValueLabel.label.calcSize();
        Dimension dimension2 = n == 0 || n == 2 ? new Dimension(dimension.width, dimension.height) : new Dimension(dimension.height, dimension.width);
        int n2 = this.parent.vertical ? this.parent.getHeight() / (dimension2.height + this.parent.gap * 2) : this.parent.getWidth() / (dimension2.width + this.parent.gap * 2);
        n2 = Math.max(n2, 2);
        long l2 = (long)(d / (double)n2);
        l2 = this.getDateFormatter().niceInc(l2 / 2L, string);
        n2 = (int)(d / (double)l2) + 2;
        this.parent.timeBase.setTime(JCChartUtil.clamp(this.parent.timeBase.getTime(), JCChartDateFormat.getMinTime().getTime(), JCChartDateFormat.getMaxTime().getTime()));
        Date date = new Date(this.parent.timeBase.getTime());
        this.getDateFormatter().roundTime(date, l2, false);
        long l3 = this.parent.timeBase.getTime() - date.getTime();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.parent.timeBase);
        int n3 = gregorianCalendar.get(1);
        int n4 = gregorianCalendar.get(2);
        int n5 = gregorianCalendar.get(5);
        int n6 = gregorianCalendar.get(16);
        gregorianCalendar.setTime(date);
        int n7 = gregorianCalendar.get(2);
        int n8 = gregorianCalendar.get(16);
        if (gregorianCalendar.isLeapYear(n3) && (n4 >= 2 || n4 == 1 && n5 == 29) && n7 <= 1) {
            l3 -= 86400000L;
        }
        if (n8 < n6) {
            l3 += 3600000L;
        } else if (n8 > n6) {
            l3 -= 3600000L;
        }
        if (l3 < 0L) {
            l3 += 3600000L;
        }
        this.getDateFormatter();
        long l4 = JCChartDateFormat.timeIncUnits(l2);
        double d2 = (double)l2 / (double)l4;
        date = this.dataToTime(this.parent.min.value, l);
        double d3 = this.timeToData(date, l4);
        long l5 = (long)(d3 / d2);
        d3 = d2 * (double)l5;
        long l6 = JCChartDateFormat.getMinTime().getTime();
        long l7 = JCChartDateFormat.getMaxTime().getTime();
        long l8 = l6;
        long l9 = l7;
        Date date2 = null;
        try {
            date2 = this.dataToTime(this.parent.min.value, l);
            this.getDateFormatter().roundTime(date2, l2, false);
            l8 = date2 == null ? l6 : date2.getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            date2 = this.dataToTime(this.parent.max.value, l);
            this.getDateFormatter().roundTime(date2, l2, true);
            l9 = date2 == null ? l7 : date2.getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl2 = false;
        Date date3 = new Date();
        int n9 = 0;
        while (n9 < n2) {
            block25: {
                String string3;
                try {
                    date = this.dataToTime(d3, l4);
                    if (date == null) break block25;
                    long l10 = date.getTime() - l3;
                    gregorianCalendar.setTime(date);
                    int n10 = gregorianCalendar.get(5);
                    int n11 = gregorianCalendar.get(1);
                    int n12 = gregorianCalendar.get(2);
                    int n13 = gregorianCalendar.get(16);
                    if (l4 == 2678400000L && n5 != n10 && n5 > n10) {
                        l10 += (long)(n5 - n10) * 86400000L;
                    }
                    date3.setTime(l10);
                    gregorianCalendar.setTime(date3);
                    int n14 = gregorianCalendar.get(16);
                    if (n14 < n13) {
                        l10 += 3600000L;
                    } else if (n14 > n13) {
                        l10 -= 3600000L;
                    }
                    if (gregorianCalendar.isLeapYear(n11)) {
                        date3.setTime(l10);
                        gregorianCalendar.setTime(date3);
                        int n15 = gregorianCalendar.get(2);
                        if ((n12 >= 2 || n12 == 1 && n10 == 29) && n15 <= 1) {
                            l10 -= 86400000L;
                        }
                    }
                    if (l6 > l10 || l7 < l10) {
                        bl2 = true;
                        --n2;
                        --n9;
                        break block25;
                    }
                    if (l8 > l10 || l9 < l10) {
                        --n2;
                        --n9;
                        break block25;
                    }
                    date.setTime(l10);
                    string3 = this.getDateFormatter().timeLabel(string, date);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    string3 = new String(JCChartBundle.string("com.klg.jclass.chart.Key31"));
                }
                double d4 = this.timeToData(date, l);
                this.parent.setNumberLocalization(false);
                JCValueLabel jCValueLabel2 = new JCValueLabel(d4, string3, this.parent);
                if (bl) {
                    this.parent.setNumberLocalization(true);
                }
                jCValueLabel2.label.setRotation(n);
                jCValueLabel2.setParent(this.parent);
                this.valueLabels.addElement(jCValueLabel2);
            }
            ++n9;
            d3 += d2;
        }
        if (bl2) {
            ErrorDialog.raise(this.parent, JCChartBundle.string("com.klg.jclass.chart.Key118"));
        }
    }

    private void timeLabelExtents(Dimension dimension) {
        Serializable serializable;
        Serializable serializable2 = null;
        boolean bl = this.parent.annotationRotation == 1 || this.parent.annotationRotation == 3;
        int n = 0;
        dimension.height = 0;
        dimension.width = 0;
        int n2 = 0;
        while (n2 < this.valueLabels.size()) {
            serializable = (JCValueLabel)this.valueLabels.elementAt(n2);
            int n3 = ((JCValueLabel)serializable).getChartText().getText().length();
            if (n3 > n) {
                n = n3;
                serializable2 = serializable;
            }
            ++n2;
        }
        if (serializable2 == null) {
            return;
        }
        serializable = serializable2.getChartText().calcSize();
        if (bl) {
            dimension.width = ((Dimension)serializable).height;
            dimension.height = ((Dimension)serializable).width;
        } else {
            dimension.width = ((Dimension)serializable).width;
            dimension.height = ((Dimension)serializable).height;
        }
    }

    void setValueLabelParent(JCChart jCChart) {
        JCValueLabel jCValueLabel;
        int n;
        if (this.valueLabels != null) {
            n = 0;
            while (n < this.valueLabels.size()) {
                jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n);
                jCValueLabel.getChartText().setParentChart(jCChart);
                ++n;
            }
        }
        if (this.userValueLabels != null) {
            n = 0;
            while (n < this.userValueLabels.size()) {
                jCValueLabel = (JCValueLabel)this.userValueLabels.elementAt(n);
                jCValueLabel.getChartText().setParentChart(jCChart);
                ++n;
            }
        }
    }
}

