/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego.swing;

import com.openit.lego.date.DateInfo;
import com.openit.lego.swing.CalendarPanel;
import com.openit.lego.swing.SwingConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DayPanel
extends JPanel
implements DateInfo {
    private CalendarPanel calendar;
    private int year;
    private int month;
    private JPanel dayTable = null;
    private JButton selectedDay = null;
    private JPanel dayHeaders = null;

    public DayPanel(CalendarPanel caller) {
        this.calendar = caller;
        this.setLayout(new BorderLayout());
        this.dayHeaders = new JPanel();
        this.dayHeaders.setLayout(new GridLayout(0, 7));
        for (int i = 0; i < 7; ++i) {
            this.dayHeaders.add(this.makeDaynameHeaderLabel(i));
        }
        this.add((Component)this.dayHeaders, "North");
    }

    private JLabel makeDaynameHeaderLabel(int day) {
        JLabel dayHeader = new JLabel(dayname[day].substring(0, 2), 0);
        dayHeader.setFont(SwingConstants.FNT_DEFAULT);
        return dayHeader;
    }

    public JButton drawDays(int year, int month) {
        Date d;
        int i;
        int nmonth;
        int nyear;
        if (this.dayTable != null) {
            this.remove(this.dayTable);
        }
        this.dayTable = new JPanel();
        this.dayTable.setLayout(new GridLayout(0, 7));
        GregorianCalendar g = new GregorianCalendar(year, month - 1, 1);
        int dayOfWeek = g.get(7) - 1;
        dayOfWeek = dayOfWeek == 0 ? 6 : --dayOfWeek;
        for (int i2 = 0; i2 < dayOfWeek; ++i2) {
            this.dayTable.add(new JLabel(" "));
        }
        g = new GregorianCalendar();
        int matchday = g.get(1) == year && g.get(2) == month - 1 ? g.get(5) : -1;
        if (month == 12) {
            nyear = year + 1;
            nmonth = 0;
        } else {
            nyear = year;
            nmonth = month;
        }
        Date limitdate = new GregorianCalendar(year, nmonth, 1).getTime();
        JButton FocusButton = null;
        for (i = 1; i < 32 && (d = new GregorianCalendar(year, month - 1, i).getTime()).before(limitdate); ++i) {
            JButton b = new JButton(Integer.toString(i));
            this.dayTable.add(b);
            class CalendarActionListener
            implements ActionListener {
                private DayPanel panel;
                private JButton button;

                public CalendarActionListener(DayPanel pan, JButton bArg) {
                    this.panel = pan;
                    this.button = bArg;
                }

                public void actionPerformed(ActionEvent e) {
                    if (DayPanel.this.selectedDay != null) {
                        DayPanel.this.selectedDay.setForeground(this.panel.getForeground());
                    }
                    DayPanel.this.selectedDay = this.button;
                    DayPanel.this.selectedDay.setForeground(Color.blue);
                    try {
                        int day = Integer.parseInt(e.getActionCommand());
                        DayPanel.this.calendar.setDay(day);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            b.addActionListener(new CalendarActionListener(this, b));
            b.setFont(SwingConstants.FNT_LISTBOX);
            if (i != matchday) continue;
            FocusButton = b;
        }
        while (i < 37) {
            this.dayTable.add(new JLabel(" "));
            ++i;
        }
        this.add("Center", this.dayTable);
        this.selectedDay = null;
        return FocusButton;
    }
}

