/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class JCSwingUtilities {
    public static void setEnabled(Component component, boolean bl) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                JCSwingUtilities.setEnabled(componentArray[n], bl);
                ++n;
            }
        }
        component.setEnabled(bl);
    }

    public static Dimension getPreferredSizeFromGraphics(JComponent jComponent, Graphics graphics, boolean bl) {
        if (jComponent == null) {
            return new Dimension(0, 0);
        }
        if (graphics == null) {
            return jComponent.getPreferredSize();
        }
        Class<? extends ComponentUI> clazz = UIManager.getDefaults().getUIClass(jComponent.getUIClassID());
        Class<?> clazz2 = null;
        if (!bl) {
            if (jComponent instanceof JLabel) {
                clazz2 = ((JLabel)jComponent).getUI().getClass();
            } else if (jComponent instanceof JButton) {
                clazz2 = ((JButton)jComponent).getUI().getClass();
            }
        }
        if (clazz2 == null || clazz != clazz2) {
            return jComponent.getPreferredSize();
        }
        if (jComponent instanceof JLabel) {
            return JCSwingUtilities.getLabelPSFromGraphics((JLabel)jComponent, graphics);
        }
        if (jComponent instanceof JButton) {
            return JCSwingUtilities.getButtonPSFromGraphics((JButton)jComponent, graphics);
        }
        return jComponent.getPreferredSize();
    }

    public static Dimension getLabelPSFromGraphics(JLabel jLabel, Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(jLabel.getFont());
        Insets insets = jLabel.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom + 2;
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle3 = new Rectangle(n, n2, Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, jLabel.getText(), jLabel.getIcon(), jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle3, rectangle2, rectangle, jLabel.getIconTextGap());
        int n3 = Math.min(rectangle2.x, rectangle.x);
        int n4 = Math.max(rectangle2.x + rectangle2.width, rectangle.x + rectangle.width);
        int n5 = Math.min(rectangle2.y, rectangle.y);
        int n6 = Math.max(rectangle2.y + rectangle2.height, rectangle.y + rectangle.height);
        return new Dimension(n4 - n3 + n, n6 - n5 + n2);
    }

    public static Dimension getButtonPSFromGraphics(JButton jButton, Graphics graphics) {
        ButtonUI buttonUI = jButton.getUI();
        int n = 0;
        if (jButton.getText() != null && buttonUI instanceof BasicButtonUI) {
            n = ((BasicButtonUI)buttonUI).getDefaultTextIconGap(jButton);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(jButton.getFont());
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(jButton, fontMetrics, jButton.getText(), jButton.getIcon(), jButton.getVerticalAlignment(), jButton.getHorizontalAlignment(), jButton.getVerticalTextPosition(), jButton.getHorizontalTextPosition(), rectangle3, rectangle2, rectangle, n);
        Rectangle rectangle4 = rectangle2.union(rectangle);
        Insets insets = jButton.getInsets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        rectangle4.width += n2;
        rectangle4.height += n3;
        if (rectangle4.width % 2 == 0) {
            ++rectangle4.width;
        }
        if (rectangle4.height % 2 == 0) {
            ++rectangle4.height;
        }
        return new Dimension(rectangle4.width, rectangle4.height);
    }
}

