/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import java.util.List;
import java.util.Vector;

public class SeqRangeCollector {
    public static final int RANGE_INCREASING_BY_1 = 0;
    public static final int RANGE_SAME_VALUE = 1;
    public static final int RANGE_BREAK_NORMAL = 0;
    public static final int RANGE_BREAK_HEX_BOUNDARY = 1;
    protected int rangeType = 0;
    protected int rangeBreak = 0;
    protected int emptyValue = -1;
    protected int startOfCurrentRange;
    protected int lastItemInCurrentRange;
    protected int sizeOfCurrentRange;
    protected Vector ranges = null;

    public SeqRangeCollector() {
        this.reset();
    }

    public void reset() {
        this.startOfCurrentRange = this.emptyValue;
        this.lastItemInCurrentRange = this.emptyValue;
        this.sizeOfCurrentRange = 0;
        this.ranges = new Vector();
    }

    public void addItem(int n) {
        if (this.startOfCurrentRange == this.emptyValue) {
            this.startOfCurrentRange = n;
            this.lastItemInCurrentRange = n;
            ++this.sizeOfCurrentRange;
        } else if (this.rangeBreak == 1 && this.lastItemInCurrentRange % 256 == 255 && n % 256 == 0) {
            this.flushRange(n);
        } else if (this.rangeType == 0 && n == this.lastItemInCurrentRange + 1) {
            this.lastItemInCurrentRange = n;
            ++this.sizeOfCurrentRange;
        } else {
            this.flushRange(n);
        }
    }

    public void done() {
        this.flushRange(this.emptyValue);
    }

    protected void flushRange(int n) {
        if (this.startOfCurrentRange == this.emptyValue) {
            return;
        }
        Range range = new Range();
        if (this.rangeType == 0) {
            range.start = this.startOfCurrentRange;
            range.end = this.lastItemInCurrentRange;
            range.size = this.sizeOfCurrentRange;
        }
        this.ranges.add(range);
        this.startOfCurrentRange = n;
        this.lastItemInCurrentRange = n;
        this.sizeOfCurrentRange = n == this.emptyValue ? 0 : 1;
    }

    public List getRanges() {
        return this.ranges;
    }

    public void setRangeType(int n) {
        this.rangeType = n;
    }

    public int getRangeType() {
        return this.rangeType;
    }

    public void setRangeBreak(int n) {
        this.rangeBreak = n;
    }

    public int getRangeBreak() {
        return this.rangeBreak;
    }

    public void setEmptyValue(int n) {
        this.emptyValue = n;
    }

    public int getEmptyValue() {
        return this.emptyValue;
    }

    public class Range {
        public int start;
        public int end;
        public int size;

        public Range() {
            this.start = SeqRangeCollector.this.emptyValue;
            this.end = SeqRangeCollector.this.emptyValue;
            this.size = 0;
        }

        public Range(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.size = n3;
        }

        public String toString() {
            return "Range: from " + Integer.toHexString(this.start) + " to " + Integer.toHexString(this.end) + " (" + this.size + " items)";
        }
    }
}

