/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCShape;
import com.klg.jclass.chart.JCSymbolStyle;
import java.awt.Color;
import java.awt.Image;
import java.io.Serializable;
import java.util.Vector;

public class JCChartStyle
implements Serializable {
    protected JCLineStyle lineStyle = null;
    protected JCFillStyle fillStyle = null;
    protected JCSymbolStyle symbolStyle = null;
    protected Vector parents = new Vector();

    public JCChartStyle(JCLineStyle jCLineStyle, JCFillStyle jCFillStyle, JCSymbolStyle jCSymbolStyle) {
        this.lineStyle = jCLineStyle;
        this.fillStyle = jCFillStyle;
        this.symbolStyle = jCSymbolStyle;
        this.fillStyle.parent = this.symbolStyle.parent = this;
        this.lineStyle.parent = this.symbolStyle.parent;
    }

    public JCChartStyle() {
        this.lineStyle = JCLineStyle.makeDefault(null);
        this.fillStyle = JCFillStyle.makeDefault(null);
        this.symbolStyle = JCSymbolStyle.makeDefault(null);
        this.fillStyle.parent = this.symbolStyle.parent = this;
        this.lineStyle.parent = this.symbolStyle.parent;
    }

    public static JCChartStyle makeDefault(JCChart jCChart) {
        return JCChartStyle.makeDefault(jCChart, null, false);
    }

    public static JCChartStyle makeDefault(JCChart jCChart, Changeable changeable) {
        return JCChartStyle.makeDefault(jCChart, changeable, false);
    }

    public static JCChartStyle makeDefault(JCChart jCChart, Changeable changeable, boolean bl) {
        JCChartStyle jCChartStyle = new JCChartStyle(JCLineStyle.makeDefault(jCChart), JCFillStyle.makeDefault(jCChart, bl), JCSymbolStyle.makeDefault(jCChart));
        if (changeable != null) {
            jCChartStyle.parents.addElement(changeable);
        } else if (jCChart != null) {
            jCChartStyle.parents.addElement(jCChart.getChartArea());
        }
        return jCChartStyle;
    }

    public JCLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(JCLineStyle jCLineStyle) {
        if (this.lineStyle == jCLineStyle) {
            return;
        }
        this.lineStyle = jCLineStyle;
        this.lineStyle.parent = this;
        this.callParentSetChanged(true, 17);
    }

    public int getLinePattern() {
        if (this.lineStyle == null) {
            return 0;
        }
        return this.lineStyle.getPattern();
    }

    public void setLinePattern(int n) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setPattern(n);
    }

    public int getLineJoin() {
        if (this.lineStyle == null) {
            return -1;
        }
        return this.lineStyle.getJoin();
    }

    public void setLineJoin(int n) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setJoin(n);
    }

    public int getLineCap() {
        if (this.lineStyle == null) {
            return -1;
        }
        return this.lineStyle.getCap();
    }

    public void setLineCap(int n) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setCap(n);
    }

    public int getLineWidth() {
        if (this.lineStyle == null) {
            return 0;
        }
        return this.lineStyle.getWidth();
    }

    public void setLineWidth(int n) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setWidth(n);
    }

    public Color getLineColor() {
        if (this.lineStyle == null) {
            return null;
        }
        return this.lineStyle.getColor();
    }

    public void setLineColor(Color color) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setColor(color);
    }

    public JCSymbolStyle getSymbolStyle() {
        return this.symbolStyle;
    }

    public void setSymbolStyle(JCSymbolStyle jCSymbolStyle) {
        if (this.symbolStyle == jCSymbolStyle) {
            return;
        }
        this.symbolStyle = jCSymbolStyle;
        this.symbolStyle.parent = this;
        this.callParentSetChanged(true, 17);
    }

    public int getSymbolShape() {
        if (this.symbolStyle == null) {
            return 0;
        }
        return this.symbolStyle.getShape();
    }

    public void setSymbolShape(int n) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setShape(n);
    }

    public Color getSymbolColor() {
        if (this.symbolStyle == null) {
            return null;
        }
        return this.symbolStyle.getColor();
    }

    public void setSymbolColor(Color color) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setColor(color);
    }

    public int getSymbolSize() {
        if (this.symbolStyle == null) {
            return 0;
        }
        return this.symbolStyle.getSize();
    }

    public void setSymbolSize(int n) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setSize(n);
    }

    public JCShape getSymbolCustomShape() {
        if (this.symbolStyle == null) {
            return null;
        }
        return this.symbolStyle.getCustomShape();
    }

    public void setSymbolCustomShape(JCShape jCShape) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setCustomShape(jCShape);
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle == jCFillStyle) {
            return;
        }
        this.fillStyle = jCFillStyle;
        this.fillStyle.parent = this;
        this.callParentSetChanged(true, 33);
    }

    public Color getFillColor() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getColor();
    }

    public void setFillColor(Color color) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setColor(color);
    }

    public Color getFillBackground() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getBackground();
    }

    public void setFillBackground(Color color) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setBackground(color);
    }

    public int getFillPattern() {
        if (this.fillStyle == null) {
            return 0;
        }
        return this.fillStyle.getPattern();
    }

    public void setFillPattern(int n) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setPattern(n);
    }

    public Image getFillImage() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getImage();
    }

    public void setFillImage(Image image) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setImage(image);
    }

    void callParentSetChanged(boolean bl, int n) {
        if (this.parents == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.parents.size()) {
            ((Changeable)this.parents.elementAt(n2)).setChanged(true, n);
            ++n2;
        }
    }

    public void addParent(Changeable changeable) {
        int n = 0;
        while (n < this.parents.size()) {
            if (this.parents.elementAt(n) == changeable) {
                return;
            }
            ++n;
        }
        this.parents.addElement(changeable);
    }

    public void removeParent(Changeable changeable) {
        int n = 0;
        while (n < this.parents.size()) {
            if (this.parents.elementAt(n) == changeable) {
                this.parents.removeElementAt(n);
            }
            ++n;
        }
    }

    public void clearParents() {
        this.parents = new Vector();
    }
}

