/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

class JCChartDateFormat {
    private static final String engEraSym = "G";
    private static final String engYearSym = "y";
    private static final String engMonthSym = "M";
    private static final String engDaySym = "dEDFwW";
    private static final String engHourSym = "ahHkKz";
    private static final String engMinuteSym = "m";
    private static final String engSecondSym = "s";
    private static final String engMillisecondSym = "S";
    private String secondSym = null;
    private String minuteSym = null;
    private String hourSym = null;
    private String daySym = null;
    private String monthSym = null;
    private String yearSym = null;
    private Calendar calendar = Calendar.getInstance();
    private TimeZone timeZone = null;
    private SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance();
    private SimpleDateFormat longFormatter = null;
    private String largestTimeLabel = null;
    private String currentPattern = "";
    private static Date minTime = null;
    private static Date maxTime = null;

    JCChartDateFormat() {
        this.timeZone = TimeZone.getDefault();
        this.calendar.setTimeZone(this.timeZone);
        this.formatter.setCalendar(this.calendar);
        this.formatter.setTimeZone(this.timeZone);
        this.longFormatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0);
        this.longFormatter.setCalendar(this.calendar);
        this.longFormatter.setTimeZone(this.timeZone);
        this.largestTimeLabel = this.getLargestLocaleTimeLabel();
        this.secondSym = this.getLocalizedPattern(engSecondSym);
        this.minuteSym = this.getLocalizedPattern(engMinuteSym);
        this.hourSym = this.getLocalizedPattern(engHourSym);
        this.daySym = this.getLocalizedPattern(engDaySym);
        this.monthSym = this.getLocalizedPattern(engMonthSym);
        this.yearSym = this.getLocalizedPattern(engYearSym);
    }

    void setLocale(Locale locale) {
        this.calendar = Calendar.getInstance(locale);
        this.formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, locale);
        this.timeZone = TimeZone.getDefault();
        this.calendar.setTimeZone(this.timeZone);
        this.formatter.setCalendar(this.calendar);
        this.formatter.setTimeZone(this.timeZone);
        this.longFormatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, locale);
        this.longFormatter.setCalendar(this.calendar);
        this.longFormatter.setTimeZone(this.timeZone);
        this.currentPattern = "";
        this.largestTimeLabel = this.getLargestLocaleTimeLabel();
        this.secondSym = this.getLocalizedPattern(engSecondSym);
        this.minuteSym = this.getLocalizedPattern(engMinuteSym);
        this.hourSym = this.getLocalizedPattern(engHourSym);
        this.daySym = this.getLocalizedPattern(engDaySym);
        this.monthSym = this.getLocalizedPattern(engMonthSym);
        this.yearSym = this.getLocalizedPattern(engYearSym);
    }

    String timeLabel(Date date) {
        return this.formatter.format(date);
    }

    static String timeLabel(int n, Date date, Locale locale) {
        String string = null;
        Calendar calendar = Calendar.getInstance(locale);
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n, locale);
                dateFormat.setCalendar(calendar);
                string = dateFormat.format(date);
                break;
            }
            default: {
                string = date.toString();
            }
        }
        return string;
    }

    String timeLabel(String string, Date date) {
        String string2 = null;
        try {
            this.formatter.applyLocalizedPattern(this.getLocalizedPattern(string));
            string2 = this.formatter.format(date);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    static Date getMinTime() {
        if (minTime == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(calendar.getMinimum(1), calendar.getMinimum(2), calendar.getMinimum(5), calendar.getMinimum(11), calendar.getMinimum(12), calendar.getMinimum(13));
            minTime = calendar.getTime();
        }
        return minTime;
    }

    static Date getMaxTime() {
        if (maxTime == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(calendar.getMaximum(1) - 1, calendar.getMaximum(2), calendar.getMaximum(5), calendar.getMaximum(11), calendar.getMaximum(12), calendar.getMaximum(13));
            maxTime = calendar.getTime();
        }
        return maxTime;
    }

    String getLargestTimeLabel(String string) {
        this.calculateLargestTimeLabel(string);
        return this.largestTimeLabel;
    }

    void calculateLargestTimeLabel(String string) {
        if (string.compareTo(this.currentPattern) == 0) {
            return;
        }
        this.currentPattern = string;
        String[] stringArray = this.longFormatter.getDateFormatSymbols().getMonths();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 12) {
            int n4 = stringArray[n3].length();
            if (n2 < n4) {
                n2 = n4;
                n = n3;
            }
            ++n3;
        }
        String[] stringArray2 = this.longFormatter.getDateFormatSymbols().getWeekdays();
        int n5 = 0;
        n2 = 0;
        int n6 = 1;
        while (n6 <= 7) {
            int n7 = stringArray2[n6].length();
            if (n2 < n7) {
                n2 = n7;
                n5 = n6;
            }
            ++n6;
        }
        this.calendar.set(2, n);
        this.calendar.set(5, 1);
        while (this.calendar.get(7) != n5) {
            this.calendar.roll(5, true);
        }
        this.formatter.applyLocalizedPattern(this.getLocalizedPattern(string));
        this.largestTimeLabel = this.formatter.format(this.calendar.getTime());
        this.calendar.setTime(new Date());
    }

    String getLargestLocaleTimeLabel() {
        return this.getLargestTimeLabel(this.longFormatter.toPattern());
    }

    void roundTime(Date date, long l, boolean bl) {
        int n = bl ? 1 : 0;
        this.calendar.setTime(date);
        if (l < 1000L) {
            this.calendar.set(14, (this.calendar.get(14) / 1000 + n) * 1000);
        } else {
            this.calendar.set(14, 0);
            if (l < 60000L) {
                this.calendar.set(13, (int)(((long)this.calendar.get(13) / (l /= 1000L) + (long)n) * l));
            } else {
                this.calendar.set(13, 0);
                if (l < 3600000L) {
                    this.calendar.set(12, (int)(((long)this.calendar.get(12) / (l /= 60000L) + (long)n) * l));
                } else {
                    this.calendar.set(12, 0);
                    if (l < 86400000L) {
                        this.calendar.set(11, (int)(((long)this.calendar.get(11) / (l /= 3600000L) + (long)n) * l));
                    } else {
                        this.calendar.set(11, 0);
                        if (l < 2678400000L) {
                            if (bl) {
                                this.calendar.set(5, (int)((long)this.calendar.get(5) + l / 86400000L));
                            }
                        } else {
                            this.calendar.set(5, 1);
                            if (l < 31536000000L) {
                                if (bl) {
                                    this.calendar.set(2, (int)((long)this.calendar.get(2) + l / 2678400000L));
                                }
                            } else {
                                this.calendar.set(2, 0);
                                if (bl) {
                                    this.calendar.set(1, (int)((long)this.calendar.get(1) + l / 31536000000L));
                                }
                            }
                        }
                    }
                }
            }
        }
        date.setTime(this.calendar.getTime().getTime());
        this.calendar.setTime(new Date());
    }

    long niceInc(long l, String string) {
        long l2 = JCChartDateFormat.getMaxTime().getTime();
        String string2 = this.getLocalizedPattern(string);
        if (this.matchPattern(string2, this.secondSym)) {
            l2 = 1000L;
        } else if (this.matchPattern(string2, this.minuteSym)) {
            l2 = Math.min(l2, 60000L);
        } else if (this.matchPattern(string2, this.hourSym)) {
            l2 = Math.min(l2, 3600000L);
        } else if (this.matchPattern(string2, this.daySym)) {
            l2 = Math.min(l2, 86400000L);
        } else if (this.matchPattern(string2, this.monthSym)) {
            l2 = Math.min(l2, 2678400000L);
        } else if (this.matchPattern(string2, this.yearSym)) {
            l2 = Math.min(l2, 31536000000L);
        }
        if (l2 == JCChartDateFormat.getMaxTime().getTime()) {
            l2 = 1L;
        }
        if (l2 < 60000L) {
            if (l <= 1000L) {
                return 1000L;
            }
            if (l <= 5000L) {
                return 5000L;
            }
            if (l <= 10000L) {
                return 10000L;
            }
            if (l <= 15000L) {
                return 15000L;
            }
            if (l <= 30000L) {
                return 30000L;
            }
            l2 = 60000L;
        }
        if (l2 < 3600000L) {
            if (l <= l2) {
                return l2;
            }
            if (l <= 5L * l2) {
                return 5L * l2;
            }
            if (l <= 10L * l2) {
                return 10L * l2;
            }
            if (l <= 15L * l2) {
                return 15L * l2;
            }
            if (l <= 30L * l2) {
                return 30L * l2;
            }
            l2 = 3600000L;
        }
        if (l2 < 86400000L) {
            if (l <= l2) {
                return l2;
            }
            if (l <= 3L * l2) {
                return 3L * l2;
            }
            if (l <= 6L * l2) {
                return 6L * l2;
            }
            if (l <= 12L * l2) {
                return 12L * l2;
            }
            l2 = 86400000L;
        }
        if (l2 < 2678400000L) {
            if (l <= l2) {
                return l2;
            }
            if (l <= 2L * l2) {
                return 2L * l2;
            }
            if (l <= 7L * l2) {
                return 7L * l2;
            }
            if (l <= 14L * l2) {
                return 14L * l2;
            }
            l2 = 2678400000L;
        }
        if (l2 < 31536000000L) {
            if (l <= l2) {
                return l2;
            }
            if (l <= 2L * l2) {
                return 2L * l2;
            }
            if (l <= 3L * l2) {
                return 3L * l2;
            }
            if (l <= 4L * l2) {
                return 4L * l2;
            }
            if (l <= 6L * l2) {
                return 6L * l2;
            }
            l2 = 31536000000L;
        }
        if (l <= l2) {
            return l2;
        }
        if (l <= 2L * l2) {
            return 2L * l2;
        }
        if (l <= 5L * l2) {
            return 5L * l2;
        }
        if (l <= 10L * l2) {
            return 10L * l2;
        }
        return 20L * l2;
    }

    static long timeIncUnits(long l) {
        if (l < 60000L) {
            return 1000L;
        }
        if (l < 3600000L) {
            return 60000L;
        }
        if (l < 86400000L) {
            return 3600000L;
        }
        if (l < 2678400000L) {
            return 86400000L;
        }
        if (l < 31536000000L) {
            return 2678400000L;
        }
        return 31536000000L;
    }

    void addToUnit(Date date, long l, int n) {
        this.calendar.setTime(date);
        if (l < 1000L) {
            this.calendar.add(14, n);
        } else if (l < 60000L) {
            this.calendar.add(13, n);
        } else if (l < 3600000L) {
            this.calendar.add(12, n);
        } else if (l < 86400000L) {
            this.calendar.add(11, n);
        } else if (l < 2678400000L) {
            this.calendar.add(5, n);
        } else if (l < 31536000000L) {
            this.calendar.add(2, n);
        } else {
            this.calendar.add(1, n);
        }
        if (this.calendar.getTime().getTime() < JCChartDateFormat.getMinTime().getTime()) {
            this.calendar.setTime(JCChartDateFormat.getMinTime());
        }
        if (this.calendar.getTime().getTime() > JCChartDateFormat.getMaxTime().getTime()) {
            this.calendar.setTime(JCChartDateFormat.getMaxTime());
        }
        date.setTime(this.calendar.getTime().getTime());
        this.calendar.setTime(new Date());
    }

    static String getDefaultTimeFormat(double d) {
        String string = null;
        string = d > 6.3072E10 ? "yyyy" : (d > 3.1536E10 ? "MMM yy" : (d > 8.0352E9 ? "MMM" : (d > 1.2096E9 ? "MMM dd" : (d > 1.728E8 ? "EE dd" : (d > 8.64E7 ? "EE HH:mm" : (d > 3600000.0 ? "HH:mm" : "HH:mm:ss"))))));
        return string;
    }

    private String getLocalizedPattern(String string) {
        this.formatter.applyPattern(string);
        return this.formatter.toLocalizedPattern();
    }

    private boolean matchPattern(String string, String string2) {
        boolean bl = false;
        int n = 0;
        while (n < string2.length()) {
            if (string.indexOf(string2.charAt(n)) >= 0) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }
}

