/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.property;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartEnumMappings;
import com.klg.jclass.chart.data.JCDataInterpreter;
import com.klg.jclass.chart.data.JCFileDataSource;
import com.klg.jclass.chart.data.JCInputStreamDataSource;
import com.klg.jclass.chart.data.JCStringDataSource;
import com.klg.jclass.chart.data.JCURLDataSource;
import com.klg.jclass.chart.data.JCXMLDataInterpreter;
import com.klg.jclass.chart.property.DataFileException;
import com.klg.jclass.chart.property.FilePropertyAccessModel;
import com.klg.jclass.chart.property.JCBaseAccessor;
import com.klg.jclass.chart.property.PropertyAccessModel;
import com.klg.jclass.chart.property.PropertyLoadFactory;
import com.klg.jclass.chart.property.PropertyLoadModel;
import com.klg.jclass.chart.property.html.JCAppletAccessor;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class ChartDataViewPropertyLoad
implements PropertyLoadModel {
    public static final String[] formatPrefix = new String[]{"Plot", "Plot", "PolarRadar", "PolarRadar", "PolarRadar", "Hilo", "HLOC", "Candle", "Area", "Bar", "Bar", "Pie", "Area"};
    protected ChartDataView dataView = null;
    protected Hashtable uniqueFormatNames = new Hashtable();

    public ChartDataViewPropertyLoad() {
        int n = 0;
        while (n < formatPrefix.length) {
            this.uniqueFormatNames.put(formatPrefix[n], new Integer(n));
            ++n;
        }
    }

    public void setSource(Object object) {
        if (object instanceof ChartDataView) {
            this.dataView = (ChartDataView)object;
        }
    }

    public void loadProperties(PropertyAccessModel propertyAccessModel, String string) throws DataFileException {
        Object object;
        Object object2;
        this.loadDataSource(propertyAccessModel, string);
        String string2 = propertyAccessModel.getProperty(string + "inverted");
        this.dataView.setInverted(JCTypeConverter.toBoolean(string2, this.dataView.isInverted()));
        string2 = propertyAccessModel.getProperty(string + "visibleInLegend");
        this.dataView.setVisibleInLegend(JCTypeConverter.toBoolean(string2, this.dataView.isVisibleInLegend()));
        string2 = propertyAccessModel.getProperty(string + "visible");
        this.dataView.setVisible(JCTypeConverter.toBoolean(string2, this.dataView.isVisible()));
        string2 = propertyAccessModel.getProperty(string + "autoLabel");
        this.dataView.setAutoLabel(JCTypeConverter.toBoolean(string2, this.dataView.getAutoLabel()));
        string2 = propertyAccessModel.getProperty(string + "bufferPlotData");
        this.dataView.setBufferPlotData(JCTypeConverter.toBoolean(string2, this.dataView.getBufferPlotData()));
        string2 = propertyAccessModel.getProperty(string + "fastUpdate");
        this.dataView.setFastUpdate(JCTypeConverter.toBoolean(string2, this.dataView.getFastUpdate()));
        string2 = propertyAccessModel.getProperty(string + "drawFrontPlane");
        this.dataView.setDrawFrontPlane(JCTypeConverter.toBoolean(string2, this.dataView.getDrawFrontPlane()));
        string2 = propertyAccessModel.getProperty(string + "outlineColor");
        this.dataView.setOutlineColor(JCSwingTypeConverter.toColor(string2, this.dataView.getOutlineColor()));
        string2 = propertyAccessModel.getProperty(string + "holeValue");
        this.dataView.setHoleValue(JCTypeConverter.toDouble(string2, this.dataView.getHoleValue()));
        string2 = propertyAccessModel.getProperty(string + "name");
        this.dataView.setName(string2 != null ? string2 : this.dataView.getName());
        Object object3 = propertyAccessModel.getPropertyObject(string + "pointLabels");
        if (object3 != null) {
            object2 = null;
            if (object3 instanceof String) {
                string2 = (String)object3;
                object = JCTypeConverter.toStringList(string2);
                object2 = Arrays.asList(object);
            } else if (object3 instanceof List) {
                object2 = (List<String>)object3;
            }
            if (object2 != null) {
                this.dataView.setPointLabels((List)object2);
            }
        }
        PropertyLoadFactory.load(propertyAccessModel, this.dataView.getXAxis(), string + "xaxis.");
        PropertyLoadFactory.load(propertyAccessModel, this.dataView.getYAxis(), string + "yaxis.");
        if (this.dataView.getParent() != null && this.dataView.getParent().getChartArea() != null) {
            object2 = this.dataView.getParent().getChartArea();
            string2 = propertyAccessModel.getProperty(string + "xaxis");
            if (string2 != null && (object = ((JCChartArea)object2).findAxisByName(string2)) != null) {
                this.dataView.setXAxis((JCAxis)object);
            }
            if ((string2 = propertyAccessModel.getProperty(string + "yaxis")) != null && (object = ((JCChartArea)object2).findAxisByName(string2)) != null) {
                this.dataView.setYAxis((JCAxis)object);
            }
        }
        int n = 0;
        while (n < this.dataView.getNumSeries()) {
            PropertyLoadFactory.load(propertyAccessModel, this.dataView.getSeries(n), string + "series" + (n + 1) + ".");
            ++n;
        }
        PropertyLoadFactory.load(propertyAccessModel, this.dataView.getOutlineStyle(), string + "line.");
        boolean bl = propertyAccessModel.getType().equals("XML");
        String[] stringArray = bl ? JCChartEnumMappings.chartType_xml_strings : JCChartEnumMappings.chartType_strings;
        int[] nArray = JCChartEnumMappings.chartType_values;
        string2 = propertyAccessModel.getProperty(string + "chartType");
        if (string2 != null) {
            this.dataView.setChartType(JCTypeConverter.toEnum(string2, "chart type", stringArray, nArray, this.dataView.getChartType()));
        }
        if (propertyAccessModel instanceof JCBaseAccessor) {
            JCBaseAccessor jCBaseAccessor = (JCBaseAccessor)propertyAccessModel;
            Enumeration enumeration = this.uniqueFormatNames.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!jCBaseAccessor.searchKeysForPrefix(string + string3)) continue;
                int n2 = (Integer)this.uniqueFormatNames.get(string3);
                PropertyLoadFactory.load(jCBaseAccessor, this.dataView.getChartFormat(n2), string + string3 + ".");
            }
        } else {
            PropertyLoadFactory.load(propertyAccessModel, this.dataView.getChartFormat(), string + formatPrefix[this.dataView.getChartType()] + ".");
        }
    }

    protected void loadDataSource(PropertyAccessModel propertyAccessModel, String string) throws DataFileException {
        ChartDataModel chartDataModel = null;
        Object object = propertyAccessModel.getPropertyObject(string = string.substring(0, string.lastIndexOf(".")));
        if (object == null) {
            String string2 = propertyAccessModel.getProperty(string + "File");
            if (string2 != null) {
                String string3 = propertyAccessModel.getProperty(string + "FileType");
                if (string3 == null || string3.equals("Text")) {
                    Object object2;
                    Object object3;
                    if (propertyAccessModel instanceof FilePropertyAccessModel) {
                        object3 = (FilePropertyAccessModel)((Object)propertyAccessModel);
                        object2 = object3.getFilePropertyStream(string + "File");
                        if (object2 != null) {
                            try {
                                chartDataModel = new JCInputStreamDataSource((InputStream)object2);
                            }
                            catch (Exception exception) {
                                throw new DataFileException(exception.getMessage());
                            }
                        }
                    } else {
                        try {
                            chartDataModel = new JCFileDataSource(string2);
                        }
                        catch (Exception exception) {
                            throw new DataFileException(exception.getMessage());
                        }
                    }
                    if (chartDataModel == null && propertyAccessModel instanceof JCAppletAccessor) {
                        try {
                            object3 = (JCAppletAccessor)propertyAccessModel;
                            object2 = ((JCAppletAccessor)object3).getApplet().getDocumentBase();
                            chartDataModel = new JCURLDataSource((URL)object2, string2);
                        }
                        catch (Exception exception) {
                            throw new DataFileException(exception.getMessage());
                        }
                    }
                } else {
                    JCXMLDataInterpreter jCXMLDataInterpreter = new JCXMLDataInterpreter();
                    try {
                        chartDataModel = new JCFileDataSource(string2, (JCDataInterpreter)jCXMLDataInterpreter);
                    }
                    catch (Exception exception) {
                        if (propertyAccessModel instanceof JCAppletAccessor) {
                            try {
                                JCAppletAccessor jCAppletAccessor = (JCAppletAccessor)propertyAccessModel;
                                URL uRL = jCAppletAccessor.getApplet().getDocumentBase();
                                chartDataModel = new JCURLDataSource(uRL, string2, (JCDataInterpreter)jCXMLDataInterpreter);
                            }
                            catch (Exception exception2) {
                                throw new DataFileException(exception2.getMessage());
                            }
                        }
                        throw new DataFileException(exception.getMessage());
                    }
                }
            }
        } else if (object instanceof String) {
            String string4 = (String)object;
            try {
                chartDataModel = new JCStringDataSource(string4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                chartDataModel = null;
            }
        } else if (object instanceof ChartDataModel) {
            chartDataModel = (ChartDataModel)object;
        }
        if (chartDataModel != null) {
            this.dataView.setDataSource(chartDataModel);
        }
    }
}

