/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.ErrorDialog;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCValueLabel;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.Vector;

abstract class AxisHandler {
    JCAxis parent = null;
    double shift;
    double scale = 1.0;

    AxisHandler() {
    }

    void setParent(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    static AxisHandler makeAxisHandler(JCAxis jCAxis) {
        AxisHandler axisHandler = null;
        try {
            axisHandler = jCAxis.logarithmic && (!jCAxis.isPolar() && !jCAxis.isRadar() || jCAxis.vertical) ? (AxisHandler)Class.forName("com.klg.jclass.chart.LogAxisHandler").newInstance() : (AxisHandler)Class.forName("com.klg.jclass.chart.LinearAxisHandler").newInstance();
        }
        catch (Exception exception) {
            axisHandler = null;
        }
        if (axisHandler != null) {
            axisHandler.setParent(jCAxis);
        }
        return axisHandler;
    }

    protected JCAxis getRadialAxis() {
        JCAxis jCAxis = null;
        if (this.parent.isPolar() || this.parent.isRadar()) {
            if (this.parent.vertical) {
                jCAxis = this.parent;
            } else if (this.parent.otherAxis != null) {
                jCAxis = this.parent.otherAxis;
            }
        }
        return jCAxis;
    }

    abstract double toData(int var1);

    abstract JCDataCoord toDataPolar(int var1, int var2);

    abstract int toPixel(double var1);

    abstract double toPixelDouble(double var1);

    abstract Point toPixelPolar(double var1, double var3, boolean var5);

    abstract void calcParams();

    abstract void calcTransformation();

    boolean fixBounds() {
        if (!this.parent.min.isDefault && !this.parent.max.isDefault && this.parent.min.value >= this.parent.max.value) {
            String string = JCChartBundle.string("com.klg.jclass.chart.Key105");
            string = string + JCChartBundle.string("com.klg.jclass.chart.Key130");
            ErrorDialog.raise(this.parent, string);
            this.parent.max.isDefault = true;
            return true;
        }
        return false;
    }

    protected double calcThetaAngle(double d, double d2) {
        double d3;
        double d4 = this.parent.polarAxisParams.getOriginBase(2);
        if (d > 0.0) {
            d3 = d2 < 0.0 ? -Math.atan(d2 / d) : Math.PI * 2 - Math.atan(d2 / d);
        } else if (d < 0.0) {
            d3 = Math.PI - Math.atan(d2 / d);
        } else if (d2 < 0.0) {
            d3 = 1.5707963267948966;
        } else if (d2 > 0.0) {
            d3 = 4.71238898038469;
        } else {
            return Double.MAX_VALUE;
        }
        d3 = JCChartUtil.boundAngle(2, d3 - d4);
        d3 = JCChartUtil.convertAngle(2, this.parent.chartArea.getAngleUnit(), d3);
        return d3;
    }

    JCDataCoord toScreenLocationPolar(double d, double d2, boolean bl) {
        double d3 = -(d + this.parent.polarAxisParams.originBase);
        double d4 = d2 * Math.cos(d3);
        double d5 = d2 * Math.sin(d3);
        if (bl) {
            JCAxis jCAxis = this.parent.vertical ? this.parent : this.parent.otherAxis;
            double d6 = this.scale;
            if ((this.parent.isPolar() || this.parent.isRadar()) && jCAxis.isReversed()) {
                d6 *= -1.0;
            }
            d4 = d6 * d4;
            d5 = d6 * d5;
        }
        return new JCDataCoord(d4 += this.parent.polarAxisParams.xCenter, d5 += this.parent.polarAxisParams.yCenter);
    }

    protected void drawTickMark(Graphics graphics, double d, int n) {
        if (this.parent.isPolar() || this.parent.isRadar() && this.parent.vertical) {
            this.drawTickPolar(graphics, d);
        } else if (!this.parent.isRadar() || this.parent.vertical) {
            if (this.parent.usingDoublePixels) {
                double d2 = this.parent.toPixelDouble(d);
                this.drawTick(graphics, n, d2);
            } else {
                int n2 = this.parent.toPixel(d);
                this.drawTick(graphics, n, n2);
            }
        }
    }

    void drawTicks(Graphics graphics) {
        int n = this.parent.linePosition();
        Vector vector = this.parent.getAnnotations();
        int n2 = 0;
        while (n2 < vector.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)vector.elementAt(n2);
            if (jCValueLabel.getChartText().isVisible()) {
                this.drawTickMark(graphics, jCValueLabel.value, n);
            }
            ++n2;
        }
    }

    protected void drawTick(Graphics graphics, int n, int n2) {
        if (this.parent.vertical) {
            graphics.drawLine(n - this.parent.tickLength / 2, n2, n + this.parent.tickLength / 2, n2);
        } else {
            graphics.drawLine(n2, n - this.parent.tickLength / 2, n2, n + this.parent.tickLength / 2);
        }
    }

    protected void drawTick(Graphics graphics, int n, double d) {
        if (this.parent.vertical) {
            ((Graphics2D)graphics).draw(new Line2D.Double(n - this.parent.tickLength / 2, d, n + this.parent.tickLength / 2, d));
        } else {
            ((Graphics2D)graphics).draw(new Line2D.Double(d, n - this.parent.tickLength / 2, d, n + this.parent.tickLength / 2));
        }
    }

    protected void drawTickPolar(Graphics graphics, double d) {
        Point point = null;
        Point point2 = null;
        if (this.parent.vertical) {
            double d2 = 0.0;
            d2 = this.parent.isLogarithmic() ? (this.parent.isReversed() ? this.scale * (-JCChartUtil.log10(d) + JCChartUtil.log10(this.parent.max.value)) : this.scale * (JCChartUtil.log10(d) - JCChartUtil.log10(this.parent.min.value))) : this.scale * (d - this.parent.min.value);
            double d3 = this.parent.polarAxisParams.rAxisAngle;
            double d4 = this.parent.tickLength / 2;
            double d5 = Math.sqrt(d4 * d4 + d2 * d2);
            double d6 = 0.0;
            if (d5 != 0.0) {
                d6 = Math.asin(d4 / d5);
            }
            point = this.parent.toPixelPolar(d3 + d6, d5, false);
            point2 = this.parent.toPixelPolar(d3 - d6, d5, false);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        } else {
            double d7 = JCChartUtil.convertAngle(this.parent.chartArea.getAngleUnit(), 2, d);
            point = this.parent.toPixelPolar(d7, this.parent.polarAxisParams.radius - (double)this.parent.tickLength / 2.0, false);
            point2 = this.parent.toPixelPolar(d7, this.parent.polarAxisParams.radius + (double)this.parent.tickLength / 2.0, false);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    abstract String format(double var1, int var3);

    abstract double range();

    abstract void translate(double var1);

    abstract void calcPrecision();

    void getAnnoExtent(Dimension dimension, double d, int n) {
        Dimension dimension2;
        JCChart jCChart = this.parent.getParentChart();
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = jCChart.getGraphics() != null ? jCChart.getGraphics().getFontMetrics(this.parent.getFont()) : jCChart.getToolkit().getFontMetrics(this.parent.getFont());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fontMetrics == null) {
            return;
        }
        if (this.parent.labelGenerator != null) {
            Object object = this.parent.labelGenerator.makeLabel(d, n);
            if (object == null) {
                return;
            }
            if (object instanceof ChartText) {
                ChartText chartText = (ChartText)object;
                chartText.setParentChart(this.parent.getParentChart());
                dimension2 = new Dimension(chartText.getWidth(), chartText.getHeight());
            } else {
                String string = object instanceof String ? (String)object : object.toString();
                dimension2 = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
            }
        } else {
            String string = this.format(d, n);
            dimension2 = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
        }
        if (this.parent.annotationRotation == 0) {
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
        } else {
            if (dimension.width < dimension2.height) {
                dimension.width = dimension2.height;
            }
            if (dimension.height < dimension2.width) {
                dimension.height = dimension2.width;
            }
        }
    }
}

