var Scroller = {

	// Variables
	object:null,
	timer:null,
	text:null,
	orginaltext:null,
	position:0,
	isIE:false,
	
	// Start function
	start:function(object) {
	    if(navigator.appName == "Microsoft Internet Explorer"){
		   Scroller.isIE = true;
		}
	
	
		// If we have an old object in scrolling list,
		// remove this one before we start a new one
		if (Scroller.object != null) {
			Scroller.stop();
		}

		// Start new scroller
		Scroller.object = object;
		Scroller.position = 0;
		if(object.getAttribute('value')){
			Scroller.text = object.getAttribute('value').replace(/ /g, "_");
		} else {
			Scroller.text = object.getAttribute('abbr').replace(/ /g, "_");
		}
		if(Scroller.isIE){
			Scroller.orginaltext = object.innerText;
		}else Scroller.orginaltext = object.textContent;

		// Start loop
		Scroller.loop();
	},
		
	// Stop function
	stop:function(object) {
		if(Scroller.isIE)
		{
			Scroller.object.innerText = Scroller.orginaltext;
		}
		else Scroller.object.textContent = Scroller.orginaltext;
		Scroller.object = null;
		clearTimeout(Scroller.timer); 
	},
	
	// Loop function
	loop:function() {
		// If we don't have any element in the obj variable, stop..
		if (Scroller.object == null) return;
		
		
		// Find next position of the string
		Scroller.position++;
		if (Scroller.position > Scroller.text.length-1) Scroller.position = 0;
	
		// Set new text back to the object
		if(Scroller.isIE){
			Scroller.object.innerText = Scroller.text.substr(Scroller.position,30);
		}else{
			Scroller.object.textContent = Scroller.text.substr(Scroller.position,30);
		}
	
		// Set the timer to repeat the function after 140 millis
		Scroller.timer = setTimeout("Scroller.loop()", 140);
	}

};