function toSafeName(itemName) {
	var safeName = itemName.replace(/[,]/g, '-_')
		.replace(/[;]/g, '_-')
		.replace(/[^A-Za-z0-9_-]/g, '__');

	return safeName;
}

function changeType(series, newType) {
	for(var i=0;i<$j(series).length;i++)
	{
		serie = series[0];
		serie.chart.addSeries({
			type: newType,
			name: serie.name,
			color: serie.color,
			data: serie.options.data
		}, false);
		
		serie.remove();
	}
}

function showHistoryPopup(product, feature) {
	var popupDiv = $j('#popupDiv');
	var item = toSafeName(product + ';' + feature);

	var options = {
		chart: {
			renderTo: 'container',
			defaultSeriesType: $j('#chartType').val()
		},
		title: {
			text: 'Title'
		},
		subtitle: {
			text: 'SubTitle'
		},
		credits: {
			enabled: false
		},
		legend: {
			layout: 'vertical',
			align: 'right',
			verticalAlign: 'top',
			x: -10,
			y: 100,
			borderWidth: 0
		},
		xAxis: {
			categories: [],
			labels: {
				rotation: -90,
				align: 'right'
			},
			dateTimeLabelFormats: 
			{
				day: "%b %e"
			}
		},
		yAxis: {
			title: null,
			allowDecimals: false,
			min: 0
		},
		series: []
	};

	var path = '/OpeniT/results/quick_history/' + item + '.csv';
	
	$j("#historylink").click(function(event){
  		event.stopPropagation();  	
	})

	$j.ajax({
		url: path,
		error: function() {
			alert('History data not found.');
		},
		success: function(data) {
			// Split the lines
			var lines = String(data).split('\n');
			// Number of lines
			var lineN = $j(lines).length - 2;

			for( i=3; i <= 4; i++ ) {
				var series = { 
					data: []
				};

				$j.each(lines, function(lineNo, line) {
					var items = line.split(',');
					// header line contains the series fields 3 and 4
					if (lineNo == 0) {
						series.name = items[i];
					}
					// the rest of the lines contain data with their categories in the first position
					// and fields 3 and 4 their respective data
					else {
						if (line != '' ) {
							options.xAxis.categories.push(items[0]);
							series.data.push(parseFloat(items[i]));
						}
					}
				});
				options.title.text='Last ' + lineN + ' days for ' + feature;
				options.subtitle.text=product;
				options.series.push(series);
			}
			var chart = new Highcharts.Chart(options, function(chart) {
				$j('#chartType').change(function(){
					changeType(chart.series, this.value);
				});
			});
			
			$j(popupDiv).dialog({
				minWidth: 800 + (lineN * 4),
				minHeight: 450 + (lineN * 4),
				title: feature,
				modal: true,
				close: function(event, ui) {
					$j('.highcharts-container').remove();
					$j(popupDiv).dialog('destroy');
				},
				open: function(event, ui) {
					chart.setSize(
						this.offsetWidth - 50,
						this.offsetHeight - 50,
						true
					);
				},
				resize: function(event, ui) {
					chart.setSize(
						this.offsetWidth - 50,
						this.offsetHeight - 50,
						false
					);
				}
			});
		}
	});
};