/*
(C) Glenn O Larsen <glenn@europlan.no> | Version: 1.2
*/


// Object code
var ajaxManagerSingelton = null;
function AjaxManager() {

	// Constants
	this.GET = "GET";
	this.POST = "POST";
	this.XML = 0;
	this.HTML = 1;
	
	// Singelton
	if (ajaxManagerSingelton) {
		return ajaxManagerSingelton;
	}
	ajaxManagerSingelton = this;

	// Variables
	var connections = Array();	
	var uniqID;
	var callList;
	
	// Make connections public
	this.connections = connections;

	// Add methods to the object
	this.addCallout=ajaxmanager_addCallout;
	this.call=ajaxmanager_call;
		
	// INIT
	this.objectName = "AJAX";
	this.uniqID = Math.round(Math.random() * 100000);
	this.callList = Array();
	

}

// Methods that should be used with AjaxManager
function ajaxmanager_addCallout(methodeName, returnMethodeName, URL, postMethode, requestType) {
	if (!this.objectName) return;
	this.callList[methodeName] = Array(returnMethodeName, URL, postMethode, requestType);
}

function ajaxmanager_call(methodeName) {
	
	// Create a connection
	try {
		this.connections[methodeName] = new ActiveXObject("Msxml2.XMLHTTP");
	} catch (e) {
		try {
			this.connections[methodeName] = new ActiveXObject("Microsoft.XMLHTTP");
		} catch (oc) {
			this.connections[methodeName] = null;
		}
	}
	
	// Init the object
	if (!this.connections[methodeName] && typeof XMLHttpRequest != "undefined") {
		this.connections[methodeName] = new XMLHttpRequest();
	} else if (!this.connections[methodeName]) {
		alert("Could not create connection object.");
		return false;
	}

	if (!this.objectName) return;
	if (!this.callList[methodeName][1]) alert("Not callable!");
	
	var send;	
	
	this.connections[methodeName].onreadystatechange = function() {
	var ajaxManager = AjaxManager();

		if (ajaxManager.connections[methodeName].readyState == 4) {
			
			if (ajaxManager.connections[methodeName].status != 200) {
				alert("Error Receiving Data\n\nA problem occured while receiving data. This could be due to a temporary network problem.\nIf the error remains please contact your system administrator.\n\nOpen iT Error Number: " + ajaxManager.connections[methodeName].status);
				return;
			}
	
			var callbackObject = ajaxManager.callList[methodeName][0];
			if (ajaxManager.callList[methodeName][3] == ajaxManager.XML) {
				var responseData = ajaxManager.connections[methodeName].responseXML;
			} else {
				var responseData = ajaxManager.connections[methodeName].responseText;
			}		
			
			if (!callbackObject && responseData == "") {
				alert("Kan ikke finne return metode!");
			}
			callbackObject(methodeName, responseData);		
			
		}
	}	
	
	
	// Send request
	if (this.callList[methodeName][2] == this.GET) {
		var hasQuestionMark = (this.callList[methodeName][1].indexOf("?") >= 1) ? true : false;
		var args = this.callList[methodeName][1] + ((hasQuestionMark) ? "&" : "?") + "methode=" + methodeName;
		for (i=1; i<ajaxmanager_call.arguments.length; i++) 
			args += "&" + (ajaxmanager_call.arguments[i]);
		args += "&uniqTimeStamp=" + new Date().getTime();
		this.connections[methodeName].open(this.GET, args, true);
		//this.connections[methodeName].setContentType("text/xml");
		send = null;
	} else {
		send = "methode=" + methodeName;
		for (i=1; i<ajaxmanager_call.arguments.length; i++) 
			send += "&" + (ajaxmanager_call.arguments[i]);
		send += "&uniqTimeStamp=" + new Date().getTime();	
		this.connections[methodeName].open(this.POST, this.callList[methodeName][1], true);
		this.connections[methodeName].setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
	}
	
	this.connections[methodeName].send(send);

}
